<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelRef StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelRef extends AbstractStructBase
{
    /**
     * The ChainCode
     * @var string
     */
    public $ChainCode;
    /**
     * The BrandCode
     * @var string
     */
    public $BrandCode;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCityCode
     * @var string
     */
    public $HotelCityCode;
    /**
     * The AddressLine
     * @var string
     */
    public $AddressLine;
    /**
     * The LocationName
     * @var string
     */
    public $LocationName;
    /**
     * The ZipCode
     * @var string
     */
    public $ZipCode;
    /**
     * The CountryCode
     * @var string
     */
    public $CountryCode;
    /**
     * The HotelName
     * @var string
     */
    public $HotelName;
    /**
     * The HotelCodeContext
     * @var string
     */
    public $HotelCodeContext;
    /**
     * The ChainName
     * @var string
     */
    public $ChainName;
    /**
     * The BrandName
     * @var string
     */
    public $BrandName;
    /**
     * The SegmentCategoryCode
     * @var string
     */
    public $SegmentCategoryCode;
    /**
     * The PropertyClassCode
     * @var string
     */
    public $PropertyClassCode;
    /**
     * The ArchitecturalStyleCode
     * @var string
     */
    public $ArchitecturalStyleCode;
    /**
     * The SupplierIntegrationLevel
     * @var int
     */
    public $SupplierIntegrationLevel;
    /**
     * The LocationCategoryCode
     * @var string
     */
    public $LocationCategoryCode;
    /**
     * The ExtendedCitySearchIndicator
     * @var bool
     */
    public $ExtendedCitySearchIndicator;
    /**
     * Constructor method for HotelRef
     * @uses DgHotelRef::setChainCode()
     * @uses DgHotelRef::setBrandCode()
     * @uses DgHotelRef::setHotelCode()
     * @uses DgHotelRef::setHotelCityCode()
     * @uses DgHotelRef::setAddressLine()
     * @uses DgHotelRef::setLocationName()
     * @uses DgHotelRef::setZipCode()
     * @uses DgHotelRef::setCountryCode()
     * @uses DgHotelRef::setHotelName()
     * @uses DgHotelRef::setHotelCodeContext()
     * @uses DgHotelRef::setChainName()
     * @uses DgHotelRef::setBrandName()
     * @uses DgHotelRef::setSegmentCategoryCode()
     * @uses DgHotelRef::setPropertyClassCode()
     * @uses DgHotelRef::setArchitecturalStyleCode()
     * @uses DgHotelRef::setSupplierIntegrationLevel()
     * @uses DgHotelRef::setLocationCategoryCode()
     * @uses DgHotelRef::setExtendedCitySearchIndicator()
     * @param string $chainCode
     * @param string $brandCode
     * @param string $hotelCode
     * @param string $hotelCityCode
     * @param string $addressLine
     * @param string $locationName
     * @param string $zipCode
     * @param string $countryCode
     * @param string $hotelName
     * @param string $hotelCodeContext
     * @param string $chainName
     * @param string $brandName
     * @param string $segmentCategoryCode
     * @param string $propertyClassCode
     * @param string $architecturalStyleCode
     * @param int $supplierIntegrationLevel
     * @param string $locationCategoryCode
     * @param bool $extendedCitySearchIndicator
     */
    public function __construct($chainCode = null, $brandCode = null, $hotelCode = null, $hotelCityCode = null, $addressLine = null, $locationName = null, $zipCode = null, $countryCode = null, $hotelName = null, $hotelCodeContext = null, $chainName = null, $brandName = null, $segmentCategoryCode = null, $propertyClassCode = null, $architecturalStyleCode = null, $supplierIntegrationLevel = null, $locationCategoryCode = null, $extendedCitySearchIndicator = null)
    {
        $this
            ->setChainCode($chainCode)
            ->setBrandCode($brandCode)
            ->setHotelCode($hotelCode)
            ->setHotelCityCode($hotelCityCode)
            ->setAddressLine($addressLine)
            ->setLocationName($locationName)
            ->setZipCode($zipCode)
            ->setCountryCode($countryCode)
            ->setHotelName($hotelName)
            ->setHotelCodeContext($hotelCodeContext)
            ->setChainName($chainName)
            ->setBrandName($brandName)
            ->setSegmentCategoryCode($segmentCategoryCode)
            ->setPropertyClassCode($propertyClassCode)
            ->setArchitecturalStyleCode($architecturalStyleCode)
            ->setSupplierIntegrationLevel($supplierIntegrationLevel)
            ->setLocationCategoryCode($locationCategoryCode)
            ->setExtendedCitySearchIndicator($extendedCitySearchIndicator);
    }
    /**
     * Get ChainCode value
     * @return string|null
     */
    public function getChainCode()
    {
        return $this->ChainCode;
    }
    /**
     * Set ChainCode value
     * @param string $chainCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setChainCode($chainCode = null)
    {
        // validation for constraint: string
        if (!is_null($chainCode) && !is_string($chainCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chainCode)), __LINE__);
        }
        $this->ChainCode = $chainCode;
        return $this;
    }
    /**
     * Get BrandCode value
     * @return string|null
     */
    public function getBrandCode()
    {
        return $this->BrandCode;
    }
    /**
     * Set BrandCode value
     * @param string $brandCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setBrandCode($brandCode = null)
    {
        // validation for constraint: string
        if (!is_null($brandCode) && !is_string($brandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandCode)), __LINE__);
        }
        $this->BrandCode = $brandCode;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCityCode value
     * @return string|null
     */
    public function getHotelCityCode()
    {
        return $this->HotelCityCode;
    }
    /**
     * Set HotelCityCode value
     * @param string $hotelCityCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setHotelCityCode($hotelCityCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCityCode) && !is_string($hotelCityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCityCode)), __LINE__);
        }
        $this->HotelCityCode = $hotelCityCode;
        return $this;
    }
    /**
     * Get AddressLine value
     * @return string|null
     */
    public function getAddressLine()
    {
        return $this->AddressLine;
    }
    /**
     * Set AddressLine value
     * @param string $addressLine
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setAddressLine($addressLine = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine) && !is_string($addressLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressLine)), __LINE__);
        }
        $this->AddressLine = $addressLine;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setLocationName($locationName = null)
    {
        // validation for constraint: string
        if (!is_null($locationName) && !is_string($locationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationName)), __LINE__);
        }
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get HotelName value
     * @return string|null
     */
    public function getHotelName()
    {
        return $this->HotelName;
    }
    /**
     * Set HotelName value
     * @param string $hotelName
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setHotelName($hotelName = null)
    {
        // validation for constraint: string
        if (!is_null($hotelName) && !is_string($hotelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelName)), __LINE__);
        }
        $this->HotelName = $hotelName;
        return $this;
    }
    /**
     * Get HotelCodeContext value
     * @return string|null
     */
    public function getHotelCodeContext()
    {
        return $this->HotelCodeContext;
    }
    /**
     * Set HotelCodeContext value
     * @param string $hotelCodeContext
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setHotelCodeContext($hotelCodeContext = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeContext) && !is_string($hotelCodeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCodeContext)), __LINE__);
        }
        $this->HotelCodeContext = $hotelCodeContext;
        return $this;
    }
    /**
     * Get ChainName value
     * @return string|null
     */
    public function getChainName()
    {
        return $this->ChainName;
    }
    /**
     * Set ChainName value
     * @param string $chainName
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setChainName($chainName = null)
    {
        // validation for constraint: string
        if (!is_null($chainName) && !is_string($chainName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chainName)), __LINE__);
        }
        $this->ChainName = $chainName;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get SegmentCategoryCode value
     * @return string|null
     */
    public function getSegmentCategoryCode()
    {
        return $this->SegmentCategoryCode;
    }
    /**
     * Set SegmentCategoryCode value
     * @param string $segmentCategoryCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setSegmentCategoryCode($segmentCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($segmentCategoryCode) && !is_string($segmentCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($segmentCategoryCode)), __LINE__);
        }
        $this->SegmentCategoryCode = $segmentCategoryCode;
        return $this;
    }
    /**
     * Get PropertyClassCode value
     * @return string|null
     */
    public function getPropertyClassCode()
    {
        return $this->PropertyClassCode;
    }
    /**
     * Set PropertyClassCode value
     * @param string $propertyClassCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setPropertyClassCode($propertyClassCode = null)
    {
        // validation for constraint: string
        if (!is_null($propertyClassCode) && !is_string($propertyClassCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyClassCode)), __LINE__);
        }
        $this->PropertyClassCode = $propertyClassCode;
        return $this;
    }
    /**
     * Get ArchitecturalStyleCode value
     * @return string|null
     */
    public function getArchitecturalStyleCode()
    {
        return $this->ArchitecturalStyleCode;
    }
    /**
     * Set ArchitecturalStyleCode value
     * @param string $architecturalStyleCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setArchitecturalStyleCode($architecturalStyleCode = null)
    {
        // validation for constraint: string
        if (!is_null($architecturalStyleCode) && !is_string($architecturalStyleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($architecturalStyleCode)), __LINE__);
        }
        $this->ArchitecturalStyleCode = $architecturalStyleCode;
        return $this;
    }
    /**
     * Get SupplierIntegrationLevel value
     * @return int|null
     */
    public function getSupplierIntegrationLevel()
    {
        return $this->SupplierIntegrationLevel;
    }
    /**
     * Set SupplierIntegrationLevel value
     * @param int $supplierIntegrationLevel
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setSupplierIntegrationLevel($supplierIntegrationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($supplierIntegrationLevel) && !is_numeric($supplierIntegrationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($supplierIntegrationLevel)), __LINE__);
        }
        $this->SupplierIntegrationLevel = $supplierIntegrationLevel;
        return $this;
    }
    /**
     * Get LocationCategoryCode value
     * @return string|null
     */
    public function getLocationCategoryCode()
    {
        return $this->LocationCategoryCode;
    }
    /**
     * Set LocationCategoryCode value
     * @param string $locationCategoryCode
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setLocationCategoryCode($locationCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCategoryCode) && !is_string($locationCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCategoryCode)), __LINE__);
        }
        $this->LocationCategoryCode = $locationCategoryCode;
        return $this;
    }
    /**
     * Get ExtendedCitySearchIndicator value
     * @return bool|null
     */
    public function getExtendedCitySearchIndicator()
    {
        return $this->ExtendedCitySearchIndicator;
    }
    /**
     * Set ExtendedCitySearchIndicator value
     * @param bool $extendedCitySearchIndicator
     * @return \dgsoft\StructType\DgHotelRef
     */
    public function setExtendedCitySearchIndicator($extendedCitySearchIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedCitySearchIndicator) && !is_bool($extendedCitySearchIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extendedCitySearchIndicator)), __LINE__);
        }
        $this->ExtendedCitySearchIndicator = $extendedCitySearchIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelRef
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
