<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelPrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgHotelPrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The HotelChainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNamePrefType[]
     */
    public $HotelChainPref;
    /**
     * The PropertyNamePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPropertyNamePrefType[]
     */
    public $PropertyNamePref;
    /**
     * The PropertyLocationPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPropertyLocationPrefType[]
     */
    public $PropertyLocationPref;
    /**
     * The PropertyTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPropertyTypePrefType[]
     */
    public $PropertyTypePref;
    /**
     * The PropertyClassPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPropertyClassPrefType[]
     */
    public $PropertyClassPref;
    /**
     * The PropertyAmenityPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPropertyAmenityPrefType[]
     */
    public $PropertyAmenityPref;
    /**
     * The RoomAmenityPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomAmenityPrefType[]
     */
    public $RoomAmenityPref;
    /**
     * The RoomLocationPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRoomLocationPrefType[]
     */
    public $RoomLocationPref;
    /**
     * The BedTypePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBedTypePrefType[]
     */
    public $BedTypePref;
    /**
     * The FoodSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFoodSrvcPrefType[]
     */
    public $FoodSrvcPref;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMealPrefType[]
     */
    public $MealPref;
    /**
     * The RecreationSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRecreationSrvcPrefType[]
     */
    public $RecreationSrvcPref;
    /**
     * The BusinessSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBusinessSrvcPrefType[]
     */
    public $BusinessSrvcPref;
    /**
     * The PersonalSrvcPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonalSrvcPrefType[]
     */
    public $PersonalSrvcPref;
    /**
     * The SecurityFeaturePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSecurityFeaturePrefType[]
     */
    public $SecurityFeaturePref;
    /**
     * The PhysChallFeaturePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPhysChallFeaturePrefType[]
     */
    public $PhysChallFeaturePref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The HotelGuestType
     * @var string
     */
    public $HotelGuestType;
    /**
     * Constructor method for HotelPrefType
     * @uses DgHotelPrefType::setLoyaltyPref()
     * @uses DgHotelPrefType::setPaymentFormPref()
     * @uses DgHotelPrefType::setHotelChainPref()
     * @uses DgHotelPrefType::setPropertyNamePref()
     * @uses DgHotelPrefType::setPropertyLocationPref()
     * @uses DgHotelPrefType::setPropertyTypePref()
     * @uses DgHotelPrefType::setPropertyClassPref()
     * @uses DgHotelPrefType::setPropertyAmenityPref()
     * @uses DgHotelPrefType::setRoomAmenityPref()
     * @uses DgHotelPrefType::setRoomLocationPref()
     * @uses DgHotelPrefType::setBedTypePref()
     * @uses DgHotelPrefType::setFoodSrvcPref()
     * @uses DgHotelPrefType::setMediaEntertainPref()
     * @uses DgHotelPrefType::setPetInfoPref()
     * @uses DgHotelPrefType::setMealPref()
     * @uses DgHotelPrefType::setRecreationSrvcPref()
     * @uses DgHotelPrefType::setBusinessSrvcPref()
     * @uses DgHotelPrefType::setPersonalSrvcPref()
     * @uses DgHotelPrefType::setSecurityFeaturePref()
     * @uses DgHotelPrefType::setPhysChallFeaturePref()
     * @uses DgHotelPrefType::setSpecRequestPref()
     * @uses DgHotelPrefType::setTPA_Extensions()
     * @uses DgHotelPrefType::setPreferLevel()
     * @uses DgHotelPrefType::setShareSynchInd()
     * @uses DgHotelPrefType::setShareMarketInd()
     * @uses DgHotelPrefType::setSmokingAllowed()
     * @uses DgHotelPrefType::setRatePlanCode()
     * @uses DgHotelPrefType::setHotelGuestType()
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $hotelChainPref
     * @param \dgsoft\StructType\DgPropertyNamePrefType[] $propertyNamePref
     * @param \dgsoft\StructType\DgPropertyLocationPrefType[] $propertyLocationPref
     * @param \dgsoft\StructType\DgPropertyTypePrefType[] $propertyTypePref
     * @param \dgsoft\StructType\DgPropertyClassPrefType[] $propertyClassPref
     * @param \dgsoft\StructType\DgPropertyAmenityPrefType[] $propertyAmenityPref
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $roomAmenityPref
     * @param \dgsoft\StructType\DgRoomLocationPrefType[] $roomLocationPref
     * @param \dgsoft\StructType\DgBedTypePrefType[] $bedTypePref
     * @param \dgsoft\StructType\DgFoodSrvcPrefType[] $foodSrvcPref
     * @param \dgsoft\StructType\DgMediaEntertainPrefType[] $mediaEntertainPref
     * @param \dgsoft\StructType\DgPetInfoPrefType[] $petInfoPref
     * @param \dgsoft\StructType\DgMealPrefType[] $mealPref
     * @param \dgsoft\StructType\DgRecreationSrvcPrefType[] $recreationSrvcPref
     * @param \dgsoft\StructType\DgBusinessSrvcPrefType[] $businessSrvcPref
     * @param \dgsoft\StructType\DgPersonalSrvcPrefType[] $personalSrvcPref
     * @param \dgsoft\StructType\DgSecurityFeaturePrefType[] $securityFeaturePref
     * @param \dgsoft\StructType\DgPhysChallFeaturePrefType[] $physChallFeaturePref
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $preferLevel
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param string $ratePlanCode
     * @param string $hotelGuestType
     */
    public function __construct(array $loyaltyPref = array(), array $paymentFormPref = array(), array $hotelChainPref = array(), array $propertyNamePref = array(), array $propertyLocationPref = array(), array $propertyTypePref = array(), array $propertyClassPref = array(), array $propertyAmenityPref = array(), array $roomAmenityPref = array(), array $roomLocationPref = array(), array $bedTypePref = array(), array $foodSrvcPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $recreationSrvcPref = array(), array $businessSrvcPref = array(), array $personalSrvcPref = array(), array $securityFeaturePref = array(), array $physChallFeaturePref = array(), array $specRequestPref = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $preferLevel = 'Preferred', $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $ratePlanCode = null, $hotelGuestType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setHotelChainPref($hotelChainPref)
            ->setPropertyNamePref($propertyNamePref)
            ->setPropertyLocationPref($propertyLocationPref)
            ->setPropertyTypePref($propertyTypePref)
            ->setPropertyClassPref($propertyClassPref)
            ->setPropertyAmenityPref($propertyAmenityPref)
            ->setRoomAmenityPref($roomAmenityPref)
            ->setRoomLocationPref($roomLocationPref)
            ->setBedTypePref($bedTypePref)
            ->setFoodSrvcPref($foodSrvcPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setRecreationSrvcPref($recreationSrvcPref)
            ->setBusinessSrvcPref($businessSrvcPref)
            ->setPersonalSrvcPref($personalSrvcPref)
            ->setSecurityFeaturePref($securityFeaturePref)
            ->setPhysChallFeaturePref($physChallFeaturePref)
            ->setSpecRequestPref($specRequestPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPreferLevel($preferLevel)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setRatePlanCode($ratePlanCode)
            ->setHotelGuestType($hotelGuestType);
    }
    /**
     * Get LoyaltyPref value
     * @return \dgsoft\StructType\DgLoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $hotelPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeLoyaltyPrefItem instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($hotelPrefTypeLoyaltyPrefItem) ? get_class($hotelPrefTypeLoyaltyPrefItem) : gettype($hotelPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToLoyaltyPref(\dgsoft\StructType\DgLoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \dgsoft\StructType\DgPaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $hotelPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePaymentFormPrefItem instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($hotelPrefTypePaymentFormPrefItem) ? get_class($hotelPrefTypePaymentFormPrefItem) : gettype($hotelPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPaymentFormPref(\dgsoft\StructType\DgPaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get HotelChainPref value
     * @return \dgsoft\StructType\DgCompanyNamePrefType[]|null
     */
    public function getHotelChainPref()
    {
        return $this->HotelChainPref;
    }
    /**
     * Set HotelChainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType[] $hotelChainPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setHotelChainPref(array $hotelChainPref = array())
    {
        foreach ($hotelChainPref as $hotelPrefTypeHotelChainPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeHotelChainPrefItem instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The HotelChainPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($hotelPrefTypeHotelChainPrefItem) ? get_class($hotelPrefTypeHotelChainPrefItem) : gettype($hotelPrefTypeHotelChainPrefItem)), __LINE__);
            }
        }
        $this->HotelChainPref = $hotelChainPref;
        return $this;
    }
    /**
     * Add item to HotelChainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNamePrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToHotelChainPref(\dgsoft\StructType\DgCompanyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The HotelChainPref property can only contain items of \dgsoft\StructType\DgCompanyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->HotelChainPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyNamePref value
     * @return \dgsoft\StructType\DgPropertyNamePrefType[]|null
     */
    public function getPropertyNamePref()
    {
        return $this->PropertyNamePref;
    }
    /**
     * Set PropertyNamePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyNamePrefType[] $propertyNamePref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPropertyNamePref(array $propertyNamePref = array())
    {
        foreach ($propertyNamePref as $hotelPrefTypePropertyNamePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyNamePrefItem instanceof \dgsoft\StructType\DgPropertyNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyNamePref property can only contain items of \dgsoft\StructType\DgPropertyNamePrefType, "%s" given', is_object($hotelPrefTypePropertyNamePrefItem) ? get_class($hotelPrefTypePropertyNamePrefItem) : gettype($hotelPrefTypePropertyNamePrefItem)), __LINE__);
            }
        }
        $this->PropertyNamePref = $propertyNamePref;
        return $this;
    }
    /**
     * Add item to PropertyNamePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyNamePrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPropertyNamePref(\dgsoft\StructType\DgPropertyNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPropertyNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyNamePref property can only contain items of \dgsoft\StructType\DgPropertyNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyNamePref[] = $item;
        return $this;
    }
    /**
     * Get PropertyLocationPref value
     * @return \dgsoft\StructType\DgPropertyLocationPrefType[]|null
     */
    public function getPropertyLocationPref()
    {
        return $this->PropertyLocationPref;
    }
    /**
     * Set PropertyLocationPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyLocationPrefType[] $propertyLocationPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPropertyLocationPref(array $propertyLocationPref = array())
    {
        foreach ($propertyLocationPref as $hotelPrefTypePropertyLocationPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyLocationPrefItem instanceof \dgsoft\StructType\DgPropertyLocationPrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyLocationPref property can only contain items of \dgsoft\StructType\DgPropertyLocationPrefType, "%s" given', is_object($hotelPrefTypePropertyLocationPrefItem) ? get_class($hotelPrefTypePropertyLocationPrefItem) : gettype($hotelPrefTypePropertyLocationPrefItem)), __LINE__);
            }
        }
        $this->PropertyLocationPref = $propertyLocationPref;
        return $this;
    }
    /**
     * Add item to PropertyLocationPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyLocationPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPropertyLocationPref(\dgsoft\StructType\DgPropertyLocationPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPropertyLocationPrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyLocationPref property can only contain items of \dgsoft\StructType\DgPropertyLocationPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyLocationPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyTypePref value
     * @return \dgsoft\StructType\DgPropertyTypePrefType[]|null
     */
    public function getPropertyTypePref()
    {
        return $this->PropertyTypePref;
    }
    /**
     * Set PropertyTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyTypePrefType[] $propertyTypePref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPropertyTypePref(array $propertyTypePref = array())
    {
        foreach ($propertyTypePref as $hotelPrefTypePropertyTypePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyTypePrefItem instanceof \dgsoft\StructType\DgPropertyTypePrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyTypePref property can only contain items of \dgsoft\StructType\DgPropertyTypePrefType, "%s" given', is_object($hotelPrefTypePropertyTypePrefItem) ? get_class($hotelPrefTypePropertyTypePrefItem) : gettype($hotelPrefTypePropertyTypePrefItem)), __LINE__);
            }
        }
        $this->PropertyTypePref = $propertyTypePref;
        return $this;
    }
    /**
     * Add item to PropertyTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyTypePrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPropertyTypePref(\dgsoft\StructType\DgPropertyTypePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPropertyTypePrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyTypePref property can only contain items of \dgsoft\StructType\DgPropertyTypePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyTypePref[] = $item;
        return $this;
    }
    /**
     * Get PropertyClassPref value
     * @return \dgsoft\StructType\DgPropertyClassPrefType[]|null
     */
    public function getPropertyClassPref()
    {
        return $this->PropertyClassPref;
    }
    /**
     * Set PropertyClassPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyClassPrefType[] $propertyClassPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPropertyClassPref(array $propertyClassPref = array())
    {
        foreach ($propertyClassPref as $hotelPrefTypePropertyClassPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyClassPrefItem instanceof \dgsoft\StructType\DgPropertyClassPrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyClassPref property can only contain items of \dgsoft\StructType\DgPropertyClassPrefType, "%s" given', is_object($hotelPrefTypePropertyClassPrefItem) ? get_class($hotelPrefTypePropertyClassPrefItem) : gettype($hotelPrefTypePropertyClassPrefItem)), __LINE__);
            }
        }
        $this->PropertyClassPref = $propertyClassPref;
        return $this;
    }
    /**
     * Add item to PropertyClassPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyClassPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPropertyClassPref(\dgsoft\StructType\DgPropertyClassPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPropertyClassPrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyClassPref property can only contain items of \dgsoft\StructType\DgPropertyClassPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyClassPref[] = $item;
        return $this;
    }
    /**
     * Get PropertyAmenityPref value
     * @return \dgsoft\StructType\DgPropertyAmenityPrefType[]|null
     */
    public function getPropertyAmenityPref()
    {
        return $this->PropertyAmenityPref;
    }
    /**
     * Set PropertyAmenityPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyAmenityPrefType[] $propertyAmenityPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPropertyAmenityPref(array $propertyAmenityPref = array())
    {
        foreach ($propertyAmenityPref as $hotelPrefTypePropertyAmenityPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePropertyAmenityPrefItem instanceof \dgsoft\StructType\DgPropertyAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The PropertyAmenityPref property can only contain items of \dgsoft\StructType\DgPropertyAmenityPrefType, "%s" given', is_object($hotelPrefTypePropertyAmenityPrefItem) ? get_class($hotelPrefTypePropertyAmenityPrefItem) : gettype($hotelPrefTypePropertyAmenityPrefItem)), __LINE__);
            }
        }
        $this->PropertyAmenityPref = $propertyAmenityPref;
        return $this;
    }
    /**
     * Add item to PropertyAmenityPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPropertyAmenityPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPropertyAmenityPref(\dgsoft\StructType\DgPropertyAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPropertyAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The PropertyAmenityPref property can only contain items of \dgsoft\StructType\DgPropertyAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PropertyAmenityPref[] = $item;
        return $this;
    }
    /**
     * Get RoomAmenityPref value
     * @return \dgsoft\StructType\DgRoomAmenityPrefType[]|null
     */
    public function getRoomAmenityPref()
    {
        return $this->RoomAmenityPref;
    }
    /**
     * Set RoomAmenityPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType[] $roomAmenityPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setRoomAmenityPref(array $roomAmenityPref = array())
    {
        foreach ($roomAmenityPref as $hotelPrefTypeRoomAmenityPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeRoomAmenityPrefItem instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
                throw new \InvalidArgumentException(sprintf('The RoomAmenityPref property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($hotelPrefTypeRoomAmenityPrefItem) ? get_class($hotelPrefTypeRoomAmenityPrefItem) : gettype($hotelPrefTypeRoomAmenityPrefItem)), __LINE__);
            }
        }
        $this->RoomAmenityPref = $roomAmenityPref;
        return $this;
    }
    /**
     * Add item to RoomAmenityPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomAmenityPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToRoomAmenityPref(\dgsoft\StructType\DgRoomAmenityPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomAmenityPrefType) {
            throw new \InvalidArgumentException(sprintf('The RoomAmenityPref property can only contain items of \dgsoft\StructType\DgRoomAmenityPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomAmenityPref[] = $item;
        return $this;
    }
    /**
     * Get RoomLocationPref value
     * @return \dgsoft\StructType\DgRoomLocationPrefType[]|null
     */
    public function getRoomLocationPref()
    {
        return $this->RoomLocationPref;
    }
    /**
     * Set RoomLocationPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomLocationPrefType[] $roomLocationPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setRoomLocationPref(array $roomLocationPref = array())
    {
        foreach ($roomLocationPref as $hotelPrefTypeRoomLocationPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeRoomLocationPrefItem instanceof \dgsoft\StructType\DgRoomLocationPrefType) {
                throw new \InvalidArgumentException(sprintf('The RoomLocationPref property can only contain items of \dgsoft\StructType\DgRoomLocationPrefType, "%s" given', is_object($hotelPrefTypeRoomLocationPrefItem) ? get_class($hotelPrefTypeRoomLocationPrefItem) : gettype($hotelPrefTypeRoomLocationPrefItem)), __LINE__);
            }
        }
        $this->RoomLocationPref = $roomLocationPref;
        return $this;
    }
    /**
     * Add item to RoomLocationPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRoomLocationPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToRoomLocationPref(\dgsoft\StructType\DgRoomLocationPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRoomLocationPrefType) {
            throw new \InvalidArgumentException(sprintf('The RoomLocationPref property can only contain items of \dgsoft\StructType\DgRoomLocationPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RoomLocationPref[] = $item;
        return $this;
    }
    /**
     * Get BedTypePref value
     * @return \dgsoft\StructType\DgBedTypePrefType[]|null
     */
    public function getBedTypePref()
    {
        return $this->BedTypePref;
    }
    /**
     * Set BedTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBedTypePrefType[] $bedTypePref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setBedTypePref(array $bedTypePref = array())
    {
        foreach ($bedTypePref as $hotelPrefTypeBedTypePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeBedTypePrefItem instanceof \dgsoft\StructType\DgBedTypePrefType) {
                throw new \InvalidArgumentException(sprintf('The BedTypePref property can only contain items of \dgsoft\StructType\DgBedTypePrefType, "%s" given', is_object($hotelPrefTypeBedTypePrefItem) ? get_class($hotelPrefTypeBedTypePrefItem) : gettype($hotelPrefTypeBedTypePrefItem)), __LINE__);
            }
        }
        $this->BedTypePref = $bedTypePref;
        return $this;
    }
    /**
     * Add item to BedTypePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBedTypePrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToBedTypePref(\dgsoft\StructType\DgBedTypePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgBedTypePrefType) {
            throw new \InvalidArgumentException(sprintf('The BedTypePref property can only contain items of \dgsoft\StructType\DgBedTypePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BedTypePref[] = $item;
        return $this;
    }
    /**
     * Get FoodSrvcPref value
     * @return \dgsoft\StructType\DgFoodSrvcPrefType[]|null
     */
    public function getFoodSrvcPref()
    {
        return $this->FoodSrvcPref;
    }
    /**
     * Set FoodSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFoodSrvcPrefType[] $foodSrvcPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setFoodSrvcPref(array $foodSrvcPref = array())
    {
        foreach ($foodSrvcPref as $hotelPrefTypeFoodSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeFoodSrvcPrefItem instanceof \dgsoft\StructType\DgFoodSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The FoodSrvcPref property can only contain items of \dgsoft\StructType\DgFoodSrvcPrefType, "%s" given', is_object($hotelPrefTypeFoodSrvcPrefItem) ? get_class($hotelPrefTypeFoodSrvcPrefItem) : gettype($hotelPrefTypeFoodSrvcPrefItem)), __LINE__);
            }
        }
        $this->FoodSrvcPref = $foodSrvcPref;
        return $this;
    }
    /**
     * Add item to FoodSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFoodSrvcPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToFoodSrvcPref(\dgsoft\StructType\DgFoodSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFoodSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The FoodSrvcPref property can only contain items of \dgsoft\StructType\DgFoodSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FoodSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \dgsoft\StructType\DgMediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMediaEntertainPrefType[] $mediaEntertainPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $hotelPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeMediaEntertainPrefItem instanceof \dgsoft\StructType\DgMediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \dgsoft\StructType\DgMediaEntertainPrefType, "%s" given', is_object($hotelPrefTypeMediaEntertainPrefItem) ? get_class($hotelPrefTypeMediaEntertainPrefItem) : gettype($hotelPrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMediaEntertainPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToMediaEntertainPref(\dgsoft\StructType\DgMediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \dgsoft\StructType\DgMediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \dgsoft\StructType\DgPetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPetInfoPrefType[] $petInfoPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $hotelPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePetInfoPrefItem instanceof \dgsoft\StructType\DgPetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \dgsoft\StructType\DgPetInfoPrefType, "%s" given', is_object($hotelPrefTypePetInfoPrefItem) ? get_class($hotelPrefTypePetInfoPrefItem) : gettype($hotelPrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPetInfoPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPetInfoPref(\dgsoft\StructType\DgPetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \dgsoft\StructType\DgPetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \dgsoft\StructType\DgMealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMealPrefType[] $mealPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $hotelPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeMealPrefItem instanceof \dgsoft\StructType\DgMealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \dgsoft\StructType\DgMealPrefType, "%s" given', is_object($hotelPrefTypeMealPrefItem) ? get_class($hotelPrefTypeMealPrefItem) : gettype($hotelPrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMealPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToMealPref(\dgsoft\StructType\DgMealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \dgsoft\StructType\DgMealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get RecreationSrvcPref value
     * @return \dgsoft\StructType\DgRecreationSrvcPrefType[]|null
     */
    public function getRecreationSrvcPref()
    {
        return $this->RecreationSrvcPref;
    }
    /**
     * Set RecreationSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRecreationSrvcPrefType[] $recreationSrvcPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setRecreationSrvcPref(array $recreationSrvcPref = array())
    {
        foreach ($recreationSrvcPref as $hotelPrefTypeRecreationSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeRecreationSrvcPrefItem instanceof \dgsoft\StructType\DgRecreationSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The RecreationSrvcPref property can only contain items of \dgsoft\StructType\DgRecreationSrvcPrefType, "%s" given', is_object($hotelPrefTypeRecreationSrvcPrefItem) ? get_class($hotelPrefTypeRecreationSrvcPrefItem) : gettype($hotelPrefTypeRecreationSrvcPrefItem)), __LINE__);
            }
        }
        $this->RecreationSrvcPref = $recreationSrvcPref;
        return $this;
    }
    /**
     * Add item to RecreationSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRecreationSrvcPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToRecreationSrvcPref(\dgsoft\StructType\DgRecreationSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRecreationSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The RecreationSrvcPref property can only contain items of \dgsoft\StructType\DgRecreationSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecreationSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get BusinessSrvcPref value
     * @return \dgsoft\StructType\DgBusinessSrvcPrefType[]|null
     */
    public function getBusinessSrvcPref()
    {
        return $this->BusinessSrvcPref;
    }
    /**
     * Set BusinessSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBusinessSrvcPrefType[] $businessSrvcPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setBusinessSrvcPref(array $businessSrvcPref = array())
    {
        foreach ($businessSrvcPref as $hotelPrefTypeBusinessSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeBusinessSrvcPrefItem instanceof \dgsoft\StructType\DgBusinessSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The BusinessSrvcPref property can only contain items of \dgsoft\StructType\DgBusinessSrvcPrefType, "%s" given', is_object($hotelPrefTypeBusinessSrvcPrefItem) ? get_class($hotelPrefTypeBusinessSrvcPrefItem) : gettype($hotelPrefTypeBusinessSrvcPrefItem)), __LINE__);
            }
        }
        $this->BusinessSrvcPref = $businessSrvcPref;
        return $this;
    }
    /**
     * Add item to BusinessSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBusinessSrvcPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToBusinessSrvcPref(\dgsoft\StructType\DgBusinessSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgBusinessSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The BusinessSrvcPref property can only contain items of \dgsoft\StructType\DgBusinessSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BusinessSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get PersonalSrvcPref value
     * @return \dgsoft\StructType\DgPersonalSrvcPrefType[]|null
     */
    public function getPersonalSrvcPref()
    {
        return $this->PersonalSrvcPref;
    }
    /**
     * Set PersonalSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPersonalSrvcPrefType[] $personalSrvcPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPersonalSrvcPref(array $personalSrvcPref = array())
    {
        foreach ($personalSrvcPref as $hotelPrefTypePersonalSrvcPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePersonalSrvcPrefItem instanceof \dgsoft\StructType\DgPersonalSrvcPrefType) {
                throw new \InvalidArgumentException(sprintf('The PersonalSrvcPref property can only contain items of \dgsoft\StructType\DgPersonalSrvcPrefType, "%s" given', is_object($hotelPrefTypePersonalSrvcPrefItem) ? get_class($hotelPrefTypePersonalSrvcPrefItem) : gettype($hotelPrefTypePersonalSrvcPrefItem)), __LINE__);
            }
        }
        $this->PersonalSrvcPref = $personalSrvcPref;
        return $this;
    }
    /**
     * Add item to PersonalSrvcPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPersonalSrvcPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPersonalSrvcPref(\dgsoft\StructType\DgPersonalSrvcPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPersonalSrvcPrefType) {
            throw new \InvalidArgumentException(sprintf('The PersonalSrvcPref property can only contain items of \dgsoft\StructType\DgPersonalSrvcPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PersonalSrvcPref[] = $item;
        return $this;
    }
    /**
     * Get SecurityFeaturePref value
     * @return \dgsoft\StructType\DgSecurityFeaturePrefType[]|null
     */
    public function getSecurityFeaturePref()
    {
        return $this->SecurityFeaturePref;
    }
    /**
     * Set SecurityFeaturePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSecurityFeaturePrefType[] $securityFeaturePref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setSecurityFeaturePref(array $securityFeaturePref = array())
    {
        foreach ($securityFeaturePref as $hotelPrefTypeSecurityFeaturePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeSecurityFeaturePrefItem instanceof \dgsoft\StructType\DgSecurityFeaturePrefType) {
                throw new \InvalidArgumentException(sprintf('The SecurityFeaturePref property can only contain items of \dgsoft\StructType\DgSecurityFeaturePrefType, "%s" given', is_object($hotelPrefTypeSecurityFeaturePrefItem) ? get_class($hotelPrefTypeSecurityFeaturePrefItem) : gettype($hotelPrefTypeSecurityFeaturePrefItem)), __LINE__);
            }
        }
        $this->SecurityFeaturePref = $securityFeaturePref;
        return $this;
    }
    /**
     * Add item to SecurityFeaturePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSecurityFeaturePrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToSecurityFeaturePref(\dgsoft\StructType\DgSecurityFeaturePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSecurityFeaturePrefType) {
            throw new \InvalidArgumentException(sprintf('The SecurityFeaturePref property can only contain items of \dgsoft\StructType\DgSecurityFeaturePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SecurityFeaturePref[] = $item;
        return $this;
    }
    /**
     * Get PhysChallFeaturePref value
     * @return \dgsoft\StructType\DgPhysChallFeaturePrefType[]|null
     */
    public function getPhysChallFeaturePref()
    {
        return $this->PhysChallFeaturePref;
    }
    /**
     * Set PhysChallFeaturePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPhysChallFeaturePrefType[] $physChallFeaturePref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPhysChallFeaturePref(array $physChallFeaturePref = array())
    {
        foreach ($physChallFeaturePref as $hotelPrefTypePhysChallFeaturePrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypePhysChallFeaturePrefItem instanceof \dgsoft\StructType\DgPhysChallFeaturePrefType) {
                throw new \InvalidArgumentException(sprintf('The PhysChallFeaturePref property can only contain items of \dgsoft\StructType\DgPhysChallFeaturePrefType, "%s" given', is_object($hotelPrefTypePhysChallFeaturePrefItem) ? get_class($hotelPrefTypePhysChallFeaturePrefItem) : gettype($hotelPrefTypePhysChallFeaturePrefItem)), __LINE__);
            }
        }
        $this->PhysChallFeaturePref = $physChallFeaturePref;
        return $this;
    }
    /**
     * Add item to PhysChallFeaturePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPhysChallFeaturePrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToPhysChallFeaturePref(\dgsoft\StructType\DgPhysChallFeaturePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPhysChallFeaturePrefType) {
            throw new \InvalidArgumentException(sprintf('The PhysChallFeaturePref property can only contain items of \dgsoft\StructType\DgPhysChallFeaturePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhysChallFeaturePref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \dgsoft\StructType\DgSpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $hotelPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$hotelPrefTypeSpecRequestPrefItem instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($hotelPrefTypeSpecRequestPrefItem) ? get_class($hotelPrefTypeSpecRequestPrefItem) : gettype($hotelPrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType $item
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function addToSpecRequestPref(\dgsoft\StructType\DgSpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get HotelGuestType value
     * @return string|null
     */
    public function getHotelGuestType()
    {
        return $this->HotelGuestType;
    }
    /**
     * Set HotelGuestType value
     * @param string $hotelGuestType
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public function setHotelGuestType($hotelGuestType = null)
    {
        // validation for constraint: string
        if (!is_null($hotelGuestType) && !is_string($hotelGuestType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelGuestType)), __LINE__);
        }
        $this->HotelGuestType = $hotelGuestType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgHotelPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
