<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuestCountType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgGuestCountType extends AbstractStructBase
{
    /**
     * The GuestCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgGuestCount[]
     */
    public $GuestCount;
    /**
     * The IsPerRoom
     * @var bool
     */
    public $IsPerRoom;
    /**
     * Constructor method for GuestCountType
     * @uses DgGuestCountType::setGuestCount()
     * @uses DgGuestCountType::setIsPerRoom()
     * @param \dgsoft\StructType\DgGuestCount[] $guestCount
     * @param bool $isPerRoom
     */
    public function __construct(array $guestCount = array(), $isPerRoom = null)
    {
        $this
            ->setGuestCount($guestCount)
            ->setIsPerRoom($isPerRoom);
    }
    /**
     * Get GuestCount value
     * @return \dgsoft\StructType\DgGuestCount[]|null
     */
    public function getGuestCount()
    {
        return $this->GuestCount;
    }
    /**
     * Set GuestCount value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgGuestCount[] $guestCount
     * @return \dgsoft\StructType\DgGuestCountType
     */
    public function setGuestCount(array $guestCount = array())
    {
        foreach ($guestCount as $guestCountTypeGuestCountItem) {
            // validation for constraint: itemType
            if (!$guestCountTypeGuestCountItem instanceof \dgsoft\StructType\DgGuestCount) {
                throw new \InvalidArgumentException(sprintf('The GuestCount property can only contain items of \dgsoft\StructType\DgGuestCount, "%s" given', is_object($guestCountTypeGuestCountItem) ? get_class($guestCountTypeGuestCountItem) : gettype($guestCountTypeGuestCountItem)), __LINE__);
            }
        }
        $this->GuestCount = $guestCount;
        return $this;
    }
    /**
     * Add item to GuestCount value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgGuestCount $item
     * @return \dgsoft\StructType\DgGuestCountType
     */
    public function addToGuestCount(\dgsoft\StructType\DgGuestCount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgGuestCount) {
            throw new \InvalidArgumentException(sprintf('The GuestCount property can only contain items of \dgsoft\StructType\DgGuestCount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->GuestCount[] = $item;
        return $this;
    }
    /**
     * Get IsPerRoom value
     * @return bool|null
     */
    public function getIsPerRoom()
    {
        return $this->IsPerRoom;
    }
    /**
     * Set IsPerRoom value
     * @param bool $isPerRoom
     * @return \dgsoft\StructType\DgGuestCountType
     */
    public function setIsPerRoom($isPerRoom = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPerRoom) && !is_bool($isPerRoom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPerRoom)), __LINE__);
        }
        $this->IsPerRoom = $isPerRoom;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGuestCountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
