<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroupInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgGroupInfoType extends AbstractStructBase
{
    /**
     * The PaxNumberofGroup
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $PaxNumberofGroup;
    /**
     * The GroupDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfGroupDetailType
     */
    public $GroupDetails;
    /**
     * The GroupName
     * @var string
     */
    public $GroupName;
    /**
     * Constructor method for GroupInfoType
     * @uses DgGroupInfoType::setPaxNumberofGroup()
     * @uses DgGroupInfoType::setGroupDetails()
     * @uses DgGroupInfoType::setGroupName()
     * @param int $paxNumberofGroup
     * @param \dgsoft\ArrayType\DgArrayOfGroupDetailType $groupDetails
     * @param string $groupName
     */
    public function __construct($paxNumberofGroup = null, \dgsoft\ArrayType\DgArrayOfGroupDetailType $groupDetails = null, $groupName = null)
    {
        $this
            ->setPaxNumberofGroup($paxNumberofGroup)
            ->setGroupDetails($groupDetails)
            ->setGroupName($groupName);
    }
    /**
     * Get PaxNumberofGroup value
     * @return int
     */
    public function getPaxNumberofGroup()
    {
        return $this->PaxNumberofGroup;
    }
    /**
     * Set PaxNumberofGroup value
     * @param int $paxNumberofGroup
     * @return \dgsoft\StructType\DgGroupInfoType
     */
    public function setPaxNumberofGroup($paxNumberofGroup = null)
    {
        // validation for constraint: int
        if (!is_null($paxNumberofGroup) && !is_numeric($paxNumberofGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paxNumberofGroup)), __LINE__);
        }
        $this->PaxNumberofGroup = $paxNumberofGroup;
        return $this;
    }
    /**
     * Get GroupDetails value
     * @return \dgsoft\ArrayType\DgArrayOfGroupDetailType|null
     */
    public function getGroupDetails()
    {
        return $this->GroupDetails;
    }
    /**
     * Set GroupDetails value
     * @param \dgsoft\ArrayType\DgArrayOfGroupDetailType $groupDetails
     * @return \dgsoft\StructType\DgGroupInfoType
     */
    public function setGroupDetails(\dgsoft\ArrayType\DgArrayOfGroupDetailType $groupDetails = null)
    {
        $this->GroupDetails = $groupDetails;
        return $this;
    }
    /**
     * Get GroupName value
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->GroupName;
    }
    /**
     * Set GroupName value
     * @param string $groupName
     * @return \dgsoft\StructType\DgGroupInfoType
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groupName)), __LINE__);
        }
        $this->GroupName = $groupName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGroupInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
