<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GolfReadRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgGolfReadRequest extends AbstractStructBase
{
    /**
     * The Membership
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMembership[]
     */
    public $Membership;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $Name;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The RoundID
     * @var int
     */
    public $RoundID;
    /**
     * The PlayDateTime
     * @var string
     */
    public $PlayDateTime;
    /**
     * The PackageID
     * @var string
     */
    public $PackageID;
    /**
     * Constructor method for GolfReadRequest
     * @uses DgGolfReadRequest::setMembership()
     * @uses DgGolfReadRequest::setName()
     * @uses DgGolfReadRequest::setID()
     * @uses DgGolfReadRequest::setRoundID()
     * @uses DgGolfReadRequest::setPlayDateTime()
     * @uses DgGolfReadRequest::setPackageID()
     * @param \dgsoft\StructType\DgMembership[] $membership
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @param string $iD
     * @param int $roundID
     * @param string $playDateTime
     * @param string $packageID
     */
    public function __construct(array $membership = array(), \dgsoft\StructType\DgPersonNameType $name = null, $iD = null, $roundID = null, $playDateTime = null, $packageID = null)
    {
        $this
            ->setMembership($membership)
            ->setName($name)
            ->setID($iD)
            ->setRoundID($roundID)
            ->setPlayDateTime($playDateTime)
            ->setPackageID($packageID);
    }
    /**
     * Get Membership value
     * @return \dgsoft\StructType\DgMembership[]|null
     */
    public function getMembership()
    {
        return $this->Membership;
    }
    /**
     * Set Membership value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMembership[] $membership
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function setMembership(array $membership = array())
    {
        foreach ($membership as $golfReadRequestMembershipItem) {
            // validation for constraint: itemType
            if (!$golfReadRequestMembershipItem instanceof \dgsoft\StructType\DgMembership) {
                throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \dgsoft\StructType\DgMembership, "%s" given', is_object($golfReadRequestMembershipItem) ? get_class($golfReadRequestMembershipItem) : gettype($golfReadRequestMembershipItem)), __LINE__);
            }
        }
        $this->Membership = $membership;
        return $this;
    }
    /**
     * Add item to Membership value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMembership $item
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function addToMembership(\dgsoft\StructType\DgMembership $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMembership) {
            throw new \InvalidArgumentException(sprintf('The Membership property can only contain items of \dgsoft\StructType\DgMembership, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Membership[] = $item;
        return $this;
    }
    /**
     * Get Name value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \dgsoft\StructType\DgPersonNameType $name
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function setName(\dgsoft\StructType\DgPersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get RoundID value
     * @return int|null
     */
    public function getRoundID()
    {
        return $this->RoundID;
    }
    /**
     * Set RoundID value
     * @param int $roundID
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function setRoundID($roundID = null)
    {
        // validation for constraint: int
        if (!is_null($roundID) && !is_numeric($roundID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($roundID)), __LINE__);
        }
        $this->RoundID = $roundID;
        return $this;
    }
    /**
     * Get PlayDateTime value
     * @return string|null
     */
    public function getPlayDateTime()
    {
        return $this->PlayDateTime;
    }
    /**
     * Set PlayDateTime value
     * @param string $playDateTime
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function setPlayDateTime($playDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($playDateTime) && !is_string($playDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($playDateTime)), __LINE__);
        }
        $this->PlayDateTime = $playDateTime;
        return $this;
    }
    /**
     * Get PackageID value
     * @return string|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param string $packageID
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: string
        if (!is_null($packageID) && !is_string($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgGolfReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
