<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FullFilment StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFullFilment extends AbstractStructBase
{
    /**
     * The PaymentDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPaymentDetailType
     */
    public $PaymentDetails;
    /**
     * The DeliveryAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType
     */
    public $DeliveryAddress;
    /**
     * Constructor method for FullFilment
     * @uses DgFullFilment::setPaymentDetails()
     * @uses DgFullFilment::setDeliveryAddress()
     * @param \dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails
     * @param \dgsoft\StructType\DgAddressType $deliveryAddress
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails = null, \dgsoft\StructType\DgAddressType $deliveryAddress = null)
    {
        $this
            ->setPaymentDetails($paymentDetails)
            ->setDeliveryAddress($deliveryAddress);
    }
    /**
     * Get PaymentDetails value
     * @return \dgsoft\ArrayType\DgArrayOfPaymentDetailType|null
     */
    public function getPaymentDetails()
    {
        return $this->PaymentDetails;
    }
    /**
     * Set PaymentDetails value
     * @param \dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails
     * @return \dgsoft\StructType\DgFullFilment
     */
    public function setPaymentDetails(\dgsoft\ArrayType\DgArrayOfPaymentDetailType $paymentDetails = null)
    {
        $this->PaymentDetails = $paymentDetails;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \dgsoft\StructType\DgAddressType|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \dgsoft\StructType\DgAddressType $deliveryAddress
     * @return \dgsoft\StructType\DgFullFilment
     */
    public function setDeliveryAddress(\dgsoft\StructType\DgAddressType $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFullFilment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
