<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FrequentFlyerCardsWithPassengerForSeatMap StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFrequentFlyerCardsWithPassengerForSeatMap extends AbstractStructBase
{
    /**
     * The SegmentNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SegmentNo;
    /**
     * The SeatPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $SeatPrice;
    /**
     * The ItineraryNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItineraryNo;
    /**
     * The SurName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurName;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassengerType;
    /**
     * The SeatRowNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SeatRowNumber;
    /**
     * The SeatColumn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SeatColumn;
    /**
     * The FlyerCards
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFlayerCardForSeatMap
     */
    public $FlyerCards;
    /**
     * Constructor method for FrequentFlyerCardsWithPassengerForSeatMap
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setSegmentNo()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setSeatPrice()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setItineraryNo()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setSurName()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setPassengerType()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setSeatRowNumber()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setSeatColumn()
     * @uses DgFrequentFlyerCardsWithPassengerForSeatMap::setFlyerCards()
     * @param int $segmentNo
     * @param float $seatPrice
     * @param int $itineraryNo
     * @param string $surName
     * @param string $passengerType
     * @param string $seatRowNumber
     * @param string $seatColumn
     * @param \dgsoft\ArrayType\DgArrayOfFlayerCardForSeatMap $flyerCards
     */
    public function __construct($segmentNo = null, $seatPrice = null, $itineraryNo = null, $surName = null, $passengerType = null, $seatRowNumber = null, $seatColumn = null, \dgsoft\ArrayType\DgArrayOfFlayerCardForSeatMap $flyerCards = null)
    {
        $this
            ->setSegmentNo($segmentNo)
            ->setSeatPrice($seatPrice)
            ->setItineraryNo($itineraryNo)
            ->setSurName($surName)
            ->setPassengerType($passengerType)
            ->setSeatRowNumber($seatRowNumber)
            ->setSeatColumn($seatColumn)
            ->setFlyerCards($flyerCards);
    }
    /**
     * Get SegmentNo value
     * @return int
     */
    public function getSegmentNo()
    {
        return $this->SegmentNo;
    }
    /**
     * Set SegmentNo value
     * @param int $segmentNo
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setSegmentNo($segmentNo = null)
    {
        // validation for constraint: int
        if (!is_null($segmentNo) && !is_numeric($segmentNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($segmentNo)), __LINE__);
        }
        $this->SegmentNo = $segmentNo;
        return $this;
    }
    /**
     * Get SeatPrice value
     * @return float
     */
    public function getSeatPrice()
    {
        return $this->SeatPrice;
    }
    /**
     * Set SeatPrice value
     * @param float $seatPrice
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setSeatPrice($seatPrice = null)
    {
        $this->SeatPrice = $seatPrice;
        return $this;
    }
    /**
     * Get ItineraryNo value
     * @return int
     */
    public function getItineraryNo()
    {
        return $this->ItineraryNo;
    }
    /**
     * Set ItineraryNo value
     * @param int $itineraryNo
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setItineraryNo($itineraryNo = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryNo) && !is_numeric($itineraryNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itineraryNo)), __LINE__);
        }
        $this->ItineraryNo = $itineraryNo;
        return $this;
    }
    /**
     * Get SurName value
     * @return string|null
     */
    public function getSurName()
    {
        return $this->SurName;
    }
    /**
     * Set SurName value
     * @param string $surName
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setSurName($surName = null)
    {
        // validation for constraint: string
        if (!is_null($surName) && !is_string($surName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surName)), __LINE__);
        }
        $this->SurName = $surName;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get SeatRowNumber value
     * @return string|null
     */
    public function getSeatRowNumber()
    {
        return $this->SeatRowNumber;
    }
    /**
     * Set SeatRowNumber value
     * @param string $seatRowNumber
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setSeatRowNumber($seatRowNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatRowNumber) && !is_string($seatRowNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatRowNumber)), __LINE__);
        }
        $this->SeatRowNumber = $seatRowNumber;
        return $this;
    }
    /**
     * Get SeatColumn value
     * @return string|null
     */
    public function getSeatColumn()
    {
        return $this->SeatColumn;
    }
    /**
     * Set SeatColumn value
     * @param string $seatColumn
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setSeatColumn($seatColumn = null)
    {
        // validation for constraint: string
        if (!is_null($seatColumn) && !is_string($seatColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seatColumn)), __LINE__);
        }
        $this->SeatColumn = $seatColumn;
        return $this;
    }
    /**
     * Get FlyerCards value
     * @return \dgsoft\ArrayType\DgArrayOfFlayerCardForSeatMap|null
     */
    public function getFlyerCards()
    {
        return $this->FlyerCards;
    }
    /**
     * Set FlyerCards value
     * @param \dgsoft\ArrayType\DgArrayOfFlayerCardForSeatMap $flyerCards
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public function setFlyerCards(\dgsoft\ArrayType\DgArrayOfFlayerCardForSeatMap $flyerCards = null)
    {
        $this->FlyerCards = $flyerCards;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFrequentFlyerCardsWithPassengerForSeatMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
