<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FoodSrvcPrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFoodSrvcPrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The FoodSrvcType
     * @var string
     */
    public $FoodSrvcType;
    /**
     * Constructor method for FoodSrvcPrefType
     * @uses DgFoodSrvcPrefType::set_()
     * @uses DgFoodSrvcPrefType::setPreferLevel()
     * @uses DgFoodSrvcPrefType::setFoodSrvcType()
     * @param string $_
     * @param string $preferLevel
     * @param string $foodSrvcType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $foodSrvcType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setFoodSrvcType($foodSrvcType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \dgsoft\StructType\DgFoodSrvcPrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgFoodSrvcPrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get FoodSrvcType value
     * @return string|null
     */
    public function getFoodSrvcType()
    {
        return $this->FoodSrvcType;
    }
    /**
     * Set FoodSrvcType value
     * @param string $foodSrvcType
     * @return \dgsoft\StructType\DgFoodSrvcPrefType
     */
    public function setFoodSrvcType($foodSrvcType = null)
    {
        // validation for constraint: string
        if (!is_null($foodSrvcType) && !is_string($foodSrvcType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($foodSrvcType)), __LINE__);
        }
        $this->FoodSrvcType = $foodSrvcType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFoodSrvcPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
