<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFlightInfo extends AbstractStructBase
{
    /**
     * The Airline
     * @var string
     */
    public $Airline;
    /**
     * The Routes
     * @var string
     */
    public $Routes;
    /**
     * Constructor method for FlightInfo
     * @uses DgFlightInfo::setAirline()
     * @uses DgFlightInfo::setRoutes()
     * @param string $airline
     * @param string $routes
     */
    public function __construct($airline = null, $routes = null)
    {
        $this
            ->setAirline($airline)
            ->setRoutes($routes);
    }
    /**
     * Get Airline value
     * @return string|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param string $airline
     * @return \dgsoft\StructType\DgFlightInfo
     */
    public function setAirline($airline = null)
    {
        // validation for constraint: string
        if (!is_null($airline) && !is_string($airline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airline)), __LINE__);
        }
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get Routes value
     * @return string|null
     */
    public function getRoutes()
    {
        return $this->Routes;
    }
    /**
     * Set Routes value
     * @param string $routes
     * @return \dgsoft\StructType\DgFlightInfo
     */
    public function setRoutes($routes = null)
    {
        // validation for constraint: string
        if (!is_null($routes) && !is_string($routes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routes)), __LINE__);
        }
        $this->Routes = $routes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFlightInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
