<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlayerCardForSeatMap StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFlayerCardForSeatMap extends AbstractStructBase
{
    /**
     * The AirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirlineCode;
    /**
     * The MarketingAirlineCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketingAirlineCode;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * Constructor method for FlayerCardForSeatMap
     * @uses DgFlayerCardForSeatMap::setAirlineCode()
     * @uses DgFlayerCardForSeatMap::setMarketingAirlineCode()
     * @uses DgFlayerCardForSeatMap::setNumber()
     * @param string $airlineCode
     * @param string $marketingAirlineCode
     * @param string $number
     */
    public function __construct($airlineCode = null, $marketingAirlineCode = null, $number = null)
    {
        $this
            ->setAirlineCode($airlineCode)
            ->setMarketingAirlineCode($marketingAirlineCode)
            ->setNumber($number);
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \dgsoft\StructType\DgFlayerCardForSeatMap
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get MarketingAirlineCode value
     * @return string|null
     */
    public function getMarketingAirlineCode()
    {
        return $this->MarketingAirlineCode;
    }
    /**
     * Set MarketingAirlineCode value
     * @param string $marketingAirlineCode
     * @return \dgsoft\StructType\DgFlayerCardForSeatMap
     */
    public function setMarketingAirlineCode($marketingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingAirlineCode) && !is_string($marketingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketingAirlineCode)), __LINE__);
        }
        $this->MarketingAirlineCode = $marketingAirlineCode;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \dgsoft\StructType\DgFlayerCardForSeatMap
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFlayerCardForSeatMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
