<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareType extends AbstractStructBase
{
    /**
     * The BaseFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBaseFare
     */
    public $BaseFare;
    /**
     * The MarkupFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMarkupFare
     */
    public $MarkupFare;
    /**
     * The EquivFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEquivFare
     */
    public $EquivFare;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAirTaxType
     */
    public $Taxes;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfAirFeeType
     */
    public $Fees;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalFare
     */
    public $TotalFare;
    /**
     * The TotalAmountInTicketingCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTotalAmountInTicketingCurrency
     */
    public $TotalAmountInTicketingCurrency;
    /**
     * The FareConstruction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareConstruction
     */
    public $FareConstruction;
    /**
     * The UnstructuredFareCalc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUnstructuredFareCalc
     */
    public $UnstructuredFareCalc;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The NegotiatedFare
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The NegotiatedFareCode
     * @var string
     */
    public $NegotiatedFareCode;
    /**
     * The TicketDesignatorCode
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The TotalNbrTrips
     * @var int
     */
    public $TotalNbrTrips;
    /**
     * The TotalNbrPTC
     * @var int
     */
    public $TotalNbrPTC;
    /**
     * Constructor method for FareType
     * @uses DgFareType::setBaseFare()
     * @uses DgFareType::setMarkupFare()
     * @uses DgFareType::setEquivFare()
     * @uses DgFareType::setTaxes()
     * @uses DgFareType::setFees()
     * @uses DgFareType::setTotalFare()
     * @uses DgFareType::setTotalAmountInTicketingCurrency()
     * @uses DgFareType::setFareConstruction()
     * @uses DgFareType::setUnstructuredFareCalc()
     * @uses DgFareType::setTPA_Extensions()
     * @uses DgFareType::setNegotiatedFare()
     * @uses DgFareType::setNegotiatedFareCode()
     * @uses DgFareType::setTicketDesignatorCode()
     * @uses DgFareType::setTotalNbrTrips()
     * @uses DgFareType::setTotalNbrPTC()
     * @param \dgsoft\StructType\DgBaseFare $baseFare
     * @param \dgsoft\StructType\DgMarkupFare $markupFare
     * @param \dgsoft\StructType\DgEquivFare $equivFare
     * @param \dgsoft\ArrayType\DgArrayOfAirTaxType $taxes
     * @param \dgsoft\ArrayType\DgArrayOfAirFeeType $fees
     * @param \dgsoft\StructType\DgTotalFare $totalFare
     * @param \dgsoft\StructType\DgTotalAmountInTicketingCurrency $totalAmountInTicketingCurrency
     * @param \dgsoft\StructType\DgFareConstruction $fareConstruction
     * @param \dgsoft\StructType\DgUnstructuredFareCalc $unstructuredFareCalc
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param bool $negotiatedFare
     * @param string $negotiatedFareCode
     * @param string $ticketDesignatorCode
     * @param int $totalNbrTrips
     * @param int $totalNbrPTC
     */
    public function __construct(\dgsoft\StructType\DgBaseFare $baseFare = null, \dgsoft\StructType\DgMarkupFare $markupFare = null, \dgsoft\StructType\DgEquivFare $equivFare = null, \dgsoft\ArrayType\DgArrayOfAirTaxType $taxes = null, \dgsoft\ArrayType\DgArrayOfAirFeeType $fees = null, \dgsoft\StructType\DgTotalFare $totalFare = null, \dgsoft\StructType\DgTotalAmountInTicketingCurrency $totalAmountInTicketingCurrency = null, \dgsoft\StructType\DgFareConstruction $fareConstruction = null, \dgsoft\StructType\DgUnstructuredFareCalc $unstructuredFareCalc = null, \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $negotiatedFare = false, $negotiatedFareCode = null, $ticketDesignatorCode = null, $totalNbrTrips = null, $totalNbrPTC = null)
    {
        $this
            ->setBaseFare($baseFare)
            ->setMarkupFare($markupFare)
            ->setEquivFare($equivFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setTotalFare($totalFare)
            ->setTotalAmountInTicketingCurrency($totalAmountInTicketingCurrency)
            ->setFareConstruction($fareConstruction)
            ->setUnstructuredFareCalc($unstructuredFareCalc)
            ->setTPA_Extensions($tPA_Extensions)
            ->setNegotiatedFare($negotiatedFare)
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setTotalNbrTrips($totalNbrTrips)
            ->setTotalNbrPTC($totalNbrPTC);
    }
    /**
     * Get BaseFare value
     * @return \dgsoft\StructType\DgBaseFare|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param \dgsoft\StructType\DgBaseFare $baseFare
     * @return \dgsoft\StructType\DgFareType
     */
    public function setBaseFare(\dgsoft\StructType\DgBaseFare $baseFare = null)
    {
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get MarkupFare value
     * @return \dgsoft\StructType\DgMarkupFare|null
     */
    public function getMarkupFare()
    {
        return $this->MarkupFare;
    }
    /**
     * Set MarkupFare value
     * @param \dgsoft\StructType\DgMarkupFare $markupFare
     * @return \dgsoft\StructType\DgFareType
     */
    public function setMarkupFare(\dgsoft\StructType\DgMarkupFare $markupFare = null)
    {
        $this->MarkupFare = $markupFare;
        return $this;
    }
    /**
     * Get EquivFare value
     * @return \dgsoft\StructType\DgEquivFare|null
     */
    public function getEquivFare()
    {
        return $this->EquivFare;
    }
    /**
     * Set EquivFare value
     * @param \dgsoft\StructType\DgEquivFare $equivFare
     * @return \dgsoft\StructType\DgFareType
     */
    public function setEquivFare(\dgsoft\StructType\DgEquivFare $equivFare = null)
    {
        $this->EquivFare = $equivFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \dgsoft\ArrayType\DgArrayOfAirTaxType|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \dgsoft\ArrayType\DgArrayOfAirTaxType $taxes
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTaxes(\dgsoft\ArrayType\DgArrayOfAirTaxType $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return \dgsoft\ArrayType\DgArrayOfAirFeeType|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \dgsoft\ArrayType\DgArrayOfAirFeeType $fees
     * @return \dgsoft\StructType\DgFareType
     */
    public function setFees(\dgsoft\ArrayType\DgArrayOfAirFeeType $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return \dgsoft\StructType\DgTotalFare|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param \dgsoft\StructType\DgTotalFare $totalFare
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTotalFare(\dgsoft\StructType\DgTotalFare $totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get TotalAmountInTicketingCurrency value
     * @return \dgsoft\StructType\DgTotalAmountInTicketingCurrency|null
     */
    public function getTotalAmountInTicketingCurrency()
    {
        return $this->TotalAmountInTicketingCurrency;
    }
    /**
     * Set TotalAmountInTicketingCurrency value
     * @param \dgsoft\StructType\DgTotalAmountInTicketingCurrency $totalAmountInTicketingCurrency
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTotalAmountInTicketingCurrency(\dgsoft\StructType\DgTotalAmountInTicketingCurrency $totalAmountInTicketingCurrency = null)
    {
        $this->TotalAmountInTicketingCurrency = $totalAmountInTicketingCurrency;
        return $this;
    }
    /**
     * Get FareConstruction value
     * @return \dgsoft\StructType\DgFareConstruction|null
     */
    public function getFareConstruction()
    {
        return $this->FareConstruction;
    }
    /**
     * Set FareConstruction value
     * @param \dgsoft\StructType\DgFareConstruction $fareConstruction
     * @return \dgsoft\StructType\DgFareType
     */
    public function setFareConstruction(\dgsoft\StructType\DgFareConstruction $fareConstruction = null)
    {
        $this->FareConstruction = $fareConstruction;
        return $this;
    }
    /**
     * Get UnstructuredFareCalc value
     * @return \dgsoft\StructType\DgUnstructuredFareCalc|null
     */
    public function getUnstructuredFareCalc()
    {
        return $this->UnstructuredFareCalc;
    }
    /**
     * Set UnstructuredFareCalc value
     * @param \dgsoft\StructType\DgUnstructuredFareCalc $unstructuredFareCalc
     * @return \dgsoft\StructType\DgFareType
     */
    public function setUnstructuredFareCalc(\dgsoft\StructType\DgUnstructuredFareCalc $unstructuredFareCalc = null)
    {
        $this->UnstructuredFareCalc = $unstructuredFareCalc;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \dgsoft\StructType\DgFareType
     */
    public function setNegotiatedFare($negotiatedFare = false)
    {
        // validation for constraint: boolean
        if (!is_null($negotiatedFare) && !is_bool($negotiatedFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($negotiatedFare)), __LINE__);
        }
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get NegotiatedFareCode value
     * @return string|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param string $negotiatedFareCode
     * @return \dgsoft\StructType\DgFareType
     */
    public function setNegotiatedFareCode($negotiatedFareCode = null)
    {
        // validation for constraint: string
        if (!is_null($negotiatedFareCode) && !is_string($negotiatedFareCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($negotiatedFareCode)), __LINE__);
        }
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get TotalNbrTrips value
     * @return int|null
     */
    public function getTotalNbrTrips()
    {
        return $this->TotalNbrTrips;
    }
    /**
     * Set TotalNbrTrips value
     * @param int $totalNbrTrips
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTotalNbrTrips($totalNbrTrips = null)
    {
        // validation for constraint: int
        if (!is_null($totalNbrTrips) && !is_numeric($totalNbrTrips)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNbrTrips)), __LINE__);
        }
        $this->TotalNbrTrips = $totalNbrTrips;
        return $this;
    }
    /**
     * Get TotalNbrPTC value
     * @return int|null
     */
    public function getTotalNbrPTC()
    {
        return $this->TotalNbrPTC;
    }
    /**
     * Set TotalNbrPTC value
     * @param int $totalNbrPTC
     * @return \dgsoft\StructType\DgFareType
     */
    public function setTotalNbrPTC($totalNbrPTC = null)
    {
        // validation for constraint: int
        if (!is_null($totalNbrPTC) && !is_numeric($totalNbrPTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalNbrPTC)), __LINE__);
        }
        $this->TotalNbrPTC = $totalNbrPTC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
