<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRuleResponseInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareRuleResponseInfoType extends AbstractStructBase
{
    /**
     * The FareRuleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo[]
     */
    public $FareRuleInfo;
    /**
     * The FareRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFormattedTextType[]
     */
    public $FareRules;
    /**
     * The Routing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting[]
     */
    public $Routing;
    /**
     * The AdvisoryInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo[]
     */
    public $AdvisoryInfo;
    /**
     * The ItineraryIndex
     * @var int
     */
    public $ItineraryIndex;
    /**
     * Constructor method for FareRuleResponseInfoType
     * @uses DgFareRuleResponseInfoType::setFareRuleInfo()
     * @uses DgFareRuleResponseInfoType::setFareRules()
     * @uses DgFareRuleResponseInfoType::setRouting()
     * @uses DgFareRuleResponseInfoType::setAdvisoryInfo()
     * @uses DgFareRuleResponseInfoType::setItineraryIndex()
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo[] $fareRuleInfo
     * @param \dgsoft\StructType\DgFormattedTextType[] $fareRules
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting[] $routing
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo[] $advisoryInfo
     * @param int $itineraryIndex
     */
    public function __construct(array $fareRuleInfo = array(), array $fareRules = array(), array $routing = array(), array $advisoryInfo = array(), $itineraryIndex = null)
    {
        $this
            ->setFareRuleInfo($fareRuleInfo)
            ->setFareRules($fareRules)
            ->setRouting($routing)
            ->setAdvisoryInfo($advisoryInfo)
            ->setItineraryIndex($itineraryIndex);
    }
    /**
     * Get FareRuleInfo value
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo[]|null
     */
    public function getFareRuleInfo()
    {
        return $this->FareRuleInfo;
    }
    /**
     * Set FareRuleInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo[] $fareRuleInfo
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function setFareRuleInfo(array $fareRuleInfo = array())
    {
        foreach ($fareRuleInfo as $fareRuleResponseInfoTypeFareRuleInfoItem) {
            // validation for constraint: itemType
            if (!$fareRuleResponseInfoTypeFareRuleInfoItem instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo) {
                throw new \InvalidArgumentException(sprintf('The FareRuleInfo property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo, "%s" given', is_object($fareRuleResponseInfoTypeFareRuleInfoItem) ? get_class($fareRuleResponseInfoTypeFareRuleInfoItem) : gettype($fareRuleResponseInfoTypeFareRuleInfoItem)), __LINE__);
            }
        }
        $this->FareRuleInfo = $fareRuleInfo;
        return $this;
    }
    /**
     * Add item to FareRuleInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo $item
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function addToFareRuleInfo(\dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo) {
            throw new \InvalidArgumentException(sprintf('The FareRuleInfo property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeFareRuleInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareRuleInfo[] = $item;
        return $this;
    }
    /**
     * Get FareRules value
     * @return \dgsoft\StructType\DgFormattedTextType[]|null
     */
    public function getFareRules()
    {
        return $this->FareRules;
    }
    /**
     * Set FareRules value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFormattedTextType[] $fareRules
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function setFareRules(array $fareRules = array())
    {
        foreach ($fareRules as $fareRuleResponseInfoTypeFareRulesItem) {
            // validation for constraint: itemType
            if (!$fareRuleResponseInfoTypeFareRulesItem instanceof \dgsoft\StructType\DgFormattedTextType) {
                throw new \InvalidArgumentException(sprintf('The FareRules property can only contain items of \dgsoft\StructType\DgFormattedTextType, "%s" given', is_object($fareRuleResponseInfoTypeFareRulesItem) ? get_class($fareRuleResponseInfoTypeFareRulesItem) : gettype($fareRuleResponseInfoTypeFareRulesItem)), __LINE__);
            }
        }
        $this->FareRules = $fareRules;
        return $this;
    }
    /**
     * Add item to FareRules value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFormattedTextType $item
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function addToFareRules(\dgsoft\StructType\DgFormattedTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFormattedTextType) {
            throw new \InvalidArgumentException(sprintf('The FareRules property can only contain items of \dgsoft\StructType\DgFormattedTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareRules[] = $item;
        return $this;
    }
    /**
     * Get Routing value
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting[]|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting[] $routing
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function setRouting(array $routing = array())
    {
        foreach ($routing as $fareRuleResponseInfoTypeRoutingItem) {
            // validation for constraint: itemType
            if (!$fareRuleResponseInfoTypeRoutingItem instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting) {
                throw new \InvalidArgumentException(sprintf('The Routing property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting, "%s" given', is_object($fareRuleResponseInfoTypeRoutingItem) ? get_class($fareRuleResponseInfoTypeRoutingItem) : gettype($fareRuleResponseInfoTypeRoutingItem)), __LINE__);
            }
        }
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Add item to Routing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting $item
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function addToRouting(\dgsoft\StructType\DgFareRuleResponseInfoTypeRouting $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting) {
            throw new \InvalidArgumentException(sprintf('The Routing property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeRouting, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Routing[] = $item;
        return $this;
    }
    /**
     * Get AdvisoryInfo value
     * @return \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo[]|null
     */
    public function getAdvisoryInfo()
    {
        return $this->AdvisoryInfo;
    }
    /**
     * Set AdvisoryInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo[] $advisoryInfo
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function setAdvisoryInfo(array $advisoryInfo = array())
    {
        foreach ($advisoryInfo as $fareRuleResponseInfoTypeAdvisoryInfoItem) {
            // validation for constraint: itemType
            if (!$fareRuleResponseInfoTypeAdvisoryInfoItem instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo) {
                throw new \InvalidArgumentException(sprintf('The AdvisoryInfo property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo, "%s" given', is_object($fareRuleResponseInfoTypeAdvisoryInfoItem) ? get_class($fareRuleResponseInfoTypeAdvisoryInfoItem) : gettype($fareRuleResponseInfoTypeAdvisoryInfoItem)), __LINE__);
            }
        }
        $this->AdvisoryInfo = $advisoryInfo;
        return $this;
    }
    /**
     * Add item to AdvisoryInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo $item
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function addToAdvisoryInfo(\dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo) {
            throw new \InvalidArgumentException(sprintf('The AdvisoryInfo property can only contain items of \dgsoft\StructType\DgFareRuleResponseInfoTypeAdvisoryInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdvisoryInfo[] = $item;
        return $this;
    }
    /**
     * Get ItineraryIndex value
     * @return int|null
     */
    public function getItineraryIndex()
    {
        return $this->ItineraryIndex;
    }
    /**
     * Set ItineraryIndex value
     * @param int $itineraryIndex
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public function setItineraryIndex($itineraryIndex = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryIndex) && !is_numeric($itineraryIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itineraryIndex)), __LINE__);
        }
        $this->ItineraryIndex = $itineraryIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareRuleResponseInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
