<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareRestrictPref StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareRestrictPref extends AbstractStructBase
{
    /**
     * The FareRestriction
     * @var string
     */
    public $FareRestriction;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The AdvResTicketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAdvResTicketingType
     */
    public $AdvResTicketing;
    /**
     * The StayRestrictions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgStayRestrictionsType
     */
    public $StayRestrictions;
    /**
     * The VoluntaryChanges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgVoluntaryChangesType
     */
    public $VoluntaryChanges;
    /**
     * The FareDisplayCurrency
     * @var string
     */
    public $FareDisplayCurrency;
    /**
     * The CurrencyOverride
     * @var string
     */
    public $CurrencyOverride;
    /**
     * Constructor method for FareRestrictPref
     * @uses DgFareRestrictPref::setFareRestriction()
     * @uses DgFareRestrictPref::setDate()
     * @uses DgFareRestrictPref::setAdvResTicketing()
     * @uses DgFareRestrictPref::setStayRestrictions()
     * @uses DgFareRestrictPref::setVoluntaryChanges()
     * @uses DgFareRestrictPref::setFareDisplayCurrency()
     * @uses DgFareRestrictPref::setCurrencyOverride()
     * @param string $fareRestriction
     * @param string $date
     * @param \dgsoft\StructType\DgAdvResTicketingType $advResTicketing
     * @param \dgsoft\StructType\DgStayRestrictionsType $stayRestrictions
     * @param \dgsoft\StructType\DgVoluntaryChangesType $voluntaryChanges
     * @param string $fareDisplayCurrency
     * @param string $currencyOverride
     */
    public function __construct($fareRestriction = null, $date = null, \dgsoft\StructType\DgAdvResTicketingType $advResTicketing = null, \dgsoft\StructType\DgStayRestrictionsType $stayRestrictions = null, \dgsoft\StructType\DgVoluntaryChangesType $voluntaryChanges = null, $fareDisplayCurrency = null, $currencyOverride = null)
    {
        $this
            ->setFareRestriction($fareRestriction)
            ->setDate($date)
            ->setAdvResTicketing($advResTicketing)
            ->setStayRestrictions($stayRestrictions)
            ->setVoluntaryChanges($voluntaryChanges)
            ->setFareDisplayCurrency($fareDisplayCurrency)
            ->setCurrencyOverride($currencyOverride);
    }
    /**
     * Get FareRestriction value
     * @return string|null
     */
    public function getFareRestriction()
    {
        return $this->FareRestriction;
    }
    /**
     * Set FareRestriction value
     * @param string $fareRestriction
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setFareRestriction($fareRestriction = null)
    {
        // validation for constraint: string
        if (!is_null($fareRestriction) && !is_string($fareRestriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareRestriction)), __LINE__);
        }
        $this->FareRestriction = $fareRestriction;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get AdvResTicketing value
     * @return \dgsoft\StructType\DgAdvResTicketingType|null
     */
    public function getAdvResTicketing()
    {
        return $this->AdvResTicketing;
    }
    /**
     * Set AdvResTicketing value
     * @param \dgsoft\StructType\DgAdvResTicketingType $advResTicketing
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setAdvResTicketing(\dgsoft\StructType\DgAdvResTicketingType $advResTicketing = null)
    {
        $this->AdvResTicketing = $advResTicketing;
        return $this;
    }
    /**
     * Get StayRestrictions value
     * @return \dgsoft\StructType\DgStayRestrictionsType|null
     */
    public function getStayRestrictions()
    {
        return $this->StayRestrictions;
    }
    /**
     * Set StayRestrictions value
     * @param \dgsoft\StructType\DgStayRestrictionsType $stayRestrictions
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setStayRestrictions(\dgsoft\StructType\DgStayRestrictionsType $stayRestrictions = null)
    {
        $this->StayRestrictions = $stayRestrictions;
        return $this;
    }
    /**
     * Get VoluntaryChanges value
     * @return \dgsoft\StructType\DgVoluntaryChangesType|null
     */
    public function getVoluntaryChanges()
    {
        return $this->VoluntaryChanges;
    }
    /**
     * Set VoluntaryChanges value
     * @param \dgsoft\StructType\DgVoluntaryChangesType $voluntaryChanges
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setVoluntaryChanges(\dgsoft\StructType\DgVoluntaryChangesType $voluntaryChanges = null)
    {
        $this->VoluntaryChanges = $voluntaryChanges;
        return $this;
    }
    /**
     * Get FareDisplayCurrency value
     * @return string|null
     */
    public function getFareDisplayCurrency()
    {
        return $this->FareDisplayCurrency;
    }
    /**
     * Set FareDisplayCurrency value
     * @param string $fareDisplayCurrency
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setFareDisplayCurrency($fareDisplayCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($fareDisplayCurrency) && !is_string($fareDisplayCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareDisplayCurrency)), __LINE__);
        }
        $this->FareDisplayCurrency = $fareDisplayCurrency;
        return $this;
    }
    /**
     * Get CurrencyOverride value
     * @return string|null
     */
    public function getCurrencyOverride()
    {
        return $this->CurrencyOverride;
    }
    /**
     * Set CurrencyOverride value
     * @param string $currencyOverride
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public function setCurrencyOverride($currencyOverride = null)
    {
        // validation for constraint: string
        if (!is_null($currencyOverride) && !is_string($currencyOverride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyOverride)), __LINE__);
        }
        $this->CurrencyOverride = $currencyOverride;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareRestrictPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
