<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareInfoType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareInfoType extends AbstractStructBase
{
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The FareReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareReference[]
     */
    public $FareReference;
    /**
     * The RuleInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRuleInfo
     */
    public $RuleInfo;
    /**
     * The FilingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $FilingAirline;
    /**
     * The MarketingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $MarketingAirline;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $DepartureAirport;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLocationType
     */
    public $ArrivalAirport;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDate[]
     */
    public $Date;
    /**
     * The FareInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareInfo[]
     */
    public $FareInfo;
    /**
     * The DiscountPricing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDiscountPricing
     */
    public $DiscountPricing;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCity[]
     */
    public $City;
    /**
     * The Airport
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirport[]
     */
    public $Airport;
    /**
     * The NegotiatedFare
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $NegotiatedFare;
    /**
     * The NegotiatedFareCode
     * @var string
     */
    public $NegotiatedFareCode;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The TariffNumber
     * @var string
     */
    public $TariffNumber;
    /**
     * The RuleNumber
     * @var string
     */
    public $RuleNumber;
    /**
     * The RoutingNumber
     * @var int
     */
    public $RoutingNumber;
    /**
     * Constructor method for FareInfoType
     * @uses DgFareInfoType::setDepartureDate()
     * @uses DgFareInfoType::setFareReference()
     * @uses DgFareInfoType::setRuleInfo()
     * @uses DgFareInfoType::setFilingAirline()
     * @uses DgFareInfoType::setMarketingAirline()
     * @uses DgFareInfoType::setDepartureAirport()
     * @uses DgFareInfoType::setArrivalAirport()
     * @uses DgFareInfoType::setDate()
     * @uses DgFareInfoType::setFareInfo()
     * @uses DgFareInfoType::setDiscountPricing()
     * @uses DgFareInfoType::setCity()
     * @uses DgFareInfoType::setAirport()
     * @uses DgFareInfoType::setNegotiatedFare()
     * @uses DgFareInfoType::setNegotiatedFareCode()
     * @uses DgFareInfoType::setCurrencyCode()
     * @uses DgFareInfoType::setTariffNumber()
     * @uses DgFareInfoType::setRuleNumber()
     * @uses DgFareInfoType::setRoutingNumber()
     * @param string $departureDate
     * @param \dgsoft\StructType\DgFareReference[] $fareReference
     * @param \dgsoft\StructType\DgRuleInfo $ruleInfo
     * @param \dgsoft\StructType\DgCompanyNameType $filingAirline
     * @param \dgsoft\StructType\DgCompanyNameType[] $marketingAirline
     * @param \dgsoft\StructType\DgLocationType $departureAirport
     * @param \dgsoft\StructType\DgLocationType $arrivalAirport
     * @param \dgsoft\StructType\DgDate[] $date
     * @param \dgsoft\StructType\DgFareInfo[] $fareInfo
     * @param \dgsoft\StructType\DgDiscountPricing $discountPricing
     * @param \dgsoft\StructType\DgCity[] $city
     * @param \dgsoft\StructType\DgAirport[] $airport
     * @param bool $negotiatedFare
     * @param string $negotiatedFareCode
     * @param string $currencyCode
     * @param string $tariffNumber
     * @param string $ruleNumber
     * @param int $routingNumber
     */
    public function __construct($departureDate = null, array $fareReference = array(), \dgsoft\StructType\DgRuleInfo $ruleInfo = null, \dgsoft\StructType\DgCompanyNameType $filingAirline = null, array $marketingAirline = array(), \dgsoft\StructType\DgLocationType $departureAirport = null, \dgsoft\StructType\DgLocationType $arrivalAirport = null, array $date = array(), array $fareInfo = array(), \dgsoft\StructType\DgDiscountPricing $discountPricing = null, array $city = array(), array $airport = array(), $negotiatedFare = false, $negotiatedFareCode = null, $currencyCode = null, $tariffNumber = null, $ruleNumber = null, $routingNumber = null)
    {
        $this
            ->setDepartureDate($departureDate)
            ->setFareReference($fareReference)
            ->setRuleInfo($ruleInfo)
            ->setFilingAirline($filingAirline)
            ->setMarketingAirline($marketingAirline)
            ->setDepartureAirport($departureAirport)
            ->setArrivalAirport($arrivalAirport)
            ->setDate($date)
            ->setFareInfo($fareInfo)
            ->setDiscountPricing($discountPricing)
            ->setCity($city)
            ->setAirport($airport)
            ->setNegotiatedFare($negotiatedFare)
            ->setNegotiatedFareCode($negotiatedFareCode)
            ->setCurrencyCode($currencyCode)
            ->setTariffNumber($tariffNumber)
            ->setRuleNumber($ruleNumber)
            ->setRoutingNumber($routingNumber);
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get FareReference value
     * @return \dgsoft\StructType\DgFareReference[]|null
     */
    public function getFareReference()
    {
        return $this->FareReference;
    }
    /**
     * Set FareReference value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareReference[] $fareReference
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setFareReference(array $fareReference = array())
    {
        foreach ($fareReference as $fareInfoTypeFareReferenceItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeFareReferenceItem instanceof \dgsoft\StructType\DgFareReference) {
                throw new \InvalidArgumentException(sprintf('The FareReference property can only contain items of \dgsoft\StructType\DgFareReference, "%s" given', is_object($fareInfoTypeFareReferenceItem) ? get_class($fareInfoTypeFareReferenceItem) : gettype($fareInfoTypeFareReferenceItem)), __LINE__);
            }
        }
        $this->FareReference = $fareReference;
        return $this;
    }
    /**
     * Add item to FareReference value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareReference $item
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function addToFareReference(\dgsoft\StructType\DgFareReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareReference) {
            throw new \InvalidArgumentException(sprintf('The FareReference property can only contain items of \dgsoft\StructType\DgFareReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareReference[] = $item;
        return $this;
    }
    /**
     * Get RuleInfo value
     * @return \dgsoft\StructType\DgRuleInfo|null
     */
    public function getRuleInfo()
    {
        return $this->RuleInfo;
    }
    /**
     * Set RuleInfo value
     * @param \dgsoft\StructType\DgRuleInfo $ruleInfo
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setRuleInfo(\dgsoft\StructType\DgRuleInfo $ruleInfo = null)
    {
        $this->RuleInfo = $ruleInfo;
        return $this;
    }
    /**
     * Get FilingAirline value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getFilingAirline()
    {
        return $this->FilingAirline;
    }
    /**
     * Set FilingAirline value
     * @param \dgsoft\StructType\DgCompanyNameType $filingAirline
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setFilingAirline(\dgsoft\StructType\DgCompanyNameType $filingAirline = null)
    {
        $this->FilingAirline = $filingAirline;
        return $this;
    }
    /**
     * Get MarketingAirline value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getMarketingAirline()
    {
        return $this->MarketingAirline;
    }
    /**
     * Set MarketingAirline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $marketingAirline
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setMarketingAirline(array $marketingAirline = array())
    {
        foreach ($marketingAirline as $fareInfoTypeMarketingAirlineItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeMarketingAirlineItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The MarketingAirline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($fareInfoTypeMarketingAirlineItem) ? get_class($fareInfoTypeMarketingAirlineItem) : gettype($fareInfoTypeMarketingAirlineItem)), __LINE__);
            }
        }
        $this->MarketingAirline = $marketingAirline;
        return $this;
    }
    /**
     * Add item to MarketingAirline value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function addToMarketingAirline(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The MarketingAirline property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MarketingAirline[] = $item;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \dgsoft\StructType\DgLocationType $departureAirport
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setDepartureAirport(\dgsoft\StructType\DgLocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param \dgsoft\StructType\DgLocationType $arrivalAirport
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setArrivalAirport(\dgsoft\StructType\DgLocationType $arrivalAirport = null)
    {
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get Date value
     * @return \dgsoft\StructType\DgDate[]|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDate[] $date
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setDate(array $date = array())
    {
        foreach ($date as $fareInfoTypeDateItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeDateItem instanceof \dgsoft\StructType\DgDate) {
                throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \dgsoft\StructType\DgDate, "%s" given', is_object($fareInfoTypeDateItem) ? get_class($fareInfoTypeDateItem) : gettype($fareInfoTypeDateItem)), __LINE__);
            }
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Add item to Date value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgDate $item
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function addToDate(\dgsoft\StructType\DgDate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgDate) {
            throw new \InvalidArgumentException(sprintf('The Date property can only contain items of \dgsoft\StructType\DgDate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Date[] = $item;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \dgsoft\StructType\DgFareInfo[]|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareInfo[] $fareInfo
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setFareInfo(array $fareInfo = array())
    {
        foreach ($fareInfo as $fareInfoTypeFareInfoItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeFareInfoItem instanceof \dgsoft\StructType\DgFareInfo) {
                throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \dgsoft\StructType\DgFareInfo, "%s" given', is_object($fareInfoTypeFareInfoItem) ? get_class($fareInfoTypeFareInfoItem) : gettype($fareInfoTypeFareInfoItem)), __LINE__);
            }
        }
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Add item to FareInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFareInfo $item
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function addToFareInfo(\dgsoft\StructType\DgFareInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFareInfo) {
            throw new \InvalidArgumentException(sprintf('The FareInfo property can only contain items of \dgsoft\StructType\DgFareInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FareInfo[] = $item;
        return $this;
    }
    /**
     * Get DiscountPricing value
     * @return \dgsoft\StructType\DgDiscountPricing|null
     */
    public function getDiscountPricing()
    {
        return $this->DiscountPricing;
    }
    /**
     * Set DiscountPricing value
     * @param \dgsoft\StructType\DgDiscountPricing $discountPricing
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setDiscountPricing(\dgsoft\StructType\DgDiscountPricing $discountPricing = null)
    {
        $this->DiscountPricing = $discountPricing;
        return $this;
    }
    /**
     * Get City value
     * @return \dgsoft\StructType\DgCity[]|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCity[] $city
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setCity(array $city = array())
    {
        foreach ($city as $fareInfoTypeCityItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeCityItem instanceof \dgsoft\StructType\DgCity) {
                throw new \InvalidArgumentException(sprintf('The City property can only contain items of \dgsoft\StructType\DgCity, "%s" given', is_object($fareInfoTypeCityItem) ? get_class($fareInfoTypeCityItem) : gettype($fareInfoTypeCityItem)), __LINE__);
            }
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Add item to City value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCity $item
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function addToCity(\dgsoft\StructType\DgCity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCity) {
            throw new \InvalidArgumentException(sprintf('The City property can only contain items of \dgsoft\StructType\DgCity, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->City[] = $item;
        return $this;
    }
    /**
     * Get Airport value
     * @return \dgsoft\StructType\DgAirport[]|null
     */
    public function getAirport()
    {
        return $this->Airport;
    }
    /**
     * Set Airport value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirport[] $airport
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setAirport(array $airport = array())
    {
        foreach ($airport as $fareInfoTypeAirportItem) {
            // validation for constraint: itemType
            if (!$fareInfoTypeAirportItem instanceof \dgsoft\StructType\DgAirport) {
                throw new \InvalidArgumentException(sprintf('The Airport property can only contain items of \dgsoft\StructType\DgAirport, "%s" given', is_object($fareInfoTypeAirportItem) ? get_class($fareInfoTypeAirportItem) : gettype($fareInfoTypeAirportItem)), __LINE__);
            }
        }
        $this->Airport = $airport;
        return $this;
    }
    /**
     * Add item to Airport value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAirport $item
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function addToAirport(\dgsoft\StructType\DgAirport $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAirport) {
            throw new \InvalidArgumentException(sprintf('The Airport property can only contain items of \dgsoft\StructType\DgAirport, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Airport[] = $item;
        return $this;
    }
    /**
     * Get NegotiatedFare value
     * @return bool|null
     */
    public function getNegotiatedFare()
    {
        return $this->NegotiatedFare;
    }
    /**
     * Set NegotiatedFare value
     * @param bool $negotiatedFare
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setNegotiatedFare($negotiatedFare = false)
    {
        // validation for constraint: boolean
        if (!is_null($negotiatedFare) && !is_bool($negotiatedFare)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($negotiatedFare)), __LINE__);
        }
        $this->NegotiatedFare = $negotiatedFare;
        return $this;
    }
    /**
     * Get NegotiatedFareCode value
     * @return string|null
     */
    public function getNegotiatedFareCode()
    {
        return $this->NegotiatedFareCode;
    }
    /**
     * Set NegotiatedFareCode value
     * @param string $negotiatedFareCode
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setNegotiatedFareCode($negotiatedFareCode = null)
    {
        // validation for constraint: string
        if (!is_null($negotiatedFareCode) && !is_string($negotiatedFareCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($negotiatedFareCode)), __LINE__);
        }
        $this->NegotiatedFareCode = $negotiatedFareCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get TariffNumber value
     * @return string|null
     */
    public function getTariffNumber()
    {
        return $this->TariffNumber;
    }
    /**
     * Set TariffNumber value
     * @param string $tariffNumber
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setTariffNumber($tariffNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tariffNumber) && !is_string($tariffNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffNumber)), __LINE__);
        }
        $this->TariffNumber = $tariffNumber;
        return $this;
    }
    /**
     * Get RuleNumber value
     * @return string|null
     */
    public function getRuleNumber()
    {
        return $this->RuleNumber;
    }
    /**
     * Set RuleNumber value
     * @param string $ruleNumber
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setRuleNumber($ruleNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ruleNumber) && !is_string($ruleNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ruleNumber)), __LINE__);
        }
        $this->RuleNumber = $ruleNumber;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return int|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param int $routingNumber
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: int
        if (!is_null($routingNumber) && !is_numeric($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
