<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareFamilyDescription StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareFamilyDescription extends AbstractStructBase
{
    /**
     * The FamilyDescName
     * @var string
     */
    public $FamilyDescName;
    /**
     * The FamilyTypeText
     * @var string
     */
    public $FamilyTypeText;
    /**
     * The PaymentType
     * @var string
     */
    public $PaymentType;
    /**
     * Constructor method for FareFamilyDescription
     * @uses DgFareFamilyDescription::setFamilyDescName()
     * @uses DgFareFamilyDescription::setFamilyTypeText()
     * @uses DgFareFamilyDescription::setPaymentType()
     * @param string $familyDescName
     * @param string $familyTypeText
     * @param string $paymentType
     */
    public function __construct($familyDescName = null, $familyTypeText = null, $paymentType = null)
    {
        $this
            ->setFamilyDescName($familyDescName)
            ->setFamilyTypeText($familyTypeText)
            ->setPaymentType($paymentType);
    }
    /**
     * Get FamilyDescName value
     * @return string|null
     */
    public function getFamilyDescName()
    {
        return $this->FamilyDescName;
    }
    /**
     * Set FamilyDescName value
     * @param string $familyDescName
     * @return \dgsoft\StructType\DgFareFamilyDescription
     */
    public function setFamilyDescName($familyDescName = null)
    {
        // validation for constraint: string
        if (!is_null($familyDescName) && !is_string($familyDescName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($familyDescName)), __LINE__);
        }
        $this->FamilyDescName = $familyDescName;
        return $this;
    }
    /**
     * Get FamilyTypeText value
     * @return string|null
     */
    public function getFamilyTypeText()
    {
        return $this->FamilyTypeText;
    }
    /**
     * Set FamilyTypeText value
     * @param string $familyTypeText
     * @return \dgsoft\StructType\DgFareFamilyDescription
     */
    public function setFamilyTypeText($familyTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($familyTypeText) && !is_string($familyTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($familyTypeText)), __LINE__);
        }
        $this->FamilyTypeText = $familyTypeText;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \dgsoft\StructType\DgFareFamilyDescription
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareFamilyDescription
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
