<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareFamily StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFareFamily extends AbstractStructBase
{
    /**
     * The FlightInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightInfo
     */
    public $FlightInfo;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The FareFamilyDescriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfFareFamilyDescription
     */
    public $FareFamilyDescriptions;
    /**
     * The FareInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFareInfo
     */
    public $FareInfo;
    /**
     * The PackageId
     * @var string
     */
    public $PackageId;
    /**
     * The FareFamilyName
     * @var string
     */
    public $FareFamilyName;
    /**
     * The ResBookDesigCabinCode
     * @var string
     */
    public $ResBookDesigCabinCode;
    /**
     * The FareBasis
     * @var string
     */
    public $FareBasis;
    /**
     * The Class
     * @var string
     */
    public $Class;
    /**
     * Constructor method for FareFamily
     * @uses DgFareFamily::setFlightInfo()
     * @uses DgFareFamily::setErrors()
     * @uses DgFareFamily::setFareFamilyDescriptions()
     * @uses DgFareFamily::setFareInfo()
     * @uses DgFareFamily::setPackageId()
     * @uses DgFareFamily::setFareFamilyName()
     * @uses DgFareFamily::setResBookDesigCabinCode()
     * @uses DgFareFamily::setFareBasis()
     * @uses DgFareFamily::setClass()
     * @param \dgsoft\StructType\DgFlightInfo $flightInfo
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\ArrayType\DgArrayOfFareFamilyDescription $fareFamilyDescriptions
     * @param \dgsoft\StructType\DgFareInfo $fareInfo
     * @param string $packageId
     * @param string $fareFamilyName
     * @param string $resBookDesigCabinCode
     * @param string $fareBasis
     * @param string $class
     */
    public function __construct(\dgsoft\StructType\DgFlightInfo $flightInfo = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\ArrayType\DgArrayOfFareFamilyDescription $fareFamilyDescriptions = null, \dgsoft\StructType\DgFareInfo $fareInfo = null, $packageId = null, $fareFamilyName = null, $resBookDesigCabinCode = null, $fareBasis = null, $class = null)
    {
        $this
            ->setFlightInfo($flightInfo)
            ->setErrors($errors)
            ->setFareFamilyDescriptions($fareFamilyDescriptions)
            ->setFareInfo($fareInfo)
            ->setPackageId($packageId)
            ->setFareFamilyName($fareFamilyName)
            ->setResBookDesigCabinCode($resBookDesigCabinCode)
            ->setFareBasis($fareBasis)
            ->setClass($class);
    }
    /**
     * Get FlightInfo value
     * @return \dgsoft\StructType\DgFlightInfo|null
     */
    public function getFlightInfo()
    {
        return $this->FlightInfo;
    }
    /**
     * Set FlightInfo value
     * @param \dgsoft\StructType\DgFlightInfo $flightInfo
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setFlightInfo(\dgsoft\StructType\DgFlightInfo $flightInfo = null)
    {
        $this->FlightInfo = $flightInfo;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get FareFamilyDescriptions value
     * @return \dgsoft\ArrayType\DgArrayOfFareFamilyDescription|null
     */
    public function getFareFamilyDescriptions()
    {
        return $this->FareFamilyDescriptions;
    }
    /**
     * Set FareFamilyDescriptions value
     * @param \dgsoft\ArrayType\DgArrayOfFareFamilyDescription $fareFamilyDescriptions
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setFareFamilyDescriptions(\dgsoft\ArrayType\DgArrayOfFareFamilyDescription $fareFamilyDescriptions = null)
    {
        $this->FareFamilyDescriptions = $fareFamilyDescriptions;
        return $this;
    }
    /**
     * Get FareInfo value
     * @return \dgsoft\StructType\DgFareInfo|null
     */
    public function getFareInfo()
    {
        return $this->FareInfo;
    }
    /**
     * Set FareInfo value
     * @param \dgsoft\StructType\DgFareInfo $fareInfo
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setFareInfo(\dgsoft\StructType\DgFareInfo $fareInfo = null)
    {
        $this->FareInfo = $fareInfo;
        return $this;
    }
    /**
     * Get PackageId value
     * @return string|null
     */
    public function getPackageId()
    {
        return $this->PackageId;
    }
    /**
     * Set PackageId value
     * @param string $packageId
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageId)), __LINE__);
        }
        $this->PackageId = $packageId;
        return $this;
    }
    /**
     * Get FareFamilyName value
     * @return string|null
     */
    public function getFareFamilyName()
    {
        return $this->FareFamilyName;
    }
    /**
     * Set FareFamilyName value
     * @param string $fareFamilyName
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setFareFamilyName($fareFamilyName = null)
    {
        // validation for constraint: string
        if (!is_null($fareFamilyName) && !is_string($fareFamilyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareFamilyName)), __LINE__);
        }
        $this->FareFamilyName = $fareFamilyName;
        return $this;
    }
    /**
     * Get ResBookDesigCabinCode value
     * @return string|null
     */
    public function getResBookDesigCabinCode()
    {
        return $this->ResBookDesigCabinCode;
    }
    /**
     * Set ResBookDesigCabinCode value
     * @param string $resBookDesigCabinCode
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setResBookDesigCabinCode($resBookDesigCabinCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCabinCode) && !is_string($resBookDesigCabinCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resBookDesigCabinCode)), __LINE__);
        }
        $this->ResBookDesigCabinCode = $resBookDesigCabinCode;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return string|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @param string $fareBasis
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareBasis)), __LINE__);
        }
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Get Class value
     * @return string|null
     */
    public function getClass()
    {
        return $this->Class;
    }
    /**
     * Set Class value
     * @param string $class
     * @return \dgsoft\StructType\DgFareFamily
     */
    public function setClass($class = null)
    {
        // validation for constraint: string
        if (!is_null($class) && !is_string($class)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($class)), __LINE__);
        }
        $this->Class = $class;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFareFamily
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
