<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fare StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFare extends AbstractStructBase
{
    /**
     * The BaseAmount
     * @var float
     */
    public $BaseAmount;
    /**
     * The BaseNUC_Amount
     * @var float
     */
    public $BaseNUC_Amount;
    /**
     * The TaxAmount
     * @var float
     */
    public $TaxAmount;
    /**
     * The TotalFare
     * @var float
     */
    public $TotalFare;
    /**
     * The FareDescription
     * @var string
     */
    public $FareDescription;
    /**
     * Constructor method for Fare
     * @uses DgFare::setBaseAmount()
     * @uses DgFare::setBaseNUC_Amount()
     * @uses DgFare::setTaxAmount()
     * @uses DgFare::setTotalFare()
     * @uses DgFare::setFareDescription()
     * @param float $baseAmount
     * @param float $baseNUC_Amount
     * @param float $taxAmount
     * @param float $totalFare
     * @param string $fareDescription
     */
    public function __construct($baseAmount = null, $baseNUC_Amount = null, $taxAmount = null, $totalFare = null, $fareDescription = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setBaseNUC_Amount($baseNUC_Amount)
            ->setTaxAmount($taxAmount)
            ->setTotalFare($totalFare)
            ->setFareDescription($fareDescription);
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \dgsoft\StructType\DgFare
     */
    public function setBaseAmount($baseAmount = null)
    {
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get BaseNUC_Amount value
     * @return float|null
     */
    public function getBaseNUC_Amount()
    {
        return $this->BaseNUC_Amount;
    }
    /**
     * Set BaseNUC_Amount value
     * @param float $baseNUC_Amount
     * @return \dgsoft\StructType\DgFare
     */
    public function setBaseNUC_Amount($baseNUC_Amount = null)
    {
        $this->BaseNUC_Amount = $baseNUC_Amount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \dgsoft\StructType\DgFare
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return float|null
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param float $totalFare
     * @return \dgsoft\StructType\DgFare
     */
    public function setTotalFare($totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get FareDescription value
     * @return string|null
     */
    public function getFareDescription()
    {
        return $this->FareDescription;
    }
    /**
     * Set FareDescription value
     * @param string $fareDescription
     * @return \dgsoft\StructType\DgFare
     */
    public function setFareDescription($fareDescription = null)
    {
        // validation for constraint: string
        if (!is_null($fareDescription) && !is_string($fareDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareDescription)), __LINE__);
        }
        $this->FareDescription = $fareDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
