<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FailbackIndicator StructType
 * @package Dg
 * @subpackage Structs
 */
class DgFailbackIndicator extends AbstractStructBase
{
    /**
     * The FailbackStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FailbackStatus;
    /**
     * The FailbackParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFailbackParameter[]
     */
    public $FailbackParameter;
    /**
     * The ScheduleChangeParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgScheduleChangeParameter[]
     */
    public $ScheduleChangeParameter;
    /**
     * The SeatTakenParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSeatTakenParameter[]
     */
    public $SeatTakenParameter;
    /**
     * The FarebasisChangesParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFarebasisChangesParameter[]
     */
    public $FarebasisChangesParameter;
    /**
     * The AncillaryChangeParameter
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAncillaryChangeParameter[]
     */
    public $AncillaryChangeParameter;
    /**
     * The FailbackFlightRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFailbackFlightRules
     */
    public $FailbackFlightRules;
    /**
     * Constructor method for FailbackIndicator
     * @uses DgFailbackIndicator::setFailbackStatus()
     * @uses DgFailbackIndicator::setFailbackParameter()
     * @uses DgFailbackIndicator::setScheduleChangeParameter()
     * @uses DgFailbackIndicator::setSeatTakenParameter()
     * @uses DgFailbackIndicator::setFarebasisChangesParameter()
     * @uses DgFailbackIndicator::setAncillaryChangeParameter()
     * @uses DgFailbackIndicator::setFailbackFlightRules()
     * @param string $failbackStatus
     * @param \dgsoft\StructType\DgFailbackParameter[] $failbackParameter
     * @param \dgsoft\StructType\DgScheduleChangeParameter[] $scheduleChangeParameter
     * @param \dgsoft\StructType\DgSeatTakenParameter[] $seatTakenParameter
     * @param \dgsoft\StructType\DgFarebasisChangesParameter[] $farebasisChangesParameter
     * @param \dgsoft\StructType\DgAncillaryChangeParameter[] $ancillaryChangeParameter
     * @param \dgsoft\StructType\DgFailbackFlightRules $failbackFlightRules
     */
    public function __construct($failbackStatus = null, array $failbackParameter = array(), array $scheduleChangeParameter = array(), array $seatTakenParameter = array(), array $farebasisChangesParameter = array(), array $ancillaryChangeParameter = array(), \dgsoft\StructType\DgFailbackFlightRules $failbackFlightRules = null)
    {
        $this
            ->setFailbackStatus($failbackStatus)
            ->setFailbackParameter($failbackParameter)
            ->setScheduleChangeParameter($scheduleChangeParameter)
            ->setSeatTakenParameter($seatTakenParameter)
            ->setFarebasisChangesParameter($farebasisChangesParameter)
            ->setAncillaryChangeParameter($ancillaryChangeParameter)
            ->setFailbackFlightRules($failbackFlightRules);
    }
    /**
     * Get FailbackStatus value
     * @return string
     */
    public function getFailbackStatus()
    {
        return $this->FailbackStatus;
    }
    /**
     * Set FailbackStatus value
     * @uses \dgsoft\EnumType\DgFailbackExceptionErrorType::valueIsValid()
     * @uses \dgsoft\EnumType\DgFailbackExceptionErrorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $failbackStatus
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setFailbackStatus($failbackStatus = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgFailbackExceptionErrorType::valueIsValid($failbackStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $failbackStatus, implode(', ', \dgsoft\EnumType\DgFailbackExceptionErrorType::getValidValues())), __LINE__);
        }
        $this->FailbackStatus = $failbackStatus;
        return $this;
    }
    /**
     * Get FailbackParameter value
     * @return \dgsoft\StructType\DgFailbackParameter[]|null
     */
    public function getFailbackParameter()
    {
        return $this->FailbackParameter;
    }
    /**
     * Set FailbackParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFailbackParameter[] $failbackParameter
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setFailbackParameter(array $failbackParameter = array())
    {
        foreach ($failbackParameter as $failbackIndicatorFailbackParameterItem) {
            // validation for constraint: itemType
            if (!$failbackIndicatorFailbackParameterItem instanceof \dgsoft\StructType\DgFailbackParameter) {
                throw new \InvalidArgumentException(sprintf('The FailbackParameter property can only contain items of \dgsoft\StructType\DgFailbackParameter, "%s" given', is_object($failbackIndicatorFailbackParameterItem) ? get_class($failbackIndicatorFailbackParameterItem) : gettype($failbackIndicatorFailbackParameterItem)), __LINE__);
            }
        }
        $this->FailbackParameter = $failbackParameter;
        return $this;
    }
    /**
     * Add item to FailbackParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFailbackParameter $item
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function addToFailbackParameter(\dgsoft\StructType\DgFailbackParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFailbackParameter) {
            throw new \InvalidArgumentException(sprintf('The FailbackParameter property can only contain items of \dgsoft\StructType\DgFailbackParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FailbackParameter[] = $item;
        return $this;
    }
    /**
     * Get ScheduleChangeParameter value
     * @return \dgsoft\StructType\DgScheduleChangeParameter[]|null
     */
    public function getScheduleChangeParameter()
    {
        return $this->ScheduleChangeParameter;
    }
    /**
     * Set ScheduleChangeParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgScheduleChangeParameter[] $scheduleChangeParameter
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setScheduleChangeParameter(array $scheduleChangeParameter = array())
    {
        foreach ($scheduleChangeParameter as $failbackIndicatorScheduleChangeParameterItem) {
            // validation for constraint: itemType
            if (!$failbackIndicatorScheduleChangeParameterItem instanceof \dgsoft\StructType\DgScheduleChangeParameter) {
                throw new \InvalidArgumentException(sprintf('The ScheduleChangeParameter property can only contain items of \dgsoft\StructType\DgScheduleChangeParameter, "%s" given', is_object($failbackIndicatorScheduleChangeParameterItem) ? get_class($failbackIndicatorScheduleChangeParameterItem) : gettype($failbackIndicatorScheduleChangeParameterItem)), __LINE__);
            }
        }
        $this->ScheduleChangeParameter = $scheduleChangeParameter;
        return $this;
    }
    /**
     * Add item to ScheduleChangeParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgScheduleChangeParameter $item
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function addToScheduleChangeParameter(\dgsoft\StructType\DgScheduleChangeParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgScheduleChangeParameter) {
            throw new \InvalidArgumentException(sprintf('The ScheduleChangeParameter property can only contain items of \dgsoft\StructType\DgScheduleChangeParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ScheduleChangeParameter[] = $item;
        return $this;
    }
    /**
     * Get SeatTakenParameter value
     * @return \dgsoft\StructType\DgSeatTakenParameter[]|null
     */
    public function getSeatTakenParameter()
    {
        return $this->SeatTakenParameter;
    }
    /**
     * Set SeatTakenParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSeatTakenParameter[] $seatTakenParameter
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setSeatTakenParameter(array $seatTakenParameter = array())
    {
        foreach ($seatTakenParameter as $failbackIndicatorSeatTakenParameterItem) {
            // validation for constraint: itemType
            if (!$failbackIndicatorSeatTakenParameterItem instanceof \dgsoft\StructType\DgSeatTakenParameter) {
                throw new \InvalidArgumentException(sprintf('The SeatTakenParameter property can only contain items of \dgsoft\StructType\DgSeatTakenParameter, "%s" given', is_object($failbackIndicatorSeatTakenParameterItem) ? get_class($failbackIndicatorSeatTakenParameterItem) : gettype($failbackIndicatorSeatTakenParameterItem)), __LINE__);
            }
        }
        $this->SeatTakenParameter = $seatTakenParameter;
        return $this;
    }
    /**
     * Add item to SeatTakenParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSeatTakenParameter $item
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function addToSeatTakenParameter(\dgsoft\StructType\DgSeatTakenParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSeatTakenParameter) {
            throw new \InvalidArgumentException(sprintf('The SeatTakenParameter property can only contain items of \dgsoft\StructType\DgSeatTakenParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatTakenParameter[] = $item;
        return $this;
    }
    /**
     * Get FarebasisChangesParameter value
     * @return \dgsoft\StructType\DgFarebasisChangesParameter[]|null
     */
    public function getFarebasisChangesParameter()
    {
        return $this->FarebasisChangesParameter;
    }
    /**
     * Set FarebasisChangesParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFarebasisChangesParameter[] $farebasisChangesParameter
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setFarebasisChangesParameter(array $farebasisChangesParameter = array())
    {
        foreach ($farebasisChangesParameter as $failbackIndicatorFarebasisChangesParameterItem) {
            // validation for constraint: itemType
            if (!$failbackIndicatorFarebasisChangesParameterItem instanceof \dgsoft\StructType\DgFarebasisChangesParameter) {
                throw new \InvalidArgumentException(sprintf('The FarebasisChangesParameter property can only contain items of \dgsoft\StructType\DgFarebasisChangesParameter, "%s" given', is_object($failbackIndicatorFarebasisChangesParameterItem) ? get_class($failbackIndicatorFarebasisChangesParameterItem) : gettype($failbackIndicatorFarebasisChangesParameterItem)), __LINE__);
            }
        }
        $this->FarebasisChangesParameter = $farebasisChangesParameter;
        return $this;
    }
    /**
     * Add item to FarebasisChangesParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFarebasisChangesParameter $item
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function addToFarebasisChangesParameter(\dgsoft\StructType\DgFarebasisChangesParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFarebasisChangesParameter) {
            throw new \InvalidArgumentException(sprintf('The FarebasisChangesParameter property can only contain items of \dgsoft\StructType\DgFarebasisChangesParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FarebasisChangesParameter[] = $item;
        return $this;
    }
    /**
     * Get AncillaryChangeParameter value
     * @return \dgsoft\StructType\DgAncillaryChangeParameter[]|null
     */
    public function getAncillaryChangeParameter()
    {
        return $this->AncillaryChangeParameter;
    }
    /**
     * Set AncillaryChangeParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryChangeParameter[] $ancillaryChangeParameter
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setAncillaryChangeParameter(array $ancillaryChangeParameter = array())
    {
        foreach ($ancillaryChangeParameter as $failbackIndicatorAncillaryChangeParameterItem) {
            // validation for constraint: itemType
            if (!$failbackIndicatorAncillaryChangeParameterItem instanceof \dgsoft\StructType\DgAncillaryChangeParameter) {
                throw new \InvalidArgumentException(sprintf('The AncillaryChangeParameter property can only contain items of \dgsoft\StructType\DgAncillaryChangeParameter, "%s" given', is_object($failbackIndicatorAncillaryChangeParameterItem) ? get_class($failbackIndicatorAncillaryChangeParameterItem) : gettype($failbackIndicatorAncillaryChangeParameterItem)), __LINE__);
            }
        }
        $this->AncillaryChangeParameter = $ancillaryChangeParameter;
        return $this;
    }
    /**
     * Add item to AncillaryChangeParameter value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAncillaryChangeParameter $item
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function addToAncillaryChangeParameter(\dgsoft\StructType\DgAncillaryChangeParameter $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAncillaryChangeParameter) {
            throw new \InvalidArgumentException(sprintf('The AncillaryChangeParameter property can only contain items of \dgsoft\StructType\DgAncillaryChangeParameter, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AncillaryChangeParameter[] = $item;
        return $this;
    }
    /**
     * Get FailbackFlightRules value
     * @return \dgsoft\StructType\DgFailbackFlightRules|null
     */
    public function getFailbackFlightRules()
    {
        return $this->FailbackFlightRules;
    }
    /**
     * Set FailbackFlightRules value
     * @param \dgsoft\StructType\DgFailbackFlightRules $failbackFlightRules
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public function setFailbackFlightRules(\dgsoft\StructType\DgFailbackFlightRules $failbackFlightRules = null)
    {
        $this->FailbackFlightRules = $failbackFlightRules;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgFailbackIndicator
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
