<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorsType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgErrorsType extends AbstractStructBase
{
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorType[]
     */
    public $Error;
    /**
     * The MyProperty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MyProperty;
    /**
     * Constructor method for ErrorsType
     * @uses DgErrorsType::setError()
     * @uses DgErrorsType::setMyProperty()
     * @param \dgsoft\StructType\DgErrorType[] $error
     * @param string $myProperty
     */
    public function __construct(array $error = array(), $myProperty = null)
    {
        $this
            ->setError($error)
            ->setMyProperty($myProperty);
    }
    /**
     * Get Error value
     * @return \dgsoft\StructType\DgErrorType[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgErrorType[] $error
     * @return \dgsoft\StructType\DgErrorsType
     */
    public function setError(array $error = array())
    {
        foreach ($error as $errorsTypeErrorItem) {
            // validation for constraint: itemType
            if (!$errorsTypeErrorItem instanceof \dgsoft\StructType\DgErrorType) {
                throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \dgsoft\StructType\DgErrorType, "%s" given', is_object($errorsTypeErrorItem) ? get_class($errorsTypeErrorItem) : gettype($errorsTypeErrorItem)), __LINE__);
            }
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgErrorType $item
     * @return \dgsoft\StructType\DgErrorsType
     */
    public function addToError(\dgsoft\StructType\DgErrorType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgErrorType) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \dgsoft\StructType\DgErrorType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get MyProperty value
     * @return string|null
     */
    public function getMyProperty()
    {
        return $this->MyProperty;
    }
    /**
     * Set MyProperty value
     * @param string $myProperty
     * @return \dgsoft\StructType\DgErrorsType
     */
    public function setMyProperty($myProperty = null)
    {
        // validation for constraint: string
        if (!is_null($myProperty) && !is_string($myProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($myProperty)), __LINE__);
        }
        $this->MyProperty = $myProperty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgErrorsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
