<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entity StructType
 * @package Dg
 * @subpackage Structs
 */
class DgEntity extends DgDBBaseEntity
{
    /**
     * The TravelPolicySetID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $TravelPolicySetID;
    /**
     * The IsUpdatableUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsUpdatableUser;
    /**
     * The TravelPolicySetName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TravelPolicySetName;
    /**
     * The TaxOffice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxOffice;
    /**
     * The TaxNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxNo;
    /**
     * The AddressDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressDetails
     */
    public $AddressDetails;
    /**
     * The CommunicationDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCommunicationDetails
     */
    public $CommunicationDetails;
    /**
     * The DocumentDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDocumentDetails
     */
    public $DocumentDetails;
    /**
     * The ClientReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClientReference;
    /**
     * The CostNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CostNumber;
    /**
     * The CurrentAccountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrentAccountCode;
    /**
     * The EMailFooter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMailFooter;
    /**
     * The EMailHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EMailHeader;
    /**
     * Constructor method for Entity
     * @uses DgEntity::setTravelPolicySetID()
     * @uses DgEntity::setIsUpdatableUser()
     * @uses DgEntity::setTravelPolicySetName()
     * @uses DgEntity::setTaxOffice()
     * @uses DgEntity::setTaxNo()
     * @uses DgEntity::setAddressDetails()
     * @uses DgEntity::setCommunicationDetails()
     * @uses DgEntity::setDocumentDetails()
     * @uses DgEntity::setClientReference()
     * @uses DgEntity::setCostNumber()
     * @uses DgEntity::setCurrentAccountCode()
     * @uses DgEntity::setEMailFooter()
     * @uses DgEntity::setEMailHeader()
     * @param int $travelPolicySetID
     * @param bool $isUpdatableUser
     * @param string $travelPolicySetName
     * @param string $taxOffice
     * @param string $taxNo
     * @param \dgsoft\StructType\DgAddressDetails $addressDetails
     * @param \dgsoft\StructType\DgCommunicationDetails $communicationDetails
     * @param \dgsoft\StructType\DgDocumentDetails $documentDetails
     * @param string $clientReference
     * @param string $costNumber
     * @param string $currentAccountCode
     * @param string $eMailFooter
     * @param string $eMailHeader
     */
    public function __construct($travelPolicySetID = null, $isUpdatableUser = null, $travelPolicySetName = null, $taxOffice = null, $taxNo = null, \dgsoft\StructType\DgAddressDetails $addressDetails = null, \dgsoft\StructType\DgCommunicationDetails $communicationDetails = null, \dgsoft\StructType\DgDocumentDetails $documentDetails = null, $clientReference = null, $costNumber = null, $currentAccountCode = null, $eMailFooter = null, $eMailHeader = null)
    {
        $this
            ->setTravelPolicySetID($travelPolicySetID)
            ->setIsUpdatableUser($isUpdatableUser)
            ->setTravelPolicySetName($travelPolicySetName)
            ->setTaxOffice($taxOffice)
            ->setTaxNo($taxNo)
            ->setAddressDetails($addressDetails)
            ->setCommunicationDetails($communicationDetails)
            ->setDocumentDetails($documentDetails)
            ->setClientReference($clientReference)
            ->setCostNumber($costNumber)
            ->setCurrentAccountCode($currentAccountCode)
            ->setEMailFooter($eMailFooter)
            ->setEMailHeader($eMailHeader);
    }
    /**
     * Get TravelPolicySetID value
     * @return int
     */
    public function getTravelPolicySetID()
    {
        return $this->TravelPolicySetID;
    }
    /**
     * Set TravelPolicySetID value
     * @param int $travelPolicySetID
     * @return \dgsoft\StructType\DgEntity
     */
    public function setTravelPolicySetID($travelPolicySetID = null)
    {
        // validation for constraint: int
        if (!is_null($travelPolicySetID) && !is_numeric($travelPolicySetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($travelPolicySetID)), __LINE__);
        }
        $this->TravelPolicySetID = $travelPolicySetID;
        return $this;
    }
    /**
     * Get IsUpdatableUser value
     * @return bool
     */
    public function getIsUpdatableUser()
    {
        return $this->IsUpdatableUser;
    }
    /**
     * Set IsUpdatableUser value
     * @param bool $isUpdatableUser
     * @return \dgsoft\StructType\DgEntity
     */
    public function setIsUpdatableUser($isUpdatableUser = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatableUser) && !is_bool($isUpdatableUser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isUpdatableUser)), __LINE__);
        }
        $this->IsUpdatableUser = $isUpdatableUser;
        return $this;
    }
    /**
     * Get TravelPolicySetName value
     * @return string|null
     */
    public function getTravelPolicySetName()
    {
        return $this->TravelPolicySetName;
    }
    /**
     * Set TravelPolicySetName value
     * @param string $travelPolicySetName
     * @return \dgsoft\StructType\DgEntity
     */
    public function setTravelPolicySetName($travelPolicySetName = null)
    {
        // validation for constraint: string
        if (!is_null($travelPolicySetName) && !is_string($travelPolicySetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelPolicySetName)), __LINE__);
        }
        $this->TravelPolicySetName = $travelPolicySetName;
        return $this;
    }
    /**
     * Get TaxOffice value
     * @return string|null
     */
    public function getTaxOffice()
    {
        return $this->TaxOffice;
    }
    /**
     * Set TaxOffice value
     * @param string $taxOffice
     * @return \dgsoft\StructType\DgEntity
     */
    public function setTaxOffice($taxOffice = null)
    {
        // validation for constraint: string
        if (!is_null($taxOffice) && !is_string($taxOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxOffice)), __LINE__);
        }
        $this->TaxOffice = $taxOffice;
        return $this;
    }
    /**
     * Get TaxNo value
     * @return string|null
     */
    public function getTaxNo()
    {
        return $this->TaxNo;
    }
    /**
     * Set TaxNo value
     * @param string $taxNo
     * @return \dgsoft\StructType\DgEntity
     */
    public function setTaxNo($taxNo = null)
    {
        // validation for constraint: string
        if (!is_null($taxNo) && !is_string($taxNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxNo)), __LINE__);
        }
        $this->TaxNo = $taxNo;
        return $this;
    }
    /**
     * Get AddressDetails value
     * @return \dgsoft\StructType\DgAddressDetails|null
     */
    public function getAddressDetails()
    {
        return $this->AddressDetails;
    }
    /**
     * Set AddressDetails value
     * @param \dgsoft\StructType\DgAddressDetails $addressDetails
     * @return \dgsoft\StructType\DgEntity
     */
    public function setAddressDetails(\dgsoft\StructType\DgAddressDetails $addressDetails = null)
    {
        $this->AddressDetails = $addressDetails;
        return $this;
    }
    /**
     * Get CommunicationDetails value
     * @return \dgsoft\StructType\DgCommunicationDetails|null
     */
    public function getCommunicationDetails()
    {
        return $this->CommunicationDetails;
    }
    /**
     * Set CommunicationDetails value
     * @param \dgsoft\StructType\DgCommunicationDetails $communicationDetails
     * @return \dgsoft\StructType\DgEntity
     */
    public function setCommunicationDetails(\dgsoft\StructType\DgCommunicationDetails $communicationDetails = null)
    {
        $this->CommunicationDetails = $communicationDetails;
        return $this;
    }
    /**
     * Get DocumentDetails value
     * @return \dgsoft\StructType\DgDocumentDetails|null
     */
    public function getDocumentDetails()
    {
        return $this->DocumentDetails;
    }
    /**
     * Set DocumentDetails value
     * @param \dgsoft\StructType\DgDocumentDetails $documentDetails
     * @return \dgsoft\StructType\DgEntity
     */
    public function setDocumentDetails(\dgsoft\StructType\DgDocumentDetails $documentDetails = null)
    {
        $this->DocumentDetails = $documentDetails;
        return $this;
    }
    /**
     * Get ClientReference value
     * @return string|null
     */
    public function getClientReference()
    {
        return $this->ClientReference;
    }
    /**
     * Set ClientReference value
     * @param string $clientReference
     * @return \dgsoft\StructType\DgEntity
     */
    public function setClientReference($clientReference = null)
    {
        // validation for constraint: string
        if (!is_null($clientReference) && !is_string($clientReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientReference)), __LINE__);
        }
        $this->ClientReference = $clientReference;
        return $this;
    }
    /**
     * Get CostNumber value
     * @return string|null
     */
    public function getCostNumber()
    {
        return $this->CostNumber;
    }
    /**
     * Set CostNumber value
     * @param string $costNumber
     * @return \dgsoft\StructType\DgEntity
     */
    public function setCostNumber($costNumber = null)
    {
        // validation for constraint: string
        if (!is_null($costNumber) && !is_string($costNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costNumber)), __LINE__);
        }
        $this->CostNumber = $costNumber;
        return $this;
    }
    /**
     * Get CurrentAccountCode value
     * @return string|null
     */
    public function getCurrentAccountCode()
    {
        return $this->CurrentAccountCode;
    }
    /**
     * Set CurrentAccountCode value
     * @param string $currentAccountCode
     * @return \dgsoft\StructType\DgEntity
     */
    public function setCurrentAccountCode($currentAccountCode = null)
    {
        // validation for constraint: string
        if (!is_null($currentAccountCode) && !is_string($currentAccountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currentAccountCode)), __LINE__);
        }
        $this->CurrentAccountCode = $currentAccountCode;
        return $this;
    }
    /**
     * Get EMailFooter value
     * @return string|null
     */
    public function getEMailFooter()
    {
        return $this->EMailFooter;
    }
    /**
     * Set EMailFooter value
     * @param string $eMailFooter
     * @return \dgsoft\StructType\DgEntity
     */
    public function setEMailFooter($eMailFooter = null)
    {
        // validation for constraint: string
        if (!is_null($eMailFooter) && !is_string($eMailFooter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMailFooter)), __LINE__);
        }
        $this->EMailFooter = $eMailFooter;
        return $this;
    }
    /**
     * Get EMailHeader value
     * @return string|null
     */
    public function getEMailHeader()
    {
        return $this->EMailHeader;
    }
    /**
     * Set EMailHeader value
     * @param string $eMailHeader
     * @return \dgsoft\StructType\DgEntity
     */
    public function setEMailHeader($eMailHeader = null)
    {
        // validation for constraint: string
        if (!is_null($eMailHeader) && !is_string($eMailHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eMailHeader)), __LINE__);
        }
        $this->EMailHeader = $eMailHeader;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
