<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployerType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgEmployerType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $CompanyName;
    /**
     * The RelatedEmployer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCompanyNameType[]
     */
    public $RelatedEmployer;
    /**
     * The EmployeeInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgEmployeeInfoType[]
     */
    public $EmployeeInfo;
    /**
     * The InternalRefNmbr
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFreeTextType[]
     */
    public $InternalRefNmbr;
    /**
     * The TravelArranger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelArrangerType[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyProgramType[]
     */
    public $LoyaltyProgram;
    /**
     * The DefaultInd
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $DefaultInd;
    /**
     * The OfficeType
     * @var string
     */
    public $OfficeType;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for EmployerType
     * @uses DgEmployerType::setCompanyName()
     * @uses DgEmployerType::setRelatedEmployer()
     * @uses DgEmployerType::setEmployeeInfo()
     * @uses DgEmployerType::setInternalRefNmbr()
     * @uses DgEmployerType::setTravelArranger()
     * @uses DgEmployerType::setLoyaltyProgram()
     * @uses DgEmployerType::setDefaultInd()
     * @uses DgEmployerType::setOfficeType()
     * @uses DgEmployerType::setEffectiveDate()
     * @uses DgEmployerType::setExpireDate()
     * @param \dgsoft\StructType\DgCompanyNameType $companyName
     * @param \dgsoft\StructType\DgCompanyNameType[] $relatedEmployer
     * @param \dgsoft\StructType\DgEmployeeInfoType[] $employeeInfo
     * @param \dgsoft\StructType\DgFreeTextType[] $internalRefNmbr
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @param \dgsoft\StructType\DgLoyaltyProgramType[] $loyaltyProgram
     * @param bool $defaultInd
     * @param string $officeType
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\dgsoft\StructType\DgCompanyNameType $companyName = null, array $relatedEmployer = array(), array $employeeInfo = array(), array $internalRefNmbr = array(), array $travelArranger = array(), array $loyaltyProgram = array(), $defaultInd = false, $officeType = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setRelatedEmployer($relatedEmployer)
            ->setEmployeeInfo($employeeInfo)
            ->setInternalRefNmbr($internalRefNmbr)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setDefaultInd($defaultInd)
            ->setOfficeType($officeType)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CompanyName value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param \dgsoft\StructType\DgCompanyNameType $companyName
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setCompanyName(\dgsoft\StructType\DgCompanyNameType $companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get RelatedEmployer value
     * @return \dgsoft\StructType\DgCompanyNameType[]|null
     */
    public function getRelatedEmployer()
    {
        return $this->RelatedEmployer;
    }
    /**
     * Set RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType[] $relatedEmployer
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setRelatedEmployer(array $relatedEmployer = array())
    {
        foreach ($relatedEmployer as $employerTypeRelatedEmployerItem) {
            // validation for constraint: itemType
            if (!$employerTypeRelatedEmployerItem instanceof \dgsoft\StructType\DgCompanyNameType) {
                throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($employerTypeRelatedEmployerItem) ? get_class($employerTypeRelatedEmployerItem) : gettype($employerTypeRelatedEmployerItem)), __LINE__);
            }
        }
        $this->RelatedEmployer = $relatedEmployer;
        return $this;
    }
    /**
     * Add item to RelatedEmployer value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCompanyNameType $item
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function addToRelatedEmployer(\dgsoft\StructType\DgCompanyNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCompanyNameType) {
            throw new \InvalidArgumentException(sprintf('The RelatedEmployer property can only contain items of \dgsoft\StructType\DgCompanyNameType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedEmployer[] = $item;
        return $this;
    }
    /**
     * Get EmployeeInfo value
     * @return \dgsoft\StructType\DgEmployeeInfoType[]|null
     */
    public function getEmployeeInfo()
    {
        return $this->EmployeeInfo;
    }
    /**
     * Set EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployeeInfoType[] $employeeInfo
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setEmployeeInfo(array $employeeInfo = array())
    {
        foreach ($employeeInfo as $employerTypeEmployeeInfoItem) {
            // validation for constraint: itemType
            if (!$employerTypeEmployeeInfoItem instanceof \dgsoft\StructType\DgEmployeeInfoType) {
                throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \dgsoft\StructType\DgEmployeeInfoType, "%s" given', is_object($employerTypeEmployeeInfoItem) ? get_class($employerTypeEmployeeInfoItem) : gettype($employerTypeEmployeeInfoItem)), __LINE__);
            }
        }
        $this->EmployeeInfo = $employeeInfo;
        return $this;
    }
    /**
     * Add item to EmployeeInfo value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgEmployeeInfoType $item
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function addToEmployeeInfo(\dgsoft\StructType\DgEmployeeInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgEmployeeInfoType) {
            throw new \InvalidArgumentException(sprintf('The EmployeeInfo property can only contain items of \dgsoft\StructType\DgEmployeeInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmployeeInfo[] = $item;
        return $this;
    }
    /**
     * Get InternalRefNmbr value
     * @return \dgsoft\StructType\DgFreeTextType[]|null
     */
    public function getInternalRefNmbr()
    {
        return $this->InternalRefNmbr;
    }
    /**
     * Set InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType[] $internalRefNmbr
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setInternalRefNmbr(array $internalRefNmbr = array())
    {
        foreach ($internalRefNmbr as $employerTypeInternalRefNmbrItem) {
            // validation for constraint: itemType
            if (!$employerTypeInternalRefNmbrItem instanceof \dgsoft\StructType\DgFreeTextType) {
                throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($employerTypeInternalRefNmbrItem) ? get_class($employerTypeInternalRefNmbrItem) : gettype($employerTypeInternalRefNmbrItem)), __LINE__);
            }
        }
        $this->InternalRefNmbr = $internalRefNmbr;
        return $this;
    }
    /**
     * Add item to InternalRefNmbr value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgFreeTextType $item
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function addToInternalRefNmbr(\dgsoft\StructType\DgFreeTextType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgFreeTextType) {
            throw new \InvalidArgumentException(sprintf('The InternalRefNmbr property can only contain items of \dgsoft\StructType\DgFreeTextType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InternalRefNmbr[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return \dgsoft\StructType\DgTravelArrangerType[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType[] $travelArranger
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        foreach ($travelArranger as $employerTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (!$employerTypeTravelArrangerItem instanceof \dgsoft\StructType\DgTravelArrangerType) {
                throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($employerTypeTravelArrangerItem) ? get_class($employerTypeTravelArrangerItem) : gettype($employerTypeTravelArrangerItem)), __LINE__);
            }
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTravelArrangerType $item
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function addToTravelArranger(\dgsoft\StructType\DgTravelArrangerType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTravelArrangerType) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of \dgsoft\StructType\DgTravelArrangerType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return \dgsoft\StructType\DgLoyaltyProgramType[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyProgramType[] $loyaltyProgram
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        foreach ($loyaltyProgram as $employerTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (!$employerTypeLoyaltyProgramItem instanceof \dgsoft\StructType\DgLoyaltyProgramType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \dgsoft\StructType\DgLoyaltyProgramType, "%s" given', is_object($employerTypeLoyaltyProgramItem) ? get_class($employerTypeLoyaltyProgramItem) : gettype($employerTypeLoyaltyProgramItem)), __LINE__);
            }
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyProgramType $item
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function addToLoyaltyProgram(\dgsoft\StructType\DgLoyaltyProgramType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyProgramType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of \dgsoft\StructType\DgLoyaltyProgramType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get DefaultInd value
     * @return bool|null
     */
    public function getDefaultInd()
    {
        return $this->DefaultInd;
    }
    /**
     * Set DefaultInd value
     * @param bool $defaultInd
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setDefaultInd($defaultInd = false)
    {
        // validation for constraint: boolean
        if (!is_null($defaultInd) && !is_bool($defaultInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($defaultInd)), __LINE__);
        }
        $this->DefaultInd = $defaultInd;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @uses \dgsoft\EnumType\DgOfficeLocationType::valueIsValid()
     * @uses \dgsoft\EnumType\DgOfficeLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $officeType
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgOfficeLocationType::valueIsValid($officeType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $officeType, implode(', ', \dgsoft\EnumType\DgOfficeLocationType::getValidValues())), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgEmployerType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgEmployerType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
