<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email StructType
 * @package Dg
 * @subpackage Structs
 */
class DgEmail extends DgEmailType
{
    /**
     * The _
     * @var \dgsoft\StructType\DgEmailType
     */
    public $_;
    /**
     * The Operation
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for Email
     * @uses DgEmail::set_()
     * @uses DgEmail::setOperation()
     * @param \dgsoft\StructType\DgEmailType $_
     * @param string $operation
     */
    public function __construct(\dgsoft\StructType\DgEmailType $_ = null, $operation = null)
    {
        $this
            ->set_($_)
            ->setOperation($operation);
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgEmailType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgEmailType $_
     * @return \dgsoft\StructType\DgEmail
     */
    public function set_(\dgsoft\StructType\DgEmailType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \dgsoft\EnumType\DgActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \dgsoft\StructType\DgEmail
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operation, implode(', ', \dgsoft\EnumType\DgActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgEmail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
