<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditPNRRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgEditPNRRQ extends AbstractStructBase
{
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $BookingReferenceID;
    /**
     * The SurName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurName;
    /**
     * The AgentSignature
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentSignature;
    /**
     * The PassengerDetailChanges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPassengerDetailChanges
     */
    public $PassengerDetailChanges;
    /**
     * The PNRRemarkChanges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPNRRemarkChange
     */
    public $PNRRemarkChanges;
    /**
     * The OSIElementChanges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfOSIElementChange
     */
    public $OSIElementChanges;
    /**
     * Constructor method for EditPNRRQ
     * @uses DgEditPNRRQ::setBookingReferenceID()
     * @uses DgEditPNRRQ::setSurName()
     * @uses DgEditPNRRQ::setAgentSignature()
     * @uses DgEditPNRRQ::setPassengerDetailChanges()
     * @uses DgEditPNRRQ::setPNRRemarkChanges()
     * @uses DgEditPNRRQ::setOSIElementChanges()
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @param string $surName
     * @param string $agentSignature
     * @param \dgsoft\StructType\DgPassengerDetailChanges $passengerDetailChanges
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkChange $pNRRemarkChanges
     * @param \dgsoft\ArrayType\DgArrayOfOSIElementChange $oSIElementChanges
     */
    public function __construct(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null, $surName = null, $agentSignature = null, \dgsoft\StructType\DgPassengerDetailChanges $passengerDetailChanges = null, \dgsoft\ArrayType\DgArrayOfPNRRemarkChange $pNRRemarkChanges = null, \dgsoft\ArrayType\DgArrayOfOSIElementChange $oSIElementChanges = null)
    {
        $this
            ->setBookingReferenceID($bookingReferenceID)
            ->setSurName($surName)
            ->setAgentSignature($agentSignature)
            ->setPassengerDetailChanges($passengerDetailChanges)
            ->setPNRRemarkChanges($pNRRemarkChanges)
            ->setOSIElementChanges($oSIElementChanges);
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @param \dgsoft\StructType\DgUniqueID_Type $bookingReferenceID
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public function setBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $bookingReferenceID = null)
    {
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Get SurName value
     * @return string|null
     */
    public function getSurName()
    {
        return $this->SurName;
    }
    /**
     * Set SurName value
     * @param string $surName
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public function setSurName($surName = null)
    {
        // validation for constraint: string
        if (!is_null($surName) && !is_string($surName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surName)), __LINE__);
        }
        $this->SurName = $surName;
        return $this;
    }
    /**
     * Get AgentSignature value
     * @return string|null
     */
    public function getAgentSignature()
    {
        return $this->AgentSignature;
    }
    /**
     * Set AgentSignature value
     * @param string $agentSignature
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public function setAgentSignature($agentSignature = null)
    {
        // validation for constraint: string
        if (!is_null($agentSignature) && !is_string($agentSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentSignature)), __LINE__);
        }
        $this->AgentSignature = $agentSignature;
        return $this;
    }
    /**
     * Get PassengerDetailChanges value
     * @return \dgsoft\StructType\DgPassengerDetailChanges|null
     */
    public function getPassengerDetailChanges()
    {
        return $this->PassengerDetailChanges;
    }
    /**
     * Set PassengerDetailChanges value
     * @param \dgsoft\StructType\DgPassengerDetailChanges $passengerDetailChanges
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public function setPassengerDetailChanges(\dgsoft\StructType\DgPassengerDetailChanges $passengerDetailChanges = null)
    {
        $this->PassengerDetailChanges = $passengerDetailChanges;
        return $this;
    }
    /**
     * Get PNRRemarkChanges value
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkChange|null
     */
    public function getPNRRemarkChanges()
    {
        return $this->PNRRemarkChanges;
    }
    /**
     * Set PNRRemarkChanges value
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkChange $pNRRemarkChanges
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public function setPNRRemarkChanges(\dgsoft\ArrayType\DgArrayOfPNRRemarkChange $pNRRemarkChanges = null)
    {
        $this->PNRRemarkChanges = $pNRRemarkChanges;
        return $this;
    }
    /**
     * Get OSIElementChanges value
     * @return \dgsoft\ArrayType\DgArrayOfOSIElementChange|null
     */
    public function getOSIElementChanges()
    {
        return $this->OSIElementChanges;
    }
    /**
     * Set OSIElementChanges value
     * @param \dgsoft\ArrayType\DgArrayOfOSIElementChange $oSIElementChanges
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public function setOSIElementChanges(\dgsoft\ArrayType\DgArrayOfOSIElementChange $oSIElementChanges = null)
    {
        $this->OSIElementChanges = $oSIElementChanges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgEditPNRRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
