<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETicketURLs StructType
 * @package Dg
 * @subpackage Structs
 */
class DgETicketURLs extends AbstractStructBase
{
    /**
     * The ETicketURL
     * @var string
     */
    public $ETicketURL;
    /**
     * The ProviderType
     * @var string
     */
    public $ProviderType;
    /**
     * Constructor method for ETicketURLs
     * @uses DgETicketURLs::setETicketURL()
     * @uses DgETicketURLs::setProviderType()
     * @param string $eTicketURL
     * @param string $providerType
     */
    public function __construct($eTicketURL = null, $providerType = null)
    {
        $this
            ->setETicketURL($eTicketURL)
            ->setProviderType($providerType);
    }
    /**
     * Get ETicketURL value
     * @return string|null
     */
    public function getETicketURL()
    {
        return $this->ETicketURL;
    }
    /**
     * Set ETicketURL value
     * @param string $eTicketURL
     * @return \dgsoft\StructType\DgETicketURLs
     */
    public function setETicketURL($eTicketURL = null)
    {
        // validation for constraint: string
        if (!is_null($eTicketURL) && !is_string($eTicketURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eTicketURL)), __LINE__);
        }
        $this->ETicketURL = $eTicketURL;
        return $this;
    }
    /**
     * Get ProviderType value
     * @return string|null
     */
    public function getProviderType()
    {
        return $this->ProviderType;
    }
    /**
     * Set ProviderType value
     * @param string $providerType
     * @return \dgsoft\StructType\DgETicketURLs
     */
    public function setProviderType($providerType = null)
    {
        // validation for constraint: string
        if (!is_null($providerType) && !is_string($providerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerType)), __LINE__);
        }
        $this->ProviderType = $providerType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgETicketURLs
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
