<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ETicketInfo StructType
 * @package Dg
 * @subpackage Structs
 */
class DgETicketInfo extends AbstractStructBase
{
    /**
     * The EquivalentFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $EquivalentFare;
    /**
     * The TotalFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalFare;
    /**
     * The AgencyTitle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyTitle;
    /**
     * The AgencyAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressType
     */
    public $AgencyAddress;
    /**
     * The AgencyTelNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgencyTelNo;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The IATAID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IATAID;
    /**
     * The TicketingDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketingDate;
    /**
     * The PassengerName_Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassengerName_Surname;
    /**
     * The FrequentFlyer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FrequentFlyer;
    /**
     * The IssuingAirline
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuingAirline;
    /**
     * The BookingRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BookingRef;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareCalculation;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Endorsements;
    /**
     * The ExchangeRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ExchangeRate;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentType;
    /**
     * The AirFare
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $AirFare;
    /**
     * The AirFareCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AirFareCurrency;
    /**
     * The ServiceFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $ServiceFee;
    /**
     * The EquivalentFareCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EquivalentFareCurrency;
    /**
     * The TotalFareCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TotalFareCurrency;
    /**
     * The TicketCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketCurrency;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfTaxInfo
     */
    public $Taxes;
    /**
     * The ControlNumbers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ControlNumbers;
    /**
     * The Itineraries
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfETicketItineraryInfo
     */
    public $Itineraries;
    /**
     * The TicketNumber
     * @var string
     */
    public $TicketNumber;
    /**
     * Constructor method for ETicketInfo
     * @uses DgETicketInfo::setEquivalentFare()
     * @uses DgETicketInfo::setTotalFare()
     * @uses DgETicketInfo::setAgencyTitle()
     * @uses DgETicketInfo::setAgencyAddress()
     * @uses DgETicketInfo::setAgencyTelNo()
     * @uses DgETicketInfo::setAgentID()
     * @uses DgETicketInfo::setIATAID()
     * @uses DgETicketInfo::setTicketingDate()
     * @uses DgETicketInfo::setPassengerName_Surname()
     * @uses DgETicketInfo::setFrequentFlyer()
     * @uses DgETicketInfo::setIssuingAirline()
     * @uses DgETicketInfo::setBookingRef()
     * @uses DgETicketInfo::setFareCalculation()
     * @uses DgETicketInfo::setEndorsements()
     * @uses DgETicketInfo::setExchangeRate()
     * @uses DgETicketInfo::setPaymentType()
     * @uses DgETicketInfo::setAirFare()
     * @uses DgETicketInfo::setAirFareCurrency()
     * @uses DgETicketInfo::setServiceFee()
     * @uses DgETicketInfo::setEquivalentFareCurrency()
     * @uses DgETicketInfo::setTotalFareCurrency()
     * @uses DgETicketInfo::setTicketCurrency()
     * @uses DgETicketInfo::setTaxes()
     * @uses DgETicketInfo::setControlNumbers()
     * @uses DgETicketInfo::setItineraries()
     * @uses DgETicketInfo::setTicketNumber()
     * @param float $equivalentFare
     * @param float $totalFare
     * @param string $agencyTitle
     * @param \dgsoft\StructType\DgAddressType $agencyAddress
     * @param string $agencyTelNo
     * @param string $agentID
     * @param string $iATAID
     * @param string $ticketingDate
     * @param string $passengerName_Surname
     * @param string $frequentFlyer
     * @param string $issuingAirline
     * @param string $bookingRef
     * @param string $fareCalculation
     * @param string $endorsements
     * @param float $exchangeRate
     * @param string $paymentType
     * @param float $airFare
     * @param string $airFareCurrency
     * @param float $serviceFee
     * @param string $equivalentFareCurrency
     * @param string $totalFareCurrency
     * @param string $ticketCurrency
     * @param \dgsoft\ArrayType\DgArrayOfTaxInfo $taxes
     * @param string $controlNumbers
     * @param \dgsoft\ArrayType\DgArrayOfETicketItineraryInfo $itineraries
     * @param string $ticketNumber
     */
    public function __construct($equivalentFare = null, $totalFare = null, $agencyTitle = null, \dgsoft\StructType\DgAddressType $agencyAddress = null, $agencyTelNo = null, $agentID = null, $iATAID = null, $ticketingDate = null, $passengerName_Surname = null, $frequentFlyer = null, $issuingAirline = null, $bookingRef = null, $fareCalculation = null, $endorsements = null, $exchangeRate = null, $paymentType = null, $airFare = null, $airFareCurrency = null, $serviceFee = null, $equivalentFareCurrency = null, $totalFareCurrency = null, $ticketCurrency = null, \dgsoft\ArrayType\DgArrayOfTaxInfo $taxes = null, $controlNumbers = null, \dgsoft\ArrayType\DgArrayOfETicketItineraryInfo $itineraries = null, $ticketNumber = null)
    {
        $this
            ->setEquivalentFare($equivalentFare)
            ->setTotalFare($totalFare)
            ->setAgencyTitle($agencyTitle)
            ->setAgencyAddress($agencyAddress)
            ->setAgencyTelNo($agencyTelNo)
            ->setAgentID($agentID)
            ->setIATAID($iATAID)
            ->setTicketingDate($ticketingDate)
            ->setPassengerName_Surname($passengerName_Surname)
            ->setFrequentFlyer($frequentFlyer)
            ->setIssuingAirline($issuingAirline)
            ->setBookingRef($bookingRef)
            ->setFareCalculation($fareCalculation)
            ->setEndorsements($endorsements)
            ->setExchangeRate($exchangeRate)
            ->setPaymentType($paymentType)
            ->setAirFare($airFare)
            ->setAirFareCurrency($airFareCurrency)
            ->setServiceFee($serviceFee)
            ->setEquivalentFareCurrency($equivalentFareCurrency)
            ->setTotalFareCurrency($totalFareCurrency)
            ->setTicketCurrency($ticketCurrency)
            ->setTaxes($taxes)
            ->setControlNumbers($controlNumbers)
            ->setItineraries($itineraries)
            ->setTicketNumber($ticketNumber);
    }
    /**
     * Get EquivalentFare value
     * @return float
     */
    public function getEquivalentFare()
    {
        return $this->EquivalentFare;
    }
    /**
     * Set EquivalentFare value
     * @param float $equivalentFare
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setEquivalentFare($equivalentFare = null)
    {
        $this->EquivalentFare = $equivalentFare;
        return $this;
    }
    /**
     * Get TotalFare value
     * @return float
     */
    public function getTotalFare()
    {
        return $this->TotalFare;
    }
    /**
     * Set TotalFare value
     * @param float $totalFare
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setTotalFare($totalFare = null)
    {
        $this->TotalFare = $totalFare;
        return $this;
    }
    /**
     * Get AgencyTitle value
     * @return string|null
     */
    public function getAgencyTitle()
    {
        return $this->AgencyTitle;
    }
    /**
     * Set AgencyTitle value
     * @param string $agencyTitle
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setAgencyTitle($agencyTitle = null)
    {
        // validation for constraint: string
        if (!is_null($agencyTitle) && !is_string($agencyTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyTitle)), __LINE__);
        }
        $this->AgencyTitle = $agencyTitle;
        return $this;
    }
    /**
     * Get AgencyAddress value
     * @return \dgsoft\StructType\DgAddressType|null
     */
    public function getAgencyAddress()
    {
        return $this->AgencyAddress;
    }
    /**
     * Set AgencyAddress value
     * @param \dgsoft\StructType\DgAddressType $agencyAddress
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setAgencyAddress(\dgsoft\StructType\DgAddressType $agencyAddress = null)
    {
        $this->AgencyAddress = $agencyAddress;
        return $this;
    }
    /**
     * Get AgencyTelNo value
     * @return string|null
     */
    public function getAgencyTelNo()
    {
        return $this->AgencyTelNo;
    }
    /**
     * Set AgencyTelNo value
     * @param string $agencyTelNo
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setAgencyTelNo($agencyTelNo = null)
    {
        // validation for constraint: string
        if (!is_null($agencyTelNo) && !is_string($agencyTelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencyTelNo)), __LINE__);
        }
        $this->AgencyTelNo = $agencyTelNo;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get IATAID value
     * @return string|null
     */
    public function getIATAID()
    {
        return $this->IATAID;
    }
    /**
     * Set IATAID value
     * @param string $iATAID
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setIATAID($iATAID = null)
    {
        // validation for constraint: string
        if (!is_null($iATAID) && !is_string($iATAID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iATAID)), __LINE__);
        }
        $this->IATAID = $iATAID;
        return $this;
    }
    /**
     * Get TicketingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketingDate()
    {
        return isset($this->TicketingDate) ? $this->TicketingDate : null;
    }
    /**
     * Set TicketingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketingDate
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setTicketingDate($ticketingDate = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingDate) && !is_string($ticketingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketingDate)), __LINE__);
        }
        if (is_null($ticketingDate) || (is_array($ticketingDate) && empty($ticketingDate))) {
            unset($this->TicketingDate);
        } else {
            $this->TicketingDate = $ticketingDate;
        }
        return $this;
    }
    /**
     * Get PassengerName_Surname value
     * @return string|null
     */
    public function getPassengerName_Surname()
    {
        return $this->PassengerName_Surname;
    }
    /**
     * Set PassengerName_Surname value
     * @param string $passengerName_Surname
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setPassengerName_Surname($passengerName_Surname = null)
    {
        // validation for constraint: string
        if (!is_null($passengerName_Surname) && !is_string($passengerName_Surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerName_Surname)), __LINE__);
        }
        $this->PassengerName_Surname = $passengerName_Surname;
        return $this;
    }
    /**
     * Get FrequentFlyer value
     * @return string|null
     */
    public function getFrequentFlyer()
    {
        return $this->FrequentFlyer;
    }
    /**
     * Set FrequentFlyer value
     * @param string $frequentFlyer
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setFrequentFlyer($frequentFlyer = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyer) && !is_string($frequentFlyer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequentFlyer)), __LINE__);
        }
        $this->FrequentFlyer = $frequentFlyer;
        return $this;
    }
    /**
     * Get IssuingAirline value
     * @return string|null
     */
    public function getIssuingAirline()
    {
        return $this->IssuingAirline;
    }
    /**
     * Set IssuingAirline value
     * @param string $issuingAirline
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setIssuingAirline($issuingAirline = null)
    {
        // validation for constraint: string
        if (!is_null($issuingAirline) && !is_string($issuingAirline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuingAirline)), __LINE__);
        }
        $this->IssuingAirline = $issuingAirline;
        return $this;
    }
    /**
     * Get BookingRef value
     * @return string|null
     */
    public function getBookingRef()
    {
        return $this->BookingRef;
    }
    /**
     * Set BookingRef value
     * @param string $bookingRef
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setBookingRef($bookingRef = null)
    {
        // validation for constraint: string
        if (!is_null($bookingRef) && !is_string($bookingRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bookingRef)), __LINE__);
        }
        $this->BookingRef = $bookingRef;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return string|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param string $fareCalculation
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setFareCalculation($fareCalculation = null)
    {
        // validation for constraint: string
        if (!is_null($fareCalculation) && !is_string($fareCalculation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fareCalculation)), __LINE__);
        }
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return string|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param string $endorsements
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setEndorsements($endorsements = null)
    {
        // validation for constraint: string
        if (!is_null($endorsements) && !is_string($endorsements)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endorsements)), __LINE__);
        }
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get PaymentType value
     * @return string|null
     */
    public function getPaymentType()
    {
        return $this->PaymentType;
    }
    /**
     * Set PaymentType value
     * @param string $paymentType
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentType)), __LINE__);
        }
        $this->PaymentType = $paymentType;
        return $this;
    }
    /**
     * Get AirFare value
     * @return float|null
     */
    public function getAirFare()
    {
        return $this->AirFare;
    }
    /**
     * Set AirFare value
     * @param float $airFare
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setAirFare($airFare = null)
    {
        $this->AirFare = $airFare;
        return $this;
    }
    /**
     * Get AirFareCurrency value
     * @return string|null
     */
    public function getAirFareCurrency()
    {
        return $this->AirFareCurrency;
    }
    /**
     * Set AirFareCurrency value
     * @param string $airFareCurrency
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setAirFareCurrency($airFareCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($airFareCurrency) && !is_string($airFareCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($airFareCurrency)), __LINE__);
        }
        $this->AirFareCurrency = $airFareCurrency;
        return $this;
    }
    /**
     * Get ServiceFee value
     * @return float|null
     */
    public function getServiceFee()
    {
        return $this->ServiceFee;
    }
    /**
     * Set ServiceFee value
     * @param float $serviceFee
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setServiceFee($serviceFee = null)
    {
        $this->ServiceFee = $serviceFee;
        return $this;
    }
    /**
     * Get EquivalentFareCurrency value
     * @return string|null
     */
    public function getEquivalentFareCurrency()
    {
        return $this->EquivalentFareCurrency;
    }
    /**
     * Set EquivalentFareCurrency value
     * @param string $equivalentFareCurrency
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setEquivalentFareCurrency($equivalentFareCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($equivalentFareCurrency) && !is_string($equivalentFareCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($equivalentFareCurrency)), __LINE__);
        }
        $this->EquivalentFareCurrency = $equivalentFareCurrency;
        return $this;
    }
    /**
     * Get TotalFareCurrency value
     * @return string|null
     */
    public function getTotalFareCurrency()
    {
        return $this->TotalFareCurrency;
    }
    /**
     * Set TotalFareCurrency value
     * @param string $totalFareCurrency
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setTotalFareCurrency($totalFareCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($totalFareCurrency) && !is_string($totalFareCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalFareCurrency)), __LINE__);
        }
        $this->TotalFareCurrency = $totalFareCurrency;
        return $this;
    }
    /**
     * Get TicketCurrency value
     * @return string|null
     */
    public function getTicketCurrency()
    {
        return $this->TicketCurrency;
    }
    /**
     * Set TicketCurrency value
     * @param string $ticketCurrency
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setTicketCurrency($ticketCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($ticketCurrency) && !is_string($ticketCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketCurrency)), __LINE__);
        }
        $this->TicketCurrency = $ticketCurrency;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \dgsoft\ArrayType\DgArrayOfTaxInfo|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \dgsoft\ArrayType\DgArrayOfTaxInfo $taxes
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setTaxes(\dgsoft\ArrayType\DgArrayOfTaxInfo $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get ControlNumbers value
     * @return string|null
     */
    public function getControlNumbers()
    {
        return $this->ControlNumbers;
    }
    /**
     * Set ControlNumbers value
     * @param string $controlNumbers
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setControlNumbers($controlNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($controlNumbers) && !is_string($controlNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlNumbers)), __LINE__);
        }
        $this->ControlNumbers = $controlNumbers;
        return $this;
    }
    /**
     * Get Itineraries value
     * @return \dgsoft\ArrayType\DgArrayOfETicketItineraryInfo|null
     */
    public function getItineraries()
    {
        return $this->Itineraries;
    }
    /**
     * Set Itineraries value
     * @param \dgsoft\ArrayType\DgArrayOfETicketItineraryInfo $itineraries
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setItineraries(\dgsoft\ArrayType\DgArrayOfETicketItineraryInfo $itineraries = null)
    {
        $this->Itineraries = $itineraries;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgETicketInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
