<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentDetails StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDocumentDetails extends DgBaseEntity
{
    /**
     * The Documents
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfDocument
     */
    public $Documents;
    /**
     * The DocumentHints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfDocumentHint
     */
    public $DocumentHints;
    /**
     * Constructor method for DocumentDetails
     * @uses DgDocumentDetails::setDocuments()
     * @uses DgDocumentDetails::setDocumentHints()
     * @param \dgsoft\ArrayType\DgArrayOfDocument $documents
     * @param \dgsoft\ArrayType\DgArrayOfDocumentHint $documentHints
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfDocument $documents = null, \dgsoft\ArrayType\DgArrayOfDocumentHint $documentHints = null)
    {
        $this
            ->setDocuments($documents)
            ->setDocumentHints($documentHints);
    }
    /**
     * Get Documents value
     * @return \dgsoft\ArrayType\DgArrayOfDocument|null
     */
    public function getDocuments()
    {
        return $this->Documents;
    }
    /**
     * Set Documents value
     * @param \dgsoft\ArrayType\DgArrayOfDocument $documents
     * @return \dgsoft\StructType\DgDocumentDetails
     */
    public function setDocuments(\dgsoft\ArrayType\DgArrayOfDocument $documents = null)
    {
        $this->Documents = $documents;
        return $this;
    }
    /**
     * Get DocumentHints value
     * @return \dgsoft\ArrayType\DgArrayOfDocumentHint|null
     */
    public function getDocumentHints()
    {
        return $this->DocumentHints;
    }
    /**
     * Set DocumentHints value
     * @param \dgsoft\ArrayType\DgArrayOfDocumentHint $documentHints
     * @return \dgsoft\StructType\DgDocumentDetails
     */
    public function setDocumentHints(\dgsoft\ArrayType\DgArrayOfDocumentHint $documentHints = null)
    {
        $this->DocumentHints = $documentHints;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDocumentDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
