<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDocument extends DgDBBaseEntity
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $EntityID;
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $IssueDate;
    /**
     * The ExpireDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $ExpireDate;
    /**
     * The LineNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineNumber;
    /**
     * The PassengerOrderId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PassengerOrderId;
    /**
     * The Operation
     * @var string
     */
    public $Operation;
    /**
     * The DocumentTypeMandatory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypeMandatory;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The DocumentTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentTypes;
    /**
     * The Nationality
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nationality;
    /**
     * The TypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeCode;
    /**
     * The Issuer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Issuer;
    /**
     * The IssuerTypeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssuerTypeCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The CityCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityCode;
    /**
     * The IssueLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueLocation;
    /**
     * The PlaceOfBirth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PlaceOfBirth;
    /**
     * The PassengerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PassengerType;
    /**
     * The AddressType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressType;
    /**
     * The AddressDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AddressDetails;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The ZipPostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipPostalCode;
    /**
     * The CompanyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyCode;
    /**
     * Constructor method for Document
     * @uses DgDocument::setEntityID()
     * @uses DgDocument::setIssueDate()
     * @uses DgDocument::setExpireDate()
     * @uses DgDocument::setLineNumber()
     * @uses DgDocument::setPassengerOrderId()
     * @uses DgDocument::setOperation()
     * @uses DgDocument::setDocumentTypeMandatory()
     * @uses DgDocument::setNumber()
     * @uses DgDocument::setDocumentTypes()
     * @uses DgDocument::setNationality()
     * @uses DgDocument::setTypeCode()
     * @uses DgDocument::setIssuer()
     * @uses DgDocument::setIssuerTypeCode()
     * @uses DgDocument::setCountryCode()
     * @uses DgDocument::setCityCode()
     * @uses DgDocument::setIssueLocation()
     * @uses DgDocument::setPlaceOfBirth()
     * @uses DgDocument::setPassengerType()
     * @uses DgDocument::setAddressType()
     * @uses DgDocument::setAddressDetails()
     * @uses DgDocument::setState()
     * @uses DgDocument::setZipPostalCode()
     * @uses DgDocument::setCompanyCode()
     * @param string $entityID
     * @param string $issueDate
     * @param string $expireDate
     * @param int $lineNumber
     * @param int $passengerOrderId
     * @param string $operation
     * @param string $documentTypeMandatory
     * @param string $number
     * @param string $documentTypes
     * @param string $nationality
     * @param string $typeCode
     * @param string $issuer
     * @param string $issuerTypeCode
     * @param string $countryCode
     * @param string $cityCode
     * @param string $issueLocation
     * @param string $placeOfBirth
     * @param string $passengerType
     * @param string $addressType
     * @param string $addressDetails
     * @param string $state
     * @param string $zipPostalCode
     * @param string $companyCode
     */
    public function __construct($entityID = null, $issueDate = null, $expireDate = null, $lineNumber = null, $passengerOrderId = null, $operation = null, $documentTypeMandatory = null, $number = null, $documentTypes = null, $nationality = null, $typeCode = null, $issuer = null, $issuerTypeCode = null, $countryCode = null, $cityCode = null, $issueLocation = null, $placeOfBirth = null, $passengerType = null, $addressType = null, $addressDetails = null, $state = null, $zipPostalCode = null, $companyCode = null)
    {
        $this
            ->setEntityID($entityID)
            ->setIssueDate($issueDate)
            ->setExpireDate($expireDate)
            ->setLineNumber($lineNumber)
            ->setPassengerOrderId($passengerOrderId)
            ->setOperation($operation)
            ->setDocumentTypeMandatory($documentTypeMandatory)
            ->setNumber($number)
            ->setDocumentTypes($documentTypes)
            ->setNationality($nationality)
            ->setTypeCode($typeCode)
            ->setIssuer($issuer)
            ->setIssuerTypeCode($issuerTypeCode)
            ->setCountryCode($countryCode)
            ->setCityCode($cityCode)
            ->setIssueLocation($issueLocation)
            ->setPlaceOfBirth($placeOfBirth)
            ->setPassengerType($passengerType)
            ->setAddressType($addressType)
            ->setAddressDetails($addressDetails)
            ->setState($state)
            ->setZipPostalCode($zipPostalCode)
            ->setCompanyCode($companyCode);
    }
    /**
     * Get EntityID value
     * @return string
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param string $entityID
     * @return \dgsoft\StructType\DgDocument
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($entityID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}", "%s" given', var_export($entityID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($entityID) && !is_string($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \dgsoft\StructType\DgDocument
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgDocument
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get LineNumber value
     * @return int
     */
    public function getLineNumber()
    {
        return $this->LineNumber;
    }
    /**
     * Set LineNumber value
     * @param int $lineNumber
     * @return \dgsoft\StructType\DgDocument
     */
    public function setLineNumber($lineNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lineNumber) && !is_numeric($lineNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineNumber)), __LINE__);
        }
        $this->LineNumber = $lineNumber;
        return $this;
    }
    /**
     * Get PassengerOrderId value
     * @return int
     */
    public function getPassengerOrderId()
    {
        return $this->PassengerOrderId;
    }
    /**
     * Set PassengerOrderId value
     * @param int $passengerOrderId
     * @return \dgsoft\StructType\DgDocument
     */
    public function setPassengerOrderId($passengerOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($passengerOrderId) && !is_numeric($passengerOrderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($passengerOrderId)), __LINE__);
        }
        $this->PassengerOrderId = $passengerOrderId;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \dgsoft\EnumType\DgActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \dgsoft\StructType\DgDocument
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operation, implode(', ', \dgsoft\EnumType\DgActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get DocumentTypeMandatory value
     * @return string|null
     */
    public function getDocumentTypeMandatory()
    {
        return $this->DocumentTypeMandatory;
    }
    /**
     * Set DocumentTypeMandatory value
     * @param string $documentTypeMandatory
     * @return \dgsoft\StructType\DgDocument
     */
    public function setDocumentTypeMandatory($documentTypeMandatory = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeMandatory) && !is_string($documentTypeMandatory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTypeMandatory)), __LINE__);
        }
        $this->DocumentTypeMandatory = $documentTypeMandatory;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \dgsoft\StructType\DgDocument
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get DocumentTypes value
     * @return string|null
     */
    public function getDocumentTypes()
    {
        return $this->DocumentTypes;
    }
    /**
     * Set DocumentTypes value
     * @param string $documentTypes
     * @return \dgsoft\StructType\DgDocument
     */
    public function setDocumentTypes($documentTypes = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypes) && !is_string($documentTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTypes)), __LINE__);
        }
        $this->DocumentTypes = $documentTypes;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \dgsoft\StructType\DgDocument
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \dgsoft\StructType\DgDocument
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get Issuer value
     * @return string|null
     */
    public function getIssuer()
    {
        return $this->Issuer;
    }
    /**
     * Set Issuer value
     * @param string $issuer
     * @return \dgsoft\StructType\DgDocument
     */
    public function setIssuer($issuer = null)
    {
        // validation for constraint: string
        if (!is_null($issuer) && !is_string($issuer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuer)), __LINE__);
        }
        $this->Issuer = $issuer;
        return $this;
    }
    /**
     * Get IssuerTypeCode value
     * @return string|null
     */
    public function getIssuerTypeCode()
    {
        return $this->IssuerTypeCode;
    }
    /**
     * Set IssuerTypeCode value
     * @param string $issuerTypeCode
     * @return \dgsoft\StructType\DgDocument
     */
    public function setIssuerTypeCode($issuerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuerTypeCode) && !is_string($issuerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerTypeCode)), __LINE__);
        }
        $this->IssuerTypeCode = $issuerTypeCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \dgsoft\StructType\DgDocument
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get CityCode value
     * @return string|null
     */
    public function getCityCode()
    {
        return $this->CityCode;
    }
    /**
     * Set CityCode value
     * @param string $cityCode
     * @return \dgsoft\StructType\DgDocument
     */
    public function setCityCode($cityCode = null)
    {
        // validation for constraint: string
        if (!is_null($cityCode) && !is_string($cityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cityCode)), __LINE__);
        }
        $this->CityCode = $cityCode;
        return $this;
    }
    /**
     * Get IssueLocation value
     * @return string|null
     */
    public function getIssueLocation()
    {
        return $this->IssueLocation;
    }
    /**
     * Set IssueLocation value
     * @param string $issueLocation
     * @return \dgsoft\StructType\DgDocument
     */
    public function setIssueLocation($issueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($issueLocation) && !is_string($issueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueLocation)), __LINE__);
        }
        $this->IssueLocation = $issueLocation;
        return $this;
    }
    /**
     * Get PlaceOfBirth value
     * @return string|null
     */
    public function getPlaceOfBirth()
    {
        return $this->PlaceOfBirth;
    }
    /**
     * Set PlaceOfBirth value
     * @param string $placeOfBirth
     * @return \dgsoft\StructType\DgDocument
     */
    public function setPlaceOfBirth($placeOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($placeOfBirth) && !is_string($placeOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($placeOfBirth)), __LINE__);
        }
        $this->PlaceOfBirth = $placeOfBirth;
        return $this;
    }
    /**
     * Get PassengerType value
     * @return string|null
     */
    public function getPassengerType()
    {
        return $this->PassengerType;
    }
    /**
     * Set PassengerType value
     * @param string $passengerType
     * @return \dgsoft\StructType\DgDocument
     */
    public function setPassengerType($passengerType = null)
    {
        // validation for constraint: string
        if (!is_null($passengerType) && !is_string($passengerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($passengerType)), __LINE__);
        }
        $this->PassengerType = $passengerType;
        return $this;
    }
    /**
     * Get AddressType value
     * @return string|null
     */
    public function getAddressType()
    {
        return $this->AddressType;
    }
    /**
     * Set AddressType value
     * @param string $addressType
     * @return \dgsoft\StructType\DgDocument
     */
    public function setAddressType($addressType = null)
    {
        // validation for constraint: string
        if (!is_null($addressType) && !is_string($addressType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressType)), __LINE__);
        }
        $this->AddressType = $addressType;
        return $this;
    }
    /**
     * Get AddressDetails value
     * @return string|null
     */
    public function getAddressDetails()
    {
        return $this->AddressDetails;
    }
    /**
     * Set AddressDetails value
     * @param string $addressDetails
     * @return \dgsoft\StructType\DgDocument
     */
    public function setAddressDetails($addressDetails = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetails) && !is_string($addressDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addressDetails)), __LINE__);
        }
        $this->AddressDetails = $addressDetails;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \dgsoft\StructType\DgDocument
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get ZipPostalCode value
     * @return string|null
     */
    public function getZipPostalCode()
    {
        return $this->ZipPostalCode;
    }
    /**
     * Set ZipPostalCode value
     * @param string $zipPostalCode
     * @return \dgsoft\StructType\DgDocument
     */
    public function setZipPostalCode($zipPostalCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipPostalCode) && !is_string($zipPostalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipPostalCode)), __LINE__);
        }
        $this->ZipPostalCode = $zipPostalCode;
        return $this;
    }
    /**
     * Get CompanyCode value
     * @return string|null
     */
    public function getCompanyCode()
    {
        return $this->CompanyCode;
    }
    /**
     * Set CompanyCode value
     * @param string $companyCode
     * @return \dgsoft\StructType\DgDocument
     */
    public function setCompanyCode($companyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCode) && !is_string($companyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyCode)), __LINE__);
        }
        $this->CompanyCode = $companyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
