<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountPricing StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDiscountPricing extends AbstractStructBase
{
    /**
     * The Purpose
     * @var string
     */
    public $Purpose;
    /**
     * The TicketDesignatorCode
     * @var string
     */
    public $TicketDesignatorCode;
    /**
     * The Discount
     * @var string
     */
    public $Discount;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The Usage
     * @var string
     */
    public $Usage;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * Constructor method for DiscountPricing
     * @uses DgDiscountPricing::setPurpose()
     * @uses DgDiscountPricing::setTicketDesignatorCode()
     * @uses DgDiscountPricing::setDiscount()
     * @uses DgDiscountPricing::setType()
     * @uses DgDiscountPricing::setUsage()
     * @uses DgDiscountPricing::setText()
     * @param string $purpose
     * @param string $ticketDesignatorCode
     * @param string $discount
     * @param string $type
     * @param string $usage
     * @param string $text
     */
    public function __construct($purpose = null, $ticketDesignatorCode = null, $discount = null, $type = null, $usage = null, $text = null)
    {
        $this
            ->setPurpose($purpose)
            ->setTicketDesignatorCode($ticketDesignatorCode)
            ->setDiscount($discount)
            ->setType($type)
            ->setUsage($usage)
            ->setText($text);
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @param string $purpose
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: string
        if (!is_null($purpose) && !is_string($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($purpose)), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get TicketDesignatorCode value
     * @return string|null
     */
    public function getTicketDesignatorCode()
    {
        return $this->TicketDesignatorCode;
    }
    /**
     * Set TicketDesignatorCode value
     * @param string $ticketDesignatorCode
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public function setTicketDesignatorCode($ticketDesignatorCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignatorCode) && !is_string($ticketDesignatorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDesignatorCode)), __LINE__);
        }
        $this->TicketDesignatorCode = $ticketDesignatorCode;
        return $this;
    }
    /**
     * Get Discount value
     * @return string|null
     */
    public function getDiscount()
    {
        return $this->Discount;
    }
    /**
     * Set Discount value
     * @param string $discount
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: string
        if (!is_null($discount) && !is_string($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($discount)), __LINE__);
        }
        $this->Discount = $discount;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Usage value
     * @return string|null
     */
    public function getUsage()
    {
        return $this->Usage;
    }
    /**
     * Set Usage value
     * @param string $usage
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: string
        if (!is_null($usage) && !is_string($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($usage)), __LINE__);
        }
        $this->Usage = $usage;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDiscountPricing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
