<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepartureAirport StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDepartureAirport extends AbstractStructBase
{
    /**
     * The LocationCode
     * @var string
     */
    public $LocationCode;
    /**
     * The CodeContext
     * Meta informations extracted from the WSDL
     * - default: IATA
     * @var string
     */
    public $CodeContext;
    /**
     * The Terminal
     * @var string
     */
    public $Terminal;
    /**
     * The Gate
     * @var string
     */
    public $Gate;
    /**
     * Constructor method for DepartureAirport
     * @uses DgDepartureAirport::setLocationCode()
     * @uses DgDepartureAirport::setCodeContext()
     * @uses DgDepartureAirport::setTerminal()
     * @uses DgDepartureAirport::setGate()
     * @param string $locationCode
     * @param string $codeContext
     * @param string $terminal
     * @param string $gate
     */
    public function __construct($locationCode = null, $codeContext = 'IATA', $terminal = null, $gate = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setCodeContext($codeContext)
            ->setTerminal($terminal)
            ->setGate($gate);
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \dgsoft\StructType\DgDepartureAirport
     */
    public function setLocationCode($locationCode = null)
    {
        // validation for constraint: string
        if (!is_null($locationCode) && !is_string($locationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationCode)), __LINE__);
        }
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \dgsoft\StructType\DgDepartureAirport
     */
    public function setCodeContext($codeContext = 'IATA')
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \dgsoft\StructType\DgDepartureAirport
     */
    public function setTerminal($terminal = null)
    {
        // validation for constraint: string
        if (!is_null($terminal) && !is_string($terminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminal)), __LINE__);
        }
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get Gate value
     * @return string|null
     */
    public function getGate()
    {
        return $this->Gate;
    }
    /**
     * Set Gate value
     * @param string $gate
     * @return \dgsoft\StructType\DgDepartureAirport
     */
    public function setGate($gate = null)
    {
        // validation for constraint: string
        if (!is_null($gate) && !is_string($gate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gate)), __LINE__);
        }
        $this->Gate = $gate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDepartureAirport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
