<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DBBaseEntity StructType
 * @package Dg
 * @subpackage Structs
 */
class DgDBBaseEntity extends DgGenericItem
{
    /**
     * The UpdatedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $UpdatedDate;
    /**
     * The InsertedDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $InsertedDate;
    /**
     * The UpdatedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpdatedBy;
    /**
     * The InsertedBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InsertedBy;
    /**
     * Constructor method for DBBaseEntity
     * @uses DgDBBaseEntity::setUpdatedDate()
     * @uses DgDBBaseEntity::setInsertedDate()
     * @uses DgDBBaseEntity::setUpdatedBy()
     * @uses DgDBBaseEntity::setInsertedBy()
     * @param string $updatedDate
     * @param string $insertedDate
     * @param string $updatedBy
     * @param string $insertedBy
     */
    public function __construct($updatedDate = null, $insertedDate = null, $updatedBy = null, $insertedBy = null)
    {
        $this
            ->setUpdatedDate($updatedDate)
            ->setInsertedDate($insertedDate)
            ->setUpdatedBy($updatedBy)
            ->setInsertedBy($insertedBy);
    }
    /**
     * Get UpdatedDate value
     * @return string
     */
    public function getUpdatedDate()
    {
        return $this->UpdatedDate;
    }
    /**
     * Set UpdatedDate value
     * @param string $updatedDate
     * @return \dgsoft\StructType\DgDBBaseEntity
     */
    public function setUpdatedDate($updatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($updatedDate) && !is_string($updatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updatedDate)), __LINE__);
        }
        $this->UpdatedDate = $updatedDate;
        return $this;
    }
    /**
     * Get InsertedDate value
     * @return string
     */
    public function getInsertedDate()
    {
        return $this->InsertedDate;
    }
    /**
     * Set InsertedDate value
     * @param string $insertedDate
     * @return \dgsoft\StructType\DgDBBaseEntity
     */
    public function setInsertedDate($insertedDate = null)
    {
        // validation for constraint: string
        if (!is_null($insertedDate) && !is_string($insertedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insertedDate)), __LINE__);
        }
        $this->InsertedDate = $insertedDate;
        return $this;
    }
    /**
     * Get UpdatedBy value
     * @return string|null
     */
    public function getUpdatedBy()
    {
        return $this->UpdatedBy;
    }
    /**
     * Set UpdatedBy value
     * @param string $updatedBy
     * @return \dgsoft\StructType\DgDBBaseEntity
     */
    public function setUpdatedBy($updatedBy = null)
    {
        // validation for constraint: string
        if (!is_null($updatedBy) && !is_string($updatedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updatedBy)), __LINE__);
        }
        $this->UpdatedBy = $updatedBy;
        return $this;
    }
    /**
     * Get InsertedBy value
     * @return string|null
     */
    public function getInsertedBy()
    {
        return $this->InsertedBy;
    }
    /**
     * Set InsertedBy value
     * @param string $insertedBy
     * @return \dgsoft\StructType\DgDBBaseEntity
     */
    public function setInsertedBy($insertedBy = null)
    {
        // validation for constraint: string
        if (!is_null($insertedBy) && !is_string($insertedBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($insertedBy)), __LINE__);
        }
        $this->InsertedBy = $insertedBy;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgDBBaseEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
