<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPrimaryAdditionalTypeAdditional StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCustomerPrimaryAdditionalTypeAdditional extends DgCustomerType
{
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The CorpDiscountName
     * @var string
     */
    public $CorpDiscountName;
    /**
     * The CorpDiscountNmbr
     * @var string
     */
    public $CorpDiscountNmbr;
    /**
     * The QualificationMethod
     * @var string
     */
    public $QualificationMethod;
    /**
     * The Age
     * @var int
     */
    public $Age;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The CodeContext
     * @var string
     */
    public $CodeContext;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * Constructor method for CustomerPrimaryAdditionalTypeAdditional
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setStart()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setDuration()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setEnd()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setCorpDiscountName()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setCorpDiscountNmbr()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setQualificationMethod()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setAge()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setCode()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setCodeContext()
     * @uses DgCustomerPrimaryAdditionalTypeAdditional::setURI()
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $corpDiscountName
     * @param string $corpDiscountNmbr
     * @param string $qualificationMethod
     * @param int $age
     * @param string $code
     * @param string $codeContext
     * @param string $uRI
     */
    public function __construct($start = null, $duration = null, $end = null, $corpDiscountName = null, $corpDiscountNmbr = null, $qualificationMethod = null, $age = null, $code = null, $codeContext = null, $uRI = null)
    {
        $this
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setCorpDiscountName($corpDiscountName)
            ->setCorpDiscountNmbr($corpDiscountNmbr)
            ->setQualificationMethod($qualificationMethod)
            ->setAge($age)
            ->setCode($code)
            ->setCodeContext($codeContext)
            ->setURI($uRI);
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get CorpDiscountName value
     * @return string|null
     */
    public function getCorpDiscountName()
    {
        return $this->CorpDiscountName;
    }
    /**
     * Set CorpDiscountName value
     * @param string $corpDiscountName
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setCorpDiscountName($corpDiscountName = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountName) && !is_string($corpDiscountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corpDiscountName)), __LINE__);
        }
        $this->CorpDiscountName = $corpDiscountName;
        return $this;
    }
    /**
     * Get CorpDiscountNmbr value
     * @return string|null
     */
    public function getCorpDiscountNmbr()
    {
        return $this->CorpDiscountNmbr;
    }
    /**
     * Set CorpDiscountNmbr value
     * @param string $corpDiscountNmbr
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setCorpDiscountNmbr($corpDiscountNmbr = null)
    {
        // validation for constraint: string
        if (!is_null($corpDiscountNmbr) && !is_string($corpDiscountNmbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corpDiscountNmbr)), __LINE__);
        }
        $this->CorpDiscountNmbr = $corpDiscountNmbr;
        return $this;
    }
    /**
     * Get QualificationMethod value
     * @return string|null
     */
    public function getQualificationMethod()
    {
        return $this->QualificationMethod;
    }
    /**
     * Set QualificationMethod value
     * @uses \dgsoft\EnumType\DgCustomerPrimaryAdditionalTypeAdditionalQualificationMethod::valueIsValid()
     * @uses \dgsoft\EnumType\DgCustomerPrimaryAdditionalTypeAdditionalQualificationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $qualificationMethod
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setQualificationMethod($qualificationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCustomerPrimaryAdditionalTypeAdditionalQualificationMethod::valueIsValid($qualificationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $qualificationMethod, implode(', ', \dgsoft\EnumType\DgCustomerPrimaryAdditionalTypeAdditionalQualificationMethod::getValidValues())), __LINE__);
        }
        $this->QualificationMethod = $qualificationMethod;
        return $this;
    }
    /**
     * Get Age value
     * @return int|null
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !is_numeric($age)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get CodeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->CodeContext;
    }
    /**
     * Set CodeContext value
     * @param string $codeContext
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setCodeContext($codeContext = null)
    {
        // validation for constraint: string
        if (!is_null($codeContext) && !is_string($codeContext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeContext)), __LINE__);
        }
        $this->CodeContext = $codeContext;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
