<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerPrimaryAdditionalType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCustomerPrimaryAdditionalType extends AbstractStructBase
{
    /**
     * The Primary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustomerPrimaryAdditionalTypePrimary
     */
    public $Primary;
    /**
     * The Additional
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional[]
     */
    public $Additional;
    /**
     * Constructor method for CustomerPrimaryAdditionalType
     * @uses DgCustomerPrimaryAdditionalType::setPrimary()
     * @uses DgCustomerPrimaryAdditionalType::setAdditional()
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalTypePrimary $primary
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional[] $additional
     */
    public function __construct(\dgsoft\StructType\DgCustomerPrimaryAdditionalTypePrimary $primary = null, array $additional = array())
    {
        $this
            ->setPrimary($primary)
            ->setAdditional($additional);
    }
    /**
     * Get Primary value
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypePrimary|null
     */
    public function getPrimary()
    {
        return $this->Primary;
    }
    /**
     * Set Primary value
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalTypePrimary $primary
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public function setPrimary(\dgsoft\StructType\DgCustomerPrimaryAdditionalTypePrimary $primary = null)
    {
        $this->Primary = $primary;
        return $this;
    }
    /**
     * Get Additional value
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional[]|null
     */
    public function getAdditional()
    {
        return $this->Additional;
    }
    /**
     * Set Additional value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional[] $additional
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public function setAdditional(array $additional = array())
    {
        foreach ($additional as $customerPrimaryAdditionalTypeAdditionalItem) {
            // validation for constraint: itemType
            if (!$customerPrimaryAdditionalTypeAdditionalItem instanceof \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional) {
                throw new \InvalidArgumentException(sprintf('The Additional property can only contain items of \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional, "%s" given', is_object($customerPrimaryAdditionalTypeAdditionalItem) ? get_class($customerPrimaryAdditionalTypeAdditionalItem) : gettype($customerPrimaryAdditionalTypeAdditionalItem)), __LINE__);
            }
        }
        $this->Additional = $additional;
        return $this;
    }
    /**
     * Add item to Additional value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional $item
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public function addToAdditional(\dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional) {
            throw new \InvalidArgumentException(sprintf('The Additional property can only contain items of \dgsoft\StructType\DgCustomerPrimaryAdditionalTypeAdditional, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Additional[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCustomerPrimaryAdditionalType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
