<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustLoyalty StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCustLoyalty extends AbstractStructBase
{
    /**
     * The ProgramID
     * @var string
     */
    public $ProgramID;
    /**
     * The MembershipID
     * @var string
     */
    public $MembershipID;
    /**
     * The TravelSector
     * @var string
     */
    public $TravelSector;
    /**
     * The RPH
     * @var string
     */
    public $RPH;
    /**
     * The VendorCode
     * @var string[]
     */
    public $VendorCode;
    /**
     * The Operation
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for CustLoyalty
     * @uses DgCustLoyalty::setProgramID()
     * @uses DgCustLoyalty::setMembershipID()
     * @uses DgCustLoyalty::setTravelSector()
     * @uses DgCustLoyalty::setRPH()
     * @uses DgCustLoyalty::setVendorCode()
     * @uses DgCustLoyalty::setOperation()
     * @param string $programID
     * @param string $membershipID
     * @param string $travelSector
     * @param string $rPH
     * @param string[] $vendorCode
     * @param string $operation
     */
    public function __construct($programID = null, $membershipID = null, $travelSector = null, $rPH = null, array $vendorCode = array(), $operation = null)
    {
        $this
            ->setProgramID($programID)
            ->setMembershipID($membershipID)
            ->setTravelSector($travelSector)
            ->setRPH($rPH)
            ->setVendorCode($vendorCode)
            ->setOperation($operation);
    }
    /**
     * Get ProgramID value
     * @return string|null
     */
    public function getProgramID()
    {
        return $this->ProgramID;
    }
    /**
     * Set ProgramID value
     * @param string $programID
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function setProgramID($programID = null)
    {
        // validation for constraint: string
        if (!is_null($programID) && !is_string($programID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($programID)), __LINE__);
        }
        $this->ProgramID = $programID;
        return $this;
    }
    /**
     * Get MembershipID value
     * @return string|null
     */
    public function getMembershipID()
    {
        return $this->MembershipID;
    }
    /**
     * Set MembershipID value
     * @param string $membershipID
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function setMembershipID($membershipID = null)
    {
        // validation for constraint: string
        if (!is_null($membershipID) && !is_string($membershipID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($membershipID)), __LINE__);
        }
        $this->MembershipID = $membershipID;
        return $this;
    }
    /**
     * Get TravelSector value
     * @return string|null
     */
    public function getTravelSector()
    {
        return $this->TravelSector;
    }
    /**
     * Set TravelSector value
     * @param string $travelSector
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function setTravelSector($travelSector = null)
    {
        // validation for constraint: string
        if (!is_null($travelSector) && !is_string($travelSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($travelSector)), __LINE__);
        }
        $this->TravelSector = $travelSector;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get VendorCode value
     * @return string[]|null
     */
    public function getVendorCode()
    {
        return $this->VendorCode;
    }
    /**
     * Set VendorCode value
     * @throws \InvalidArgumentException
     * @param string[] $vendorCode
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function setVendorCode(array $vendorCode = array())
    {
        foreach ($vendorCode as $custLoyaltyVendorCodeItem) {
            // validation for constraint: itemType
            if (!is_string($custLoyaltyVendorCodeItem)) {
                throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($custLoyaltyVendorCodeItem) ? get_class($custLoyaltyVendorCodeItem) : gettype($custLoyaltyVendorCodeItem)), __LINE__);
            }
        }
        $this->VendorCode = $vendorCode;
        return $this;
    }
    /**
     * Add item to VendorCode value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function addToVendorCode($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The VendorCode property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VendorCode[] = $item;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \dgsoft\EnumType\DgActionType::valueIsValid()
     * @uses \dgsoft\EnumType\DgActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operation, implode(', ', \dgsoft\EnumType\DgActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCustLoyalty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
