<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CruiseReadRequest StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCruiseReadRequest extends AbstractStructBase
{
    /**
     * The SelectedSailing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSelectedSailing
     */
    public $SelectedSailing;
    /**
     * The GuestInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $GuestInfo;
    /**
     * The HistoryRequestedInd
     * @var bool
     */
    public $HistoryRequestedInd;
    /**
     * Constructor method for CruiseReadRequest
     * @uses DgCruiseReadRequest::setSelectedSailing()
     * @uses DgCruiseReadRequest::setGuestInfo()
     * @uses DgCruiseReadRequest::setHistoryRequestedInd()
     * @param \dgsoft\StructType\DgSelectedSailing $selectedSailing
     * @param \dgsoft\StructType\DgPersonNameType $guestInfo
     * @param bool $historyRequestedInd
     */
    public function __construct(\dgsoft\StructType\DgSelectedSailing $selectedSailing = null, \dgsoft\StructType\DgPersonNameType $guestInfo = null, $historyRequestedInd = null)
    {
        $this
            ->setSelectedSailing($selectedSailing)
            ->setGuestInfo($guestInfo)
            ->setHistoryRequestedInd($historyRequestedInd);
    }
    /**
     * Get SelectedSailing value
     * @return \dgsoft\StructType\DgSelectedSailing|null
     */
    public function getSelectedSailing()
    {
        return $this->SelectedSailing;
    }
    /**
     * Set SelectedSailing value
     * @param \dgsoft\StructType\DgSelectedSailing $selectedSailing
     * @return \dgsoft\StructType\DgCruiseReadRequest
     */
    public function setSelectedSailing(\dgsoft\StructType\DgSelectedSailing $selectedSailing = null)
    {
        $this->SelectedSailing = $selectedSailing;
        return $this;
    }
    /**
     * Get GuestInfo value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getGuestInfo()
    {
        return $this->GuestInfo;
    }
    /**
     * Set GuestInfo value
     * @param \dgsoft\StructType\DgPersonNameType $guestInfo
     * @return \dgsoft\StructType\DgCruiseReadRequest
     */
    public function setGuestInfo(\dgsoft\StructType\DgPersonNameType $guestInfo = null)
    {
        $this->GuestInfo = $guestInfo;
        return $this;
    }
    /**
     * Get HistoryRequestedInd value
     * @return bool|null
     */
    public function getHistoryRequestedInd()
    {
        return $this->HistoryRequestedInd;
    }
    /**
     * Set HistoryRequestedInd value
     * @param bool $historyRequestedInd
     * @return \dgsoft\StructType\DgCruiseReadRequest
     */
    public function setHistoryRequestedInd($historyRequestedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($historyRequestedInd) && !is_bool($historyRequestedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($historyRequestedInd)), __LINE__);
        }
        $this->HistoryRequestedInd = $historyRequestedInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCruiseReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
