<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CoverageLimitType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCoverageLimitType extends AbstractStructBase
{
    /**
     * The Deductible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoverageLimitTypeDeductible
     */
    public $Deductible;
    /**
     * The PolicyLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoverageLimitTypePolicyLimit
     */
    public $PolicyLimit;
    /**
     * The IndividualLimit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCoverageLimitTypeIndividualLimit
     */
    public $IndividualLimit;
    /**
     * The CoverageLevel
     * @var string
     */
    public $CoverageLevel;
    /**
     * The CoverageType
     * @var string
     */
    public $CoverageType;
    /**
     * The UnlimitedCoverage
     * @var bool
     */
    public $UnlimitedCoverage;
    /**
     * The Covered
     * @var bool
     */
    public $Covered;
    /**
     * The EffectiveDate
     * @var string
     */
    public $EffectiveDate;
    /**
     * The ExpireDate
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for CoverageLimitType
     * @uses DgCoverageLimitType::setDeductible()
     * @uses DgCoverageLimitType::setPolicyLimit()
     * @uses DgCoverageLimitType::setIndividualLimit()
     * @uses DgCoverageLimitType::setCoverageLevel()
     * @uses DgCoverageLimitType::setCoverageType()
     * @uses DgCoverageLimitType::setUnlimitedCoverage()
     * @uses DgCoverageLimitType::setCovered()
     * @uses DgCoverageLimitType::setEffectiveDate()
     * @uses DgCoverageLimitType::setExpireDate()
     * @param \dgsoft\StructType\DgCoverageLimitTypeDeductible $deductible
     * @param \dgsoft\StructType\DgCoverageLimitTypePolicyLimit $policyLimit
     * @param \dgsoft\StructType\DgCoverageLimitTypeIndividualLimit $individualLimit
     * @param string $coverageLevel
     * @param string $coverageType
     * @param bool $unlimitedCoverage
     * @param bool $covered
     * @param string $effectiveDate
     * @param string $expireDate
     */
    public function __construct(\dgsoft\StructType\DgCoverageLimitTypeDeductible $deductible = null, \dgsoft\StructType\DgCoverageLimitTypePolicyLimit $policyLimit = null, \dgsoft\StructType\DgCoverageLimitTypeIndividualLimit $individualLimit = null, $coverageLevel = null, $coverageType = null, $unlimitedCoverage = null, $covered = null, $effectiveDate = null, $expireDate = null)
    {
        $this
            ->setDeductible($deductible)
            ->setPolicyLimit($policyLimit)
            ->setIndividualLimit($individualLimit)
            ->setCoverageLevel($coverageLevel)
            ->setCoverageType($coverageType)
            ->setUnlimitedCoverage($unlimitedCoverage)
            ->setCovered($covered)
            ->setEffectiveDate($effectiveDate)
            ->setExpireDate($expireDate);
    }
    /**
     * Get Deductible value
     * @return \dgsoft\StructType\DgCoverageLimitTypeDeductible|null
     */
    public function getDeductible()
    {
        return $this->Deductible;
    }
    /**
     * Set Deductible value
     * @param \dgsoft\StructType\DgCoverageLimitTypeDeductible $deductible
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setDeductible(\dgsoft\StructType\DgCoverageLimitTypeDeductible $deductible = null)
    {
        $this->Deductible = $deductible;
        return $this;
    }
    /**
     * Get PolicyLimit value
     * @return \dgsoft\StructType\DgCoverageLimitTypePolicyLimit|null
     */
    public function getPolicyLimit()
    {
        return $this->PolicyLimit;
    }
    /**
     * Set PolicyLimit value
     * @param \dgsoft\StructType\DgCoverageLimitTypePolicyLimit $policyLimit
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setPolicyLimit(\dgsoft\StructType\DgCoverageLimitTypePolicyLimit $policyLimit = null)
    {
        $this->PolicyLimit = $policyLimit;
        return $this;
    }
    /**
     * Get IndividualLimit value
     * @return \dgsoft\StructType\DgCoverageLimitTypeIndividualLimit|null
     */
    public function getIndividualLimit()
    {
        return $this->IndividualLimit;
    }
    /**
     * Set IndividualLimit value
     * @param \dgsoft\StructType\DgCoverageLimitTypeIndividualLimit $individualLimit
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setIndividualLimit(\dgsoft\StructType\DgCoverageLimitTypeIndividualLimit $individualLimit = null)
    {
        $this->IndividualLimit = $individualLimit;
        return $this;
    }
    /**
     * Get CoverageLevel value
     * @return string|null
     */
    public function getCoverageLevel()
    {
        return $this->CoverageLevel;
    }
    /**
     * Set CoverageLevel value
     * @param string $coverageLevel
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setCoverageLevel($coverageLevel = null)
    {
        // validation for constraint: string
        if (!is_null($coverageLevel) && !is_string($coverageLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coverageLevel)), __LINE__);
        }
        $this->CoverageLevel = $coverageLevel;
        return $this;
    }
    /**
     * Get CoverageType value
     * @return string|null
     */
    public function getCoverageType()
    {
        return $this->CoverageType;
    }
    /**
     * Set CoverageType value
     * @param string $coverageType
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setCoverageType($coverageType = null)
    {
        // validation for constraint: string
        if (!is_null($coverageType) && !is_string($coverageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coverageType)), __LINE__);
        }
        $this->CoverageType = $coverageType;
        return $this;
    }
    /**
     * Get UnlimitedCoverage value
     * @return bool|null
     */
    public function getUnlimitedCoverage()
    {
        return $this->UnlimitedCoverage;
    }
    /**
     * Set UnlimitedCoverage value
     * @param bool $unlimitedCoverage
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setUnlimitedCoverage($unlimitedCoverage = null)
    {
        // validation for constraint: boolean
        if (!is_null($unlimitedCoverage) && !is_bool($unlimitedCoverage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($unlimitedCoverage)), __LINE__);
        }
        $this->UnlimitedCoverage = $unlimitedCoverage;
        return $this;
    }
    /**
     * Get Covered value
     * @return bool|null
     */
    public function getCovered()
    {
        return $this->Covered;
    }
    /**
     * Set Covered value
     * @param bool $covered
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setCovered($covered = null)
    {
        // validation for constraint: boolean
        if (!is_null($covered) && !is_bool($covered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($covered)), __LINE__);
        }
        $this->Covered = $covered;
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCoverageLimitType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
