<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocation StructType
 * @package Dg
 * @subpackage Structs
 */
class DgConnectionLocation extends DgLocationType
{
    /**
     * The _
     * @var \dgsoft\StructType\DgLocationType
     */
    public $_;
    /**
     * The Inclusive
     * Meta informations extracted from the WSDL
     * - default: true
     * @var bool
     */
    public $Inclusive;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The MinChangeTime
     * @var int
     */
    public $MinChangeTime;
    /**
     * The ConnectionInfo
     * @var string
     */
    public $ConnectionInfo;
    /**
     * The MultiAirportCityInd
     * @var bool
     */
    public $MultiAirportCityInd;
    /**
     * Constructor method for ConnectionLocation
     * @uses DgConnectionLocation::set_()
     * @uses DgConnectionLocation::setInclusive()
     * @uses DgConnectionLocation::setPreferLevel()
     * @uses DgConnectionLocation::setMinChangeTime()
     * @uses DgConnectionLocation::setConnectionInfo()
     * @uses DgConnectionLocation::setMultiAirportCityInd()
     * @param \dgsoft\StructType\DgLocationType $_
     * @param bool $inclusive
     * @param string $preferLevel
     * @param int $minChangeTime
     * @param string $connectionInfo
     * @param bool $multiAirportCityInd
     */
    public function __construct(\dgsoft\StructType\DgLocationType $_ = null, $inclusive = true, $preferLevel = 'Preferred', $minChangeTime = null, $connectionInfo = null, $multiAirportCityInd = null)
    {
        $this
            ->set_($_)
            ->setInclusive($inclusive)
            ->setPreferLevel($preferLevel)
            ->setMinChangeTime($minChangeTime)
            ->setConnectionInfo($connectionInfo)
            ->setMultiAirportCityInd($multiAirportCityInd);
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgLocationType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgLocationType $_
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public function set_(\dgsoft\StructType\DgLocationType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public function setInclusive($inclusive = true)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get MinChangeTime value
     * @return int|null
     */
    public function getMinChangeTime()
    {
        return $this->MinChangeTime;
    }
    /**
     * Set MinChangeTime value
     * @param int $minChangeTime
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public function setMinChangeTime($minChangeTime = null)
    {
        // validation for constraint: int
        if (!is_null($minChangeTime) && !is_numeric($minChangeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minChangeTime)), __LINE__);
        }
        $this->MinChangeTime = $minChangeTime;
        return $this;
    }
    /**
     * Get ConnectionInfo value
     * @return string|null
     */
    public function getConnectionInfo()
    {
        return $this->ConnectionInfo;
    }
    /**
     * Set ConnectionInfo value
     * @param string $connectionInfo
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public function setConnectionInfo($connectionInfo = null)
    {
        // validation for constraint: string
        if (!is_null($connectionInfo) && !is_string($connectionInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connectionInfo)), __LINE__);
        }
        $this->ConnectionInfo = $connectionInfo;
        return $this;
    }
    /**
     * Get MultiAirportCityInd value
     * @return bool|null
     */
    public function getMultiAirportCityInd()
    {
        return $this->MultiAirportCityInd;
    }
    /**
     * Set MultiAirportCityInd value
     * @param bool $multiAirportCityInd
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public function setMultiAirportCityInd($multiAirportCityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiAirportCityInd) && !is_bool($multiAirportCityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($multiAirportCityInd)), __LINE__);
        }
        $this->MultiAirportCityInd = $multiAirportCityInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgConnectionLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
