<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyNamePrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCompanyNamePrefType extends DgCompanyNameType
{
    /**
     * The _
     * @var \dgsoft\StructType\DgCompanyNameType
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * Constructor method for CompanyNamePrefType
     * @uses DgCompanyNamePrefType::set_()
     * @uses DgCompanyNamePrefType::setPreferLevel()
     * @param \dgsoft\StructType\DgCompanyNameType $_
     * @param string $preferLevel
     */
    public function __construct(\dgsoft\StructType\DgCompanyNameType $_ = null, $preferLevel = 'Preferred')
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel);
    }
    /**
     * Get _ value
     * @return \dgsoft\StructType\DgCompanyNameType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \dgsoft\StructType\DgCompanyNameType $_
     * @return \dgsoft\StructType\DgCompanyNamePrefType
     */
    public function set_(\dgsoft\StructType\DgCompanyNameType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgCompanyNamePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCompanyNamePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
