<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommunicationDetails StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCommunicationDetails extends DgBaseEntity
{
    /**
     * The Communications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCommunication
     */
    public $Communications;
    /**
     * The CommunicationHint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfCommunicationHint
     */
    public $CommunicationHint;
    /**
     * Constructor method for CommunicationDetails
     * @uses DgCommunicationDetails::setCommunications()
     * @uses DgCommunicationDetails::setCommunicationHint()
     * @param \dgsoft\ArrayType\DgArrayOfCommunication $communications
     * @param \dgsoft\ArrayType\DgArrayOfCommunicationHint $communicationHint
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfCommunication $communications = null, \dgsoft\ArrayType\DgArrayOfCommunicationHint $communicationHint = null)
    {
        $this
            ->setCommunications($communications)
            ->setCommunicationHint($communicationHint);
    }
    /**
     * Get Communications value
     * @return \dgsoft\ArrayType\DgArrayOfCommunication|null
     */
    public function getCommunications()
    {
        return $this->Communications;
    }
    /**
     * Set Communications value
     * @param \dgsoft\ArrayType\DgArrayOfCommunication $communications
     * @return \dgsoft\StructType\DgCommunicationDetails
     */
    public function setCommunications(\dgsoft\ArrayType\DgArrayOfCommunication $communications = null)
    {
        $this->Communications = $communications;
        return $this;
    }
    /**
     * Get CommunicationHint value
     * @return \dgsoft\ArrayType\DgArrayOfCommunicationHint|null
     */
    public function getCommunicationHint()
    {
        return $this->CommunicationHint;
    }
    /**
     * Set CommunicationHint value
     * @param \dgsoft\ArrayType\DgArrayOfCommunicationHint $communicationHint
     * @return \dgsoft\StructType\DgCommunicationDetails
     */
    public function setCommunicationHint(\dgsoft\ArrayType\DgArrayOfCommunicationHint $communicationHint = null)
    {
        $this->CommunicationHint = $communicationHint;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCommunicationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
