<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonPrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCommonPrefType extends AbstractStructBase
{
    /**
     * The NamePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgNamePrefType[]
     */
    public $NamePref;
    /**
     * The PhonePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPhonePrefType[]
     */
    public $PhonePref;
    /**
     * The AddressPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAddressPrefType[]
     */
    public $AddressPref;
    /**
     * The PaymentFormPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPaymentFormPrefType[]
     */
    public $PaymentFormPref;
    /**
     * The InterestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInterestPrefType[]
     */
    public $InterestPref;
    /**
     * The InsurancePref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsurancePrefType[]
     */
    public $InsurancePref;
    /**
     * The SeatingPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSeatingPrefType[]
     */
    public $SeatingPref;
    /**
     * The TicketDistribPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketDistribPrefType[]
     */
    public $TicketDistribPref;
    /**
     * The MediaEntertainPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMediaEntertainPrefType[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPetInfoPrefType[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgMealPrefType[]
     */
    public $MealPref;
    /**
     * The LoyaltyPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLoyaltyPrefType[]
     */
    public $LoyaltyPref;
    /**
     * The SpecRequestPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSpecRequestPrefType[]
     */
    public $SpecRequestPref;
    /**
     * The RelatedTravelerPref
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRelatedTravelerPrefType[]
     */
    public $RelatedTravelerPref;
    /**
     * The TPA_Extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTPA_ExtensionsType
     */
    public $TPA_Extensions;
    /**
     * The ShareSynchInd
     * @var string
     */
    public $ShareSynchInd;
    /**
     * The ShareMarketInd
     * @var string
     */
    public $ShareMarketInd;
    /**
     * The SmokingAllowed
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $SmokingAllowed;
    /**
     * The PrimaryLangID
     * @var string
     */
    public $PrimaryLangID;
    /**
     * The AltLangID
     * @var string
     */
    public $AltLangID;
    /**
     * Constructor method for CommonPrefType
     * @uses DgCommonPrefType::setNamePref()
     * @uses DgCommonPrefType::setPhonePref()
     * @uses DgCommonPrefType::setAddressPref()
     * @uses DgCommonPrefType::setPaymentFormPref()
     * @uses DgCommonPrefType::setInterestPref()
     * @uses DgCommonPrefType::setInsurancePref()
     * @uses DgCommonPrefType::setSeatingPref()
     * @uses DgCommonPrefType::setTicketDistribPref()
     * @uses DgCommonPrefType::setMediaEntertainPref()
     * @uses DgCommonPrefType::setPetInfoPref()
     * @uses DgCommonPrefType::setMealPref()
     * @uses DgCommonPrefType::setLoyaltyPref()
     * @uses DgCommonPrefType::setSpecRequestPref()
     * @uses DgCommonPrefType::setRelatedTravelerPref()
     * @uses DgCommonPrefType::setTPA_Extensions()
     * @uses DgCommonPrefType::setShareSynchInd()
     * @uses DgCommonPrefType::setShareMarketInd()
     * @uses DgCommonPrefType::setSmokingAllowed()
     * @uses DgCommonPrefType::setPrimaryLangID()
     * @uses DgCommonPrefType::setAltLangID()
     * @param \dgsoft\StructType\DgNamePrefType[] $namePref
     * @param \dgsoft\StructType\DgPhonePrefType[] $phonePref
     * @param \dgsoft\StructType\DgAddressPrefType[] $addressPref
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @param \dgsoft\StructType\DgInterestPrefType[] $interestPref
     * @param \dgsoft\StructType\DgInsurancePrefType[] $insurancePref
     * @param \dgsoft\StructType\DgSeatingPrefType[] $seatingPref
     * @param \dgsoft\StructType\DgTicketDistribPrefType[] $ticketDistribPref
     * @param \dgsoft\StructType\DgMediaEntertainPrefType[] $mediaEntertainPref
     * @param \dgsoft\StructType\DgPetInfoPrefType[] $petInfoPref
     * @param \dgsoft\StructType\DgMealPrefType[] $mealPref
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @param \dgsoft\StructType\DgRelatedTravelerPrefType[] $relatedTravelerPref
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @param string $shareSynchInd
     * @param string $shareMarketInd
     * @param bool $smokingAllowed
     * @param string $primaryLangID
     * @param string $altLangID
     */
    public function __construct(array $namePref = array(), array $phonePref = array(), array $addressPref = array(), array $paymentFormPref = array(), array $interestPref = array(), array $insurancePref = array(), array $seatingPref = array(), array $ticketDistribPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $loyaltyPref = array(), array $specRequestPref = array(), array $relatedTravelerPref = array(), \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null, $shareSynchInd = null, $shareMarketInd = null, $smokingAllowed = false, $primaryLangID = null, $altLangID = null)
    {
        $this
            ->setNamePref($namePref)
            ->setPhonePref($phonePref)
            ->setAddressPref($addressPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setInterestPref($interestPref)
            ->setInsurancePref($insurancePref)
            ->setSeatingPref($seatingPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setSpecRequestPref($specRequestPref)
            ->setRelatedTravelerPref($relatedTravelerPref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setShareSynchInd($shareSynchInd)
            ->setShareMarketInd($shareMarketInd)
            ->setSmokingAllowed($smokingAllowed)
            ->setPrimaryLangID($primaryLangID)
            ->setAltLangID($altLangID);
    }
    /**
     * Get NamePref value
     * @return \dgsoft\StructType\DgNamePrefType[]|null
     */
    public function getNamePref()
    {
        return $this->NamePref;
    }
    /**
     * Set NamePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgNamePrefType[] $namePref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setNamePref(array $namePref = array())
    {
        foreach ($namePref as $commonPrefTypeNamePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeNamePrefItem instanceof \dgsoft\StructType\DgNamePrefType) {
                throw new \InvalidArgumentException(sprintf('The NamePref property can only contain items of \dgsoft\StructType\DgNamePrefType, "%s" given', is_object($commonPrefTypeNamePrefItem) ? get_class($commonPrefTypeNamePrefItem) : gettype($commonPrefTypeNamePrefItem)), __LINE__);
            }
        }
        $this->NamePref = $namePref;
        return $this;
    }
    /**
     * Add item to NamePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgNamePrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToNamePref(\dgsoft\StructType\DgNamePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgNamePrefType) {
            throw new \InvalidArgumentException(sprintf('The NamePref property can only contain items of \dgsoft\StructType\DgNamePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->NamePref[] = $item;
        return $this;
    }
    /**
     * Get PhonePref value
     * @return \dgsoft\StructType\DgPhonePrefType[]|null
     */
    public function getPhonePref()
    {
        return $this->PhonePref;
    }
    /**
     * Set PhonePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPhonePrefType[] $phonePref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setPhonePref(array $phonePref = array())
    {
        foreach ($phonePref as $commonPrefTypePhonePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePhonePrefItem instanceof \dgsoft\StructType\DgPhonePrefType) {
                throw new \InvalidArgumentException(sprintf('The PhonePref property can only contain items of \dgsoft\StructType\DgPhonePrefType, "%s" given', is_object($commonPrefTypePhonePrefItem) ? get_class($commonPrefTypePhonePrefItem) : gettype($commonPrefTypePhonePrefItem)), __LINE__);
            }
        }
        $this->PhonePref = $phonePref;
        return $this;
    }
    /**
     * Add item to PhonePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPhonePrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToPhonePref(\dgsoft\StructType\DgPhonePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPhonePrefType) {
            throw new \InvalidArgumentException(sprintf('The PhonePref property can only contain items of \dgsoft\StructType\DgPhonePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PhonePref[] = $item;
        return $this;
    }
    /**
     * Get AddressPref value
     * @return \dgsoft\StructType\DgAddressPrefType[]|null
     */
    public function getAddressPref()
    {
        return $this->AddressPref;
    }
    /**
     * Set AddressPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressPrefType[] $addressPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setAddressPref(array $addressPref = array())
    {
        foreach ($addressPref as $commonPrefTypeAddressPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeAddressPrefItem instanceof \dgsoft\StructType\DgAddressPrefType) {
                throw new \InvalidArgumentException(sprintf('The AddressPref property can only contain items of \dgsoft\StructType\DgAddressPrefType, "%s" given', is_object($commonPrefTypeAddressPrefItem) ? get_class($commonPrefTypeAddressPrefItem) : gettype($commonPrefTypeAddressPrefItem)), __LINE__);
            }
        }
        $this->AddressPref = $addressPref;
        return $this;
    }
    /**
     * Add item to AddressPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgAddressPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToAddressPref(\dgsoft\StructType\DgAddressPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgAddressPrefType) {
            throw new \InvalidArgumentException(sprintf('The AddressPref property can only contain items of \dgsoft\StructType\DgAddressPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AddressPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return \dgsoft\StructType\DgPaymentFormPrefType[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType[] $paymentFormPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        foreach ($paymentFormPref as $commonPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePaymentFormPrefItem instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
                throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($commonPrefTypePaymentFormPrefItem) ? get_class($commonPrefTypePaymentFormPrefItem) : gettype($commonPrefTypePaymentFormPrefItem)), __LINE__);
            }
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPaymentFormPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToPaymentFormPref(\dgsoft\StructType\DgPaymentFormPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPaymentFormPrefType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of \dgsoft\StructType\DgPaymentFormPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get InterestPref value
     * @return \dgsoft\StructType\DgInterestPrefType[]|null
     */
    public function getInterestPref()
    {
        return $this->InterestPref;
    }
    /**
     * Set InterestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgInterestPrefType[] $interestPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setInterestPref(array $interestPref = array())
    {
        foreach ($interestPref as $commonPrefTypeInterestPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeInterestPrefItem instanceof \dgsoft\StructType\DgInterestPrefType) {
                throw new \InvalidArgumentException(sprintf('The InterestPref property can only contain items of \dgsoft\StructType\DgInterestPrefType, "%s" given', is_object($commonPrefTypeInterestPrefItem) ? get_class($commonPrefTypeInterestPrefItem) : gettype($commonPrefTypeInterestPrefItem)), __LINE__);
            }
        }
        $this->InterestPref = $interestPref;
        return $this;
    }
    /**
     * Add item to InterestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgInterestPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToInterestPref(\dgsoft\StructType\DgInterestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgInterestPrefType) {
            throw new \InvalidArgumentException(sprintf('The InterestPref property can only contain items of \dgsoft\StructType\DgInterestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InterestPref[] = $item;
        return $this;
    }
    /**
     * Get InsurancePref value
     * @return \dgsoft\StructType\DgInsurancePrefType[]|null
     */
    public function getInsurancePref()
    {
        return $this->InsurancePref;
    }
    /**
     * Set InsurancePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgInsurancePrefType[] $insurancePref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setInsurancePref(array $insurancePref = array())
    {
        foreach ($insurancePref as $commonPrefTypeInsurancePrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeInsurancePrefItem instanceof \dgsoft\StructType\DgInsurancePrefType) {
                throw new \InvalidArgumentException(sprintf('The InsurancePref property can only contain items of \dgsoft\StructType\DgInsurancePrefType, "%s" given', is_object($commonPrefTypeInsurancePrefItem) ? get_class($commonPrefTypeInsurancePrefItem) : gettype($commonPrefTypeInsurancePrefItem)), __LINE__);
            }
        }
        $this->InsurancePref = $insurancePref;
        return $this;
    }
    /**
     * Add item to InsurancePref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgInsurancePrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToInsurancePref(\dgsoft\StructType\DgInsurancePrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgInsurancePrefType) {
            throw new \InvalidArgumentException(sprintf('The InsurancePref property can only contain items of \dgsoft\StructType\DgInsurancePrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InsurancePref[] = $item;
        return $this;
    }
    /**
     * Get SeatingPref value
     * @return \dgsoft\StructType\DgSeatingPrefType[]|null
     */
    public function getSeatingPref()
    {
        return $this->SeatingPref;
    }
    /**
     * Set SeatingPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSeatingPrefType[] $seatingPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setSeatingPref(array $seatingPref = array())
    {
        foreach ($seatingPref as $commonPrefTypeSeatingPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeSeatingPrefItem instanceof \dgsoft\StructType\DgSeatingPrefType) {
                throw new \InvalidArgumentException(sprintf('The SeatingPref property can only contain items of \dgsoft\StructType\DgSeatingPrefType, "%s" given', is_object($commonPrefTypeSeatingPrefItem) ? get_class($commonPrefTypeSeatingPrefItem) : gettype($commonPrefTypeSeatingPrefItem)), __LINE__);
            }
        }
        $this->SeatingPref = $seatingPref;
        return $this;
    }
    /**
     * Add item to SeatingPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSeatingPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToSeatingPref(\dgsoft\StructType\DgSeatingPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSeatingPrefType) {
            throw new \InvalidArgumentException(sprintf('The SeatingPref property can only contain items of \dgsoft\StructType\DgSeatingPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SeatingPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return \dgsoft\StructType\DgTicketDistribPrefType[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketDistribPrefType[] $ticketDistribPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        foreach ($ticketDistribPref as $commonPrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeTicketDistribPrefItem instanceof \dgsoft\StructType\DgTicketDistribPrefType) {
                throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \dgsoft\StructType\DgTicketDistribPrefType, "%s" given', is_object($commonPrefTypeTicketDistribPrefItem) ? get_class($commonPrefTypeTicketDistribPrefItem) : gettype($commonPrefTypeTicketDistribPrefItem)), __LINE__);
            }
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketDistribPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToTicketDistribPref(\dgsoft\StructType\DgTicketDistribPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTicketDistribPrefType) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of \dgsoft\StructType\DgTicketDistribPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return \dgsoft\StructType\DgMediaEntertainPrefType[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMediaEntertainPrefType[] $mediaEntertainPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        foreach ($mediaEntertainPref as $commonPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeMediaEntertainPrefItem instanceof \dgsoft\StructType\DgMediaEntertainPrefType) {
                throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \dgsoft\StructType\DgMediaEntertainPrefType, "%s" given', is_object($commonPrefTypeMediaEntertainPrefItem) ? get_class($commonPrefTypeMediaEntertainPrefItem) : gettype($commonPrefTypeMediaEntertainPrefItem)), __LINE__);
            }
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMediaEntertainPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToMediaEntertainPref(\dgsoft\StructType\DgMediaEntertainPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMediaEntertainPrefType) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of \dgsoft\StructType\DgMediaEntertainPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return \dgsoft\StructType\DgPetInfoPrefType[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPetInfoPrefType[] $petInfoPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        foreach ($petInfoPref as $commonPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypePetInfoPrefItem instanceof \dgsoft\StructType\DgPetInfoPrefType) {
                throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \dgsoft\StructType\DgPetInfoPrefType, "%s" given', is_object($commonPrefTypePetInfoPrefItem) ? get_class($commonPrefTypePetInfoPrefItem) : gettype($commonPrefTypePetInfoPrefItem)), __LINE__);
            }
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgPetInfoPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToPetInfoPref(\dgsoft\StructType\DgPetInfoPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgPetInfoPrefType) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of \dgsoft\StructType\DgPetInfoPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return \dgsoft\StructType\DgMealPrefType[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMealPrefType[] $mealPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        foreach ($mealPref as $commonPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeMealPrefItem instanceof \dgsoft\StructType\DgMealPrefType) {
                throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \dgsoft\StructType\DgMealPrefType, "%s" given', is_object($commonPrefTypeMealPrefItem) ? get_class($commonPrefTypeMealPrefItem) : gettype($commonPrefTypeMealPrefItem)), __LINE__);
            }
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgMealPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToMealPref(\dgsoft\StructType\DgMealPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgMealPrefType) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of \dgsoft\StructType\DgMealPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return \dgsoft\StructType\DgLoyaltyPrefType[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType[] $loyaltyPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        foreach ($loyaltyPref as $commonPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeLoyaltyPrefItem instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
                throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($commonPrefTypeLoyaltyPrefItem) ? get_class($commonPrefTypeLoyaltyPrefItem) : gettype($commonPrefTypeLoyaltyPrefItem)), __LINE__);
            }
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgLoyaltyPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToLoyaltyPref(\dgsoft\StructType\DgLoyaltyPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgLoyaltyPrefType) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of \dgsoft\StructType\DgLoyaltyPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return \dgsoft\StructType\DgSpecRequestPrefType[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType[] $specRequestPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        foreach ($specRequestPref as $commonPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeSpecRequestPrefItem instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
                throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($commonPrefTypeSpecRequestPrefItem) ? get_class($commonPrefTypeSpecRequestPrefItem) : gettype($commonPrefTypeSpecRequestPrefItem)), __LINE__);
            }
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgSpecRequestPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToSpecRequestPref(\dgsoft\StructType\DgSpecRequestPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgSpecRequestPrefType) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of \dgsoft\StructType\DgSpecRequestPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get RelatedTravelerPref value
     * @return \dgsoft\StructType\DgRelatedTravelerPrefType[]|null
     */
    public function getRelatedTravelerPref()
    {
        return $this->RelatedTravelerPref;
    }
    /**
     * Set RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRelatedTravelerPrefType[] $relatedTravelerPref
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setRelatedTravelerPref(array $relatedTravelerPref = array())
    {
        foreach ($relatedTravelerPref as $commonPrefTypeRelatedTravelerPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeRelatedTravelerPrefItem instanceof \dgsoft\StructType\DgRelatedTravelerPrefType) {
                throw new \InvalidArgumentException(sprintf('The RelatedTravelerPref property can only contain items of \dgsoft\StructType\DgRelatedTravelerPrefType, "%s" given', is_object($commonPrefTypeRelatedTravelerPrefItem) ? get_class($commonPrefTypeRelatedTravelerPrefItem) : gettype($commonPrefTypeRelatedTravelerPrefItem)), __LINE__);
            }
        }
        $this->RelatedTravelerPref = $relatedTravelerPref;
        return $this;
    }
    /**
     * Add item to RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgRelatedTravelerPrefType $item
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function addToRelatedTravelerPref(\dgsoft\StructType\DgRelatedTravelerPrefType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgRelatedTravelerPrefType) {
            throw new \InvalidArgumentException(sprintf('The RelatedTravelerPref property can only contain items of \dgsoft\StructType\DgRelatedTravelerPrefType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RelatedTravelerPref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return \dgsoft\StructType\DgTPA_ExtensionsType|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param \dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setTPA_Extensions(\dgsoft\StructType\DgTPA_ExtensionsType $tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ShareSynchInd value
     * @return string|null
     */
    public function getShareSynchInd()
    {
        return $this->ShareSynchInd;
    }
    /**
     * Set ShareSynchInd value
     * @param string $shareSynchInd
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setShareSynchInd($shareSynchInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareSynchInd) && !is_string($shareSynchInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareSynchInd)), __LINE__);
        }
        $this->ShareSynchInd = $shareSynchInd;
        return $this;
    }
    /**
     * Get ShareMarketInd value
     * @return string|null
     */
    public function getShareMarketInd()
    {
        return $this->ShareMarketInd;
    }
    /**
     * Set ShareMarketInd value
     * @param string $shareMarketInd
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setShareMarketInd($shareMarketInd = null)
    {
        // validation for constraint: string
        if (!is_null($shareMarketInd) && !is_string($shareMarketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareMarketInd)), __LINE__);
        }
        $this->ShareMarketInd = $shareMarketInd;
        return $this;
    }
    /**
     * Get SmokingAllowed value
     * @return bool|null
     */
    public function getSmokingAllowed()
    {
        return $this->SmokingAllowed;
    }
    /**
     * Set SmokingAllowed value
     * @param bool $smokingAllowed
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setSmokingAllowed($smokingAllowed = false)
    {
        // validation for constraint: boolean
        if (!is_null($smokingAllowed) && !is_bool($smokingAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smokingAllowed)), __LINE__);
        }
        $this->SmokingAllowed = $smokingAllowed;
        return $this;
    }
    /**
     * Get PrimaryLangID value
     * @return string|null
     */
    public function getPrimaryLangID()
    {
        return $this->PrimaryLangID;
    }
    /**
     * Set PrimaryLangID value
     * @param string $primaryLangID
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setPrimaryLangID($primaryLangID = null)
    {
        // validation for constraint: string
        if (!is_null($primaryLangID) && !is_string($primaryLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryLangID)), __LINE__);
        }
        $this->PrimaryLangID = $primaryLangID;
        return $this;
    }
    /**
     * Get AltLangID value
     * @return string|null
     */
    public function getAltLangID()
    {
        return $this->AltLangID;
    }
    /**
     * Set AltLangID value
     * @param string $altLangID
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public function setAltLangID($altLangID = null)
    {
        // validation for constraint: string
        if (!is_null($altLangID) && !is_string($altLangID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($altLangID)), __LINE__);
        }
        $this->AltLangID = $altLangID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCommonPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
