<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionableAmount StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCommissionableAmount extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The TaxInclusiveIndicator
     * @var bool
     */
    public $TaxInclusiveIndicator;
    /**
     * Constructor method for CommissionableAmount
     * @uses DgCommissionableAmount::setAmount()
     * @uses DgCommissionableAmount::setTaxInclusiveIndicator()
     * @param float $amount
     * @param bool $taxInclusiveIndicator
     */
    public function __construct($amount = null, $taxInclusiveIndicator = null)
    {
        $this
            ->setAmount($amount)
            ->setTaxInclusiveIndicator($taxInclusiveIndicator);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \dgsoft\StructType\DgCommissionableAmount
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get TaxInclusiveIndicator value
     * @return bool|null
     */
    public function getTaxInclusiveIndicator()
    {
        return $this->TaxInclusiveIndicator;
    }
    /**
     * Set TaxInclusiveIndicator value
     * @param bool $taxInclusiveIndicator
     * @return \dgsoft\StructType\DgCommissionableAmount
     */
    public function setTaxInclusiveIndicator($taxInclusiveIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxInclusiveIndicator) && !is_bool($taxInclusiveIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($taxInclusiveIndicator)), __LINE__);
        }
        $this->TaxInclusiveIndicator = $taxInclusiveIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCommissionableAmount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
