<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommissionType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCommissionType extends AbstractStructBase
{
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $UniqueID;
    /**
     * The CommissionableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCommissionableAmount
     */
    public $CommissionableAmount;
    /**
     * The PrepaidAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPrepaidAmount
     */
    public $PrepaidAmount;
    /**
     * The FlatCommission
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlatCommission
     */
    public $FlatCommission;
    /**
     * The CommissionPayableAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCommissionPayableAmount
     */
    public $CommissionPayableAmount;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType
     */
    public $Comment;
    /**
     * The StatusType
     * @var string
     */
    public $StatusType;
    /**
     * The Percent
     * @var float
     */
    public $Percent;
    /**
     * The CurrencyCode
     * @var string
     */
    public $CurrencyCode;
    /**
     * The DecimalPlaces
     * @var int
     */
    public $DecimalPlaces;
    /**
     * The ReasonCode
     * @var string
     */
    public $ReasonCode;
    /**
     * The BillToID
     * @var string
     */
    public $BillToID;
    /**
     * The Frequency
     * @var string
     */
    public $Frequency;
    /**
     * The MaxCommissionUnitApplies
     * @var int
     */
    public $MaxCommissionUnitApplies;
    /**
     * The CapAmount
     * @var float
     */
    public $CapAmount;
    /**
     * Constructor method for CommissionType
     * @uses DgCommissionType::setUniqueID()
     * @uses DgCommissionType::setCommissionableAmount()
     * @uses DgCommissionType::setPrepaidAmount()
     * @uses DgCommissionType::setFlatCommission()
     * @uses DgCommissionType::setCommissionPayableAmount()
     * @uses DgCommissionType::setComment()
     * @uses DgCommissionType::setStatusType()
     * @uses DgCommissionType::setPercent()
     * @uses DgCommissionType::setCurrencyCode()
     * @uses DgCommissionType::setDecimalPlaces()
     * @uses DgCommissionType::setReasonCode()
     * @uses DgCommissionType::setBillToID()
     * @uses DgCommissionType::setFrequency()
     * @uses DgCommissionType::setMaxCommissionUnitApplies()
     * @uses DgCommissionType::setCapAmount()
     * @param \dgsoft\StructType\DgUniqueID_Type $uniqueID
     * @param \dgsoft\StructType\DgCommissionableAmount $commissionableAmount
     * @param \dgsoft\StructType\DgPrepaidAmount $prepaidAmount
     * @param \dgsoft\StructType\DgFlatCommission $flatCommission
     * @param \dgsoft\StructType\DgCommissionPayableAmount $commissionPayableAmount
     * @param \dgsoft\StructType\DgParagraphType $comment
     * @param string $statusType
     * @param float $percent
     * @param string $currencyCode
     * @param int $decimalPlaces
     * @param string $reasonCode
     * @param string $billToID
     * @param string $frequency
     * @param int $maxCommissionUnitApplies
     * @param float $capAmount
     */
    public function __construct(\dgsoft\StructType\DgUniqueID_Type $uniqueID = null, \dgsoft\StructType\DgCommissionableAmount $commissionableAmount = null, \dgsoft\StructType\DgPrepaidAmount $prepaidAmount = null, \dgsoft\StructType\DgFlatCommission $flatCommission = null, \dgsoft\StructType\DgCommissionPayableAmount $commissionPayableAmount = null, \dgsoft\StructType\DgParagraphType $comment = null, $statusType = null, $percent = null, $currencyCode = null, $decimalPlaces = null, $reasonCode = null, $billToID = null, $frequency = null, $maxCommissionUnitApplies = null, $capAmount = null)
    {
        $this
            ->setUniqueID($uniqueID)
            ->setCommissionableAmount($commissionableAmount)
            ->setPrepaidAmount($prepaidAmount)
            ->setFlatCommission($flatCommission)
            ->setCommissionPayableAmount($commissionPayableAmount)
            ->setComment($comment)
            ->setStatusType($statusType)
            ->setPercent($percent)
            ->setCurrencyCode($currencyCode)
            ->setDecimalPlaces($decimalPlaces)
            ->setReasonCode($reasonCode)
            ->setBillToID($billToID)
            ->setFrequency($frequency)
            ->setMaxCommissionUnitApplies($maxCommissionUnitApplies)
            ->setCapAmount($capAmount);
    }
    /**
     * Get UniqueID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \dgsoft\StructType\DgUniqueID_Type $uniqueID
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setUniqueID(\dgsoft\StructType\DgUniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CommissionableAmount value
     * @return \dgsoft\StructType\DgCommissionableAmount|null
     */
    public function getCommissionableAmount()
    {
        return $this->CommissionableAmount;
    }
    /**
     * Set CommissionableAmount value
     * @param \dgsoft\StructType\DgCommissionableAmount $commissionableAmount
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setCommissionableAmount(\dgsoft\StructType\DgCommissionableAmount $commissionableAmount = null)
    {
        $this->CommissionableAmount = $commissionableAmount;
        return $this;
    }
    /**
     * Get PrepaidAmount value
     * @return \dgsoft\StructType\DgPrepaidAmount|null
     */
    public function getPrepaidAmount()
    {
        return $this->PrepaidAmount;
    }
    /**
     * Set PrepaidAmount value
     * @param \dgsoft\StructType\DgPrepaidAmount $prepaidAmount
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setPrepaidAmount(\dgsoft\StructType\DgPrepaidAmount $prepaidAmount = null)
    {
        $this->PrepaidAmount = $prepaidAmount;
        return $this;
    }
    /**
     * Get FlatCommission value
     * @return \dgsoft\StructType\DgFlatCommission|null
     */
    public function getFlatCommission()
    {
        return $this->FlatCommission;
    }
    /**
     * Set FlatCommission value
     * @param \dgsoft\StructType\DgFlatCommission $flatCommission
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setFlatCommission(\dgsoft\StructType\DgFlatCommission $flatCommission = null)
    {
        $this->FlatCommission = $flatCommission;
        return $this;
    }
    /**
     * Get CommissionPayableAmount value
     * @return \dgsoft\StructType\DgCommissionPayableAmount|null
     */
    public function getCommissionPayableAmount()
    {
        return $this->CommissionPayableAmount;
    }
    /**
     * Set CommissionPayableAmount value
     * @param \dgsoft\StructType\DgCommissionPayableAmount $commissionPayableAmount
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setCommissionPayableAmount(\dgsoft\StructType\DgCommissionPayableAmount $commissionPayableAmount = null)
    {
        $this->CommissionPayableAmount = $commissionPayableAmount;
        return $this;
    }
    /**
     * Get Comment value
     * @return \dgsoft\StructType\DgParagraphType|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param \dgsoft\StructType\DgParagraphType $comment
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setComment(\dgsoft\StructType\DgParagraphType $comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get StatusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->StatusType;
    }
    /**
     * Set StatusType value
     * @param string $statusType
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusType)), __LINE__);
        }
        $this->StatusType = $statusType;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get DecimalPlaces value
     * @return int|null
     */
    public function getDecimalPlaces()
    {
        return $this->DecimalPlaces;
    }
    /**
     * Set DecimalPlaces value
     * @param int $decimalPlaces
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setDecimalPlaces($decimalPlaces = null)
    {
        // validation for constraint: int
        if (!is_null($decimalPlaces) && !is_numeric($decimalPlaces)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decimalPlaces)), __LINE__);
        }
        $this->DecimalPlaces = $decimalPlaces;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get BillToID value
     * @return string|null
     */
    public function getBillToID()
    {
        return $this->BillToID;
    }
    /**
     * Set BillToID value
     * @param string $billToID
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setBillToID($billToID = null)
    {
        // validation for constraint: string
        if (!is_null($billToID) && !is_string($billToID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billToID)), __LINE__);
        }
        $this->BillToID = $billToID;
        return $this;
    }
    /**
     * Get Frequency value
     * @return string|null
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param string $frequency
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: string
        if (!is_null($frequency) && !is_string($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get MaxCommissionUnitApplies value
     * @return int|null
     */
    public function getMaxCommissionUnitApplies()
    {
        return $this->MaxCommissionUnitApplies;
    }
    /**
     * Set MaxCommissionUnitApplies value
     * @param int $maxCommissionUnitApplies
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setMaxCommissionUnitApplies($maxCommissionUnitApplies = null)
    {
        // validation for constraint: int
        if (!is_null($maxCommissionUnitApplies) && !is_numeric($maxCommissionUnitApplies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxCommissionUnitApplies)), __LINE__);
        }
        $this->MaxCommissionUnitApplies = $maxCommissionUnitApplies;
        return $this;
    }
    /**
     * Get CapAmount value
     * @return float|null
     */
    public function getCapAmount()
    {
        return $this->CapAmount;
    }
    /**
     * Set CapAmount value
     * @param float $capAmount
     * @return \dgsoft\StructType\DgCommissionType
     */
    public function setCapAmount($capAmount = null)
    {
        $this->CapAmount = $capAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCommissionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
