<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeDetail StructType
 * @package Dg
 * @subpackage Structs
 */
class DgChangeDetail extends AbstractStructBase
{
    /**
     * The ChangeDetailAction
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ChangeDetailAction;
    /**
     * The SpecialRequests
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfSpecialRequestChange
     */
    public $SpecialRequests;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgPersonNameType
     */
    public $PersonName;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDocument
     */
    public $Document;
    /**
     * The SegmentIndex
     * @var int
     */
    public $SegmentIndex;
    /**
     * Constructor method for ChangeDetail
     * @uses DgChangeDetail::setChangeDetailAction()
     * @uses DgChangeDetail::setSpecialRequests()
     * @uses DgChangeDetail::setPersonName()
     * @uses DgChangeDetail::setDocument()
     * @uses DgChangeDetail::setSegmentIndex()
     * @param string $changeDetailAction
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRequestChange $specialRequests
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @param \dgsoft\StructType\DgDocument $document
     * @param int $segmentIndex
     */
    public function __construct($changeDetailAction = null, \dgsoft\ArrayType\DgArrayOfSpecialRequestChange $specialRequests = null, \dgsoft\StructType\DgPersonNameType $personName = null, \dgsoft\StructType\DgDocument $document = null, $segmentIndex = null)
    {
        $this
            ->setChangeDetailAction($changeDetailAction)
            ->setSpecialRequests($specialRequests)
            ->setPersonName($personName)
            ->setDocument($document)
            ->setSegmentIndex($segmentIndex);
    }
    /**
     * Get ChangeDetailAction value
     * @return string
     */
    public function getChangeDetailAction()
    {
        return $this->ChangeDetailAction;
    }
    /**
     * Set ChangeDetailAction value
     * @uses \dgsoft\EnumType\DgChangeDetailActionTypes::valueIsValid()
     * @uses \dgsoft\EnumType\DgChangeDetailActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changeDetailAction
     * @return \dgsoft\StructType\DgChangeDetail
     */
    public function setChangeDetailAction($changeDetailAction = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgChangeDetailActionTypes::valueIsValid($changeDetailAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $changeDetailAction, implode(', ', \dgsoft\EnumType\DgChangeDetailActionTypes::getValidValues())), __LINE__);
        }
        $this->ChangeDetailAction = $changeDetailAction;
        return $this;
    }
    /**
     * Get SpecialRequests value
     * @return \dgsoft\ArrayType\DgArrayOfSpecialRequestChange|null
     */
    public function getSpecialRequests()
    {
        return $this->SpecialRequests;
    }
    /**
     * Set SpecialRequests value
     * @param \dgsoft\ArrayType\DgArrayOfSpecialRequestChange $specialRequests
     * @return \dgsoft\StructType\DgChangeDetail
     */
    public function setSpecialRequests(\dgsoft\ArrayType\DgArrayOfSpecialRequestChange $specialRequests = null)
    {
        $this->SpecialRequests = $specialRequests;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \dgsoft\StructType\DgPersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \dgsoft\StructType\DgPersonNameType $personName
     * @return \dgsoft\StructType\DgChangeDetail
     */
    public function setPersonName(\dgsoft\StructType\DgPersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Document value
     * @return \dgsoft\StructType\DgDocument|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \dgsoft\StructType\DgDocument $document
     * @return \dgsoft\StructType\DgChangeDetail
     */
    public function setDocument(\dgsoft\StructType\DgDocument $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get SegmentIndex value
     * @return int|null
     */
    public function getSegmentIndex()
    {
        return $this->SegmentIndex;
    }
    /**
     * Set SegmentIndex value
     * @param int $segmentIndex
     * @return \dgsoft\StructType\DgChangeDetail
     */
    public function setSegmentIndex($segmentIndex = null)
    {
        // validation for constraint: int
        if (!is_null($segmentIndex) && !is_numeric($segmentIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($segmentIndex)), __LINE__);
        }
        $this->SegmentIndex = $segmentIndex;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgChangeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
