<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinPref StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCabinPref extends AbstractStructBase
{
    /**
     * The Cabin
     * @var string
     */
    public $Cabin;
    /**
     * The MajorityCabin
     * @var bool
     */
    public $MajorityCabin;
    /**
     * The MandatoryCabin
     * @var bool
     */
    public $MandatoryCabin;
    /**
     * The CabinSubtype
     * @var string
     */
    public $CabinSubtype;
    /**
     * Constructor method for CabinPref
     * @uses DgCabinPref::setCabin()
     * @uses DgCabinPref::setMajorityCabin()
     * @uses DgCabinPref::setMandatoryCabin()
     * @uses DgCabinPref::setCabinSubtype()
     * @param string $cabin
     * @param bool $majorityCabin
     * @param bool $mandatoryCabin
     * @param string $cabinSubtype
     */
    public function __construct($cabin = null, $majorityCabin = null, $mandatoryCabin = null, $cabinSubtype = null)
    {
        $this
            ->setCabin($cabin)
            ->setMajorityCabin($majorityCabin)
            ->setMandatoryCabin($mandatoryCabin)
            ->setCabinSubtype($cabinSubtype);
    }
    /**
     * Get Cabin value
     * @return string|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * Set Cabin value
     * @uses \dgsoft\EnumType\DgCabinType::valueIsValid()
     * @uses \dgsoft\EnumType\DgCabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabin
     * @return \dgsoft\StructType\DgCabinPref
     */
    public function setCabin($cabin = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCabinType::valueIsValid($cabin)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabin, implode(', ', \dgsoft\EnumType\DgCabinType::getValidValues())), __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Get MajorityCabin value
     * @return bool|null
     */
    public function getMajorityCabin()
    {
        return $this->MajorityCabin;
    }
    /**
     * Set MajorityCabin value
     * @param bool $majorityCabin
     * @return \dgsoft\StructType\DgCabinPref
     */
    public function setMajorityCabin($majorityCabin = null)
    {
        // validation for constraint: boolean
        if (!is_null($majorityCabin) && !is_bool($majorityCabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($majorityCabin)), __LINE__);
        }
        $this->MajorityCabin = $majorityCabin;
        return $this;
    }
    /**
     * Get MandatoryCabin value
     * @return bool|null
     */
    public function getMandatoryCabin()
    {
        return $this->MandatoryCabin;
    }
    /**
     * Set MandatoryCabin value
     * @param bool $mandatoryCabin
     * @return \dgsoft\StructType\DgCabinPref
     */
    public function setMandatoryCabin($mandatoryCabin = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryCabin) && !is_bool($mandatoryCabin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mandatoryCabin)), __LINE__);
        }
        $this->MandatoryCabin = $mandatoryCabin;
        return $this;
    }
    /**
     * Get CabinSubtype value
     * @return string|null
     */
    public function getCabinSubtype()
    {
        return $this->CabinSubtype;
    }
    /**
     * Set CabinSubtype value
     * @param string $cabinSubtype
     * @return \dgsoft\StructType\DgCabinPref
     */
    public function setCabinSubtype($cabinSubtype = null)
    {
        // validation for constraint: string
        if (!is_null($cabinSubtype) && !is_string($cabinSubtype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cabinSubtype)), __LINE__);
        }
        $this->CabinSubtype = $cabinSubtype;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCabinPref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
