<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCabinClassType extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CabinType;
    /**
     * The AirRows
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRowDetailsType
     */
    public $AirRows;
    /**
     * The AirColumns
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfColumnDetailsType
     */
    public $AirColumns;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CabinClassType
     * @uses DgCabinClassType::setCabinType()
     * @uses DgCabinClassType::setAirRows()
     * @uses DgCabinClassType::setAirColumns()
     * @uses DgCabinClassType::setName()
     * @param string $cabinType
     * @param \dgsoft\ArrayType\DgArrayOfRowDetailsType $airRows
     * @param \dgsoft\ArrayType\DgArrayOfColumnDetailsType $airColumns
     * @param string $name
     */
    public function __construct($cabinType = null, \dgsoft\ArrayType\DgArrayOfRowDetailsType $airRows = null, \dgsoft\ArrayType\DgArrayOfColumnDetailsType $airColumns = null, $name = null)
    {
        $this
            ->setCabinType($cabinType)
            ->setAirRows($airRows)
            ->setAirColumns($airColumns)
            ->setName($name);
    }
    /**
     * Get CabinType value
     * @return string
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \dgsoft\EnumType\DgCabinType::valueIsValid()
     * @uses \dgsoft\EnumType\DgCabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \dgsoft\StructType\DgCabinClassType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinType, implode(', ', \dgsoft\EnumType\DgCabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get AirRows value
     * @return \dgsoft\ArrayType\DgArrayOfRowDetailsType|null
     */
    public function getAirRows()
    {
        return $this->AirRows;
    }
    /**
     * Set AirRows value
     * @param \dgsoft\ArrayType\DgArrayOfRowDetailsType $airRows
     * @return \dgsoft\StructType\DgCabinClassType
     */
    public function setAirRows(\dgsoft\ArrayType\DgArrayOfRowDetailsType $airRows = null)
    {
        $this->AirRows = $airRows;
        return $this;
    }
    /**
     * Get AirColumns value
     * @return \dgsoft\ArrayType\DgArrayOfColumnDetailsType|null
     */
    public function getAirColumns()
    {
        return $this->AirColumns;
    }
    /**
     * Set AirColumns value
     * @param \dgsoft\ArrayType\DgArrayOfColumnDetailsType $airColumns
     * @return \dgsoft\StructType\DgCabinClassType
     */
    public function setAirColumns(\dgsoft\ArrayType\DgArrayOfColumnDetailsType $airColumns = null)
    {
        $this->AirColumns = $airColumns;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \dgsoft\StructType\DgCabinClassType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCabinClassType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
