<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinAvailabilityType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgCabinAvailabilityType extends AbstractStructBase
{
    /**
     * The CabinType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CabinType;
    /**
     * The Meal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCabinAvailabilityTypeMeal[]
     */
    public $Meal;
    /**
     * The BaggageAllowance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCabinAvailabilityTypeBaggageAllowance
     */
    public $BaggageAllowance;
    /**
     * Constructor method for CabinAvailabilityType
     * @uses DgCabinAvailabilityType::setCabinType()
     * @uses DgCabinAvailabilityType::setMeal()
     * @uses DgCabinAvailabilityType::setBaggageAllowance()
     * @param string $cabinType
     * @param \dgsoft\StructType\DgCabinAvailabilityTypeMeal[] $meal
     * @param \dgsoft\StructType\DgCabinAvailabilityTypeBaggageAllowance $baggageAllowance
     */
    public function __construct($cabinType = null, array $meal = array(), \dgsoft\StructType\DgCabinAvailabilityTypeBaggageAllowance $baggageAllowance = null)
    {
        $this
            ->setCabinType($cabinType)
            ->setMeal($meal)
            ->setBaggageAllowance($baggageAllowance);
    }
    /**
     * Get CabinType value
     * @return string
     */
    public function getCabinType()
    {
        return $this->CabinType;
    }
    /**
     * Set CabinType value
     * @uses \dgsoft\EnumType\DgCabinType::valueIsValid()
     * @uses \dgsoft\EnumType\DgCabinType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cabinType
     * @return \dgsoft\StructType\DgCabinAvailabilityType
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgCabinType::valueIsValid($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cabinType, implode(', ', \dgsoft\EnumType\DgCabinType::getValidValues())), __LINE__);
        }
        $this->CabinType = $cabinType;
        return $this;
    }
    /**
     * Get Meal value
     * @return \dgsoft\StructType\DgCabinAvailabilityTypeMeal[]|null
     */
    public function getMeal()
    {
        return $this->Meal;
    }
    /**
     * Set Meal value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinAvailabilityTypeMeal[] $meal
     * @return \dgsoft\StructType\DgCabinAvailabilityType
     */
    public function setMeal(array $meal = array())
    {
        foreach ($meal as $cabinAvailabilityTypeMealItem) {
            // validation for constraint: itemType
            if (!$cabinAvailabilityTypeMealItem instanceof \dgsoft\StructType\DgCabinAvailabilityTypeMeal) {
                throw new \InvalidArgumentException(sprintf('The Meal property can only contain items of \dgsoft\StructType\DgCabinAvailabilityTypeMeal, "%s" given', is_object($cabinAvailabilityTypeMealItem) ? get_class($cabinAvailabilityTypeMealItem) : gettype($cabinAvailabilityTypeMealItem)), __LINE__);
            }
        }
        $this->Meal = $meal;
        return $this;
    }
    /**
     * Add item to Meal value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCabinAvailabilityTypeMeal $item
     * @return \dgsoft\StructType\DgCabinAvailabilityType
     */
    public function addToMeal(\dgsoft\StructType\DgCabinAvailabilityTypeMeal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCabinAvailabilityTypeMeal) {
            throw new \InvalidArgumentException(sprintf('The Meal property can only contain items of \dgsoft\StructType\DgCabinAvailabilityTypeMeal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Meal[] = $item;
        return $this;
    }
    /**
     * Get BaggageAllowance value
     * @return \dgsoft\StructType\DgCabinAvailabilityTypeBaggageAllowance|null
     */
    public function getBaggageAllowance()
    {
        return $this->BaggageAllowance;
    }
    /**
     * Set BaggageAllowance value
     * @param \dgsoft\StructType\DgCabinAvailabilityTypeBaggageAllowance $baggageAllowance
     * @return \dgsoft\StructType\DgCabinAvailabilityType
     */
    public function setBaggageAllowance(\dgsoft\StructType\DgCabinAvailabilityTypeBaggageAllowance $baggageAllowance = null)
    {
        $this->BaggageAllowance = $baggageAllowance;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgCabinAvailabilityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
