<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingRule StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookingRule extends AbstractStructBase
{
    /**
     * The AcceptableGuarantees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee
     */
    public $AcceptableGuarantees;
    /**
     * The CancelPenalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCancelPenaltiesType
     */
    public $CancelPenalties;
    /**
     * The RequiredPaymts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment
     */
    public $RequiredPaymts;
    /**
     * The LengthsOfStay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgLengthsOfStayType
     */
    public $LengthsOfStay;
    /**
     * The DOW_Restrictions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgDOW_RestrictionsType
     */
    public $DOW_Restrictions;
    /**
     * The RestrictionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgRestrictionStatus
     */
    public $RestrictionStatus;
    /**
     * The Viewerships
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewership
     */
    public $Viewerships;
    /**
     * The AddtionalRules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule
     */
    public $AddtionalRules;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgParagraphType[]
     */
    public $Description;
    /**
     * The UniqueID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type
     */
    public $UniqueID;
    /**
     * The CheckoutCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCheckoutCharge[]
     */
    public $CheckoutCharge;
    /**
     * The URI
     * @var string
     */
    public $URI;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * The MaxAdvancedBookingOffset
     * @var string
     */
    public $MaxAdvancedBookingOffset;
    /**
     * The MinAdvancedBookingOffset
     * @var string
     */
    public $MinAdvancedBookingOffset;
    /**
     * The ForceGuaranteeOffset
     * @var string
     */
    public $ForceGuaranteeOffset;
    /**
     * The DepositWaiverOffset
     * @var string
     */
    public $DepositWaiverOffset;
    /**
     * The MinTotalOccupancy
     * @var int
     */
    public $MinTotalOccupancy;
    /**
     * The MaxTotalOccupancy
     * @var int
     */
    public $MaxTotalOccupancy;
    /**
     * The AbsoluteDropTime
     * @var string
     */
    public $AbsoluteDropTime;
    /**
     * The GenerallyBookable
     * @var bool
     */
    public $GenerallyBookable;
    /**
     * The PriceViewable
     * @var bool
     */
    public $PriceViewable;
    /**
     * The QualifiedRateYN
     * @var bool
     */
    public $QualifiedRateYN;
    /**
     * The AddressRequired
     * @var bool
     */
    public $AddressRequired;
    /**
     * The AbsoluteCutoff
     * @var string
     */
    public $AbsoluteCutoff;
    /**
     * The OffsetDuration
     * @var string
     */
    public $OffsetDuration;
    /**
     * The OffsetCalculationMode
     * @var string
     */
    public $OffsetCalculationMode;
    /**
     * The MaxContiguousBookings
     * @var int
     */
    public $MaxContiguousBookings;
    /**
     * Constructor method for BookingRule
     * @uses DgBookingRule::setAcceptableGuarantees()
     * @uses DgBookingRule::setCancelPenalties()
     * @uses DgBookingRule::setRequiredPaymts()
     * @uses DgBookingRule::setLengthsOfStay()
     * @uses DgBookingRule::setDOW_Restrictions()
     * @uses DgBookingRule::setRestrictionStatus()
     * @uses DgBookingRule::setViewerships()
     * @uses DgBookingRule::setAddtionalRules()
     * @uses DgBookingRule::setDescription()
     * @uses DgBookingRule::setUniqueID()
     * @uses DgBookingRule::setCheckoutCharge()
     * @uses DgBookingRule::setURI()
     * @uses DgBookingRule::setStart()
     * @uses DgBookingRule::setDuration()
     * @uses DgBookingRule::setEnd()
     * @uses DgBookingRule::setMaxAdvancedBookingOffset()
     * @uses DgBookingRule::setMinAdvancedBookingOffset()
     * @uses DgBookingRule::setForceGuaranteeOffset()
     * @uses DgBookingRule::setDepositWaiverOffset()
     * @uses DgBookingRule::setMinTotalOccupancy()
     * @uses DgBookingRule::setMaxTotalOccupancy()
     * @uses DgBookingRule::setAbsoluteDropTime()
     * @uses DgBookingRule::setGenerallyBookable()
     * @uses DgBookingRule::setPriceViewable()
     * @uses DgBookingRule::setQualifiedRateYN()
     * @uses DgBookingRule::setAddressRequired()
     * @uses DgBookingRule::setAbsoluteCutoff()
     * @uses DgBookingRule::setOffsetDuration()
     * @uses DgBookingRule::setOffsetCalculationMode()
     * @uses DgBookingRule::setMaxContiguousBookings()
     * @param \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee $acceptableGuarantees
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $requiredPaymts
     * @param \dgsoft\StructType\DgLengthsOfStayType $lengthsOfStay
     * @param \dgsoft\StructType\DgDOW_RestrictionsType $dOW_Restrictions
     * @param \dgsoft\StructType\DgRestrictionStatus $restrictionStatus
     * @param \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewership $viewerships
     * @param \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule $addtionalRules
     * @param \dgsoft\StructType\DgParagraphType[] $description
     * @param \dgsoft\StructType\DgUniqueID_Type $uniqueID
     * @param \dgsoft\StructType\DgCheckoutCharge[] $checkoutCharge
     * @param string $uRI
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $maxAdvancedBookingOffset
     * @param string $minAdvancedBookingOffset
     * @param string $forceGuaranteeOffset
     * @param string $depositWaiverOffset
     * @param int $minTotalOccupancy
     * @param int $maxTotalOccupancy
     * @param string $absoluteDropTime
     * @param bool $generallyBookable
     * @param bool $priceViewable
     * @param bool $qualifiedRateYN
     * @param bool $addressRequired
     * @param string $absoluteCutoff
     * @param string $offsetDuration
     * @param string $offsetCalculationMode
     * @param int $maxContiguousBookings
     */
    public function __construct(\dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee $acceptableGuarantees = null, \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null, \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $requiredPaymts = null, \dgsoft\StructType\DgLengthsOfStayType $lengthsOfStay = null, \dgsoft\StructType\DgDOW_RestrictionsType $dOW_Restrictions = null, \dgsoft\StructType\DgRestrictionStatus $restrictionStatus = null, \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewership $viewerships = null, \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule $addtionalRules = null, array $description = array(), \dgsoft\StructType\DgUniqueID_Type $uniqueID = null, array $checkoutCharge = array(), $uRI = null, $start = null, $duration = null, $end = null, $maxAdvancedBookingOffset = null, $minAdvancedBookingOffset = null, $forceGuaranteeOffset = null, $depositWaiverOffset = null, $minTotalOccupancy = null, $maxTotalOccupancy = null, $absoluteDropTime = null, $generallyBookable = null, $priceViewable = null, $qualifiedRateYN = null, $addressRequired = null, $absoluteCutoff = null, $offsetDuration = null, $offsetCalculationMode = null, $maxContiguousBookings = null)
    {
        $this
            ->setAcceptableGuarantees($acceptableGuarantees)
            ->setCancelPenalties($cancelPenalties)
            ->setRequiredPaymts($requiredPaymts)
            ->setLengthsOfStay($lengthsOfStay)
            ->setDOW_Restrictions($dOW_Restrictions)
            ->setRestrictionStatus($restrictionStatus)
            ->setViewerships($viewerships)
            ->setAddtionalRules($addtionalRules)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setCheckoutCharge($checkoutCharge)
            ->setURI($uRI)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setMaxAdvancedBookingOffset($maxAdvancedBookingOffset)
            ->setMinAdvancedBookingOffset($minAdvancedBookingOffset)
            ->setForceGuaranteeOffset($forceGuaranteeOffset)
            ->setDepositWaiverOffset($depositWaiverOffset)
            ->setMinTotalOccupancy($minTotalOccupancy)
            ->setMaxTotalOccupancy($maxTotalOccupancy)
            ->setAbsoluteDropTime($absoluteDropTime)
            ->setGenerallyBookable($generallyBookable)
            ->setPriceViewable($priceViewable)
            ->setQualifiedRateYN($qualifiedRateYN)
            ->setAddressRequired($addressRequired)
            ->setAbsoluteCutoff($absoluteCutoff)
            ->setOffsetDuration($offsetDuration)
            ->setOffsetCalculationMode($offsetCalculationMode)
            ->setMaxContiguousBookings($maxContiguousBookings);
    }
    /**
     * Get AcceptableGuarantees value
     * @return \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee|null
     */
    public function getAcceptableGuarantees()
    {
        return $this->AcceptableGuarantees;
    }
    /**
     * Set AcceptableGuarantees value
     * @param \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee $acceptableGuarantees
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setAcceptableGuarantees(\dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAcceptableGuarantee $acceptableGuarantees = null)
    {
        $this->AcceptableGuarantees = $acceptableGuarantees;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return \dgsoft\StructType\DgCancelPenaltiesType|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param \dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setCancelPenalties(\dgsoft\StructType\DgCancelPenaltiesType $cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RequiredPaymts value
     * @return \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment|null
     */
    public function getRequiredPaymts()
    {
        return $this->RequiredPaymts;
    }
    /**
     * Set RequiredPaymts value
     * @param \dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $requiredPaymts
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setRequiredPaymts(\dgsoft\ArrayType\DgArrayOfRequiredPaymentsTypeGuaranteePayment $requiredPaymts = null)
    {
        $this->RequiredPaymts = $requiredPaymts;
        return $this;
    }
    /**
     * Get LengthsOfStay value
     * @return \dgsoft\StructType\DgLengthsOfStayType|null
     */
    public function getLengthsOfStay()
    {
        return $this->LengthsOfStay;
    }
    /**
     * Set LengthsOfStay value
     * @param \dgsoft\StructType\DgLengthsOfStayType $lengthsOfStay
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setLengthsOfStay(\dgsoft\StructType\DgLengthsOfStayType $lengthsOfStay = null)
    {
        $this->LengthsOfStay = $lengthsOfStay;
        return $this;
    }
    /**
     * Get DOW_Restrictions value
     * @return \dgsoft\StructType\DgDOW_RestrictionsType|null
     */
    public function getDOW_Restrictions()
    {
        return $this->DOW_Restrictions;
    }
    /**
     * Set DOW_Restrictions value
     * @param \dgsoft\StructType\DgDOW_RestrictionsType $dOW_Restrictions
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setDOW_Restrictions(\dgsoft\StructType\DgDOW_RestrictionsType $dOW_Restrictions = null)
    {
        $this->DOW_Restrictions = $dOW_Restrictions;
        return $this;
    }
    /**
     * Get RestrictionStatus value
     * @return \dgsoft\StructType\DgRestrictionStatus|null
     */
    public function getRestrictionStatus()
    {
        return $this->RestrictionStatus;
    }
    /**
     * Set RestrictionStatus value
     * @param \dgsoft\StructType\DgRestrictionStatus $restrictionStatus
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setRestrictionStatus(\dgsoft\StructType\DgRestrictionStatus $restrictionStatus = null)
    {
        $this->RestrictionStatus = $restrictionStatus;
        return $this;
    }
    /**
     * Get Viewerships value
     * @return \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewership|null
     */
    public function getViewerships()
    {
        return $this->Viewerships;
    }
    /**
     * Set Viewerships value
     * @param \dgsoft\ArrayType\DgArrayOfViewershipsTypeViewership $viewerships
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setViewerships(\dgsoft\ArrayType\DgArrayOfViewershipsTypeViewership $viewerships = null)
    {
        $this->Viewerships = $viewerships;
        return $this;
    }
    /**
     * Get AddtionalRules value
     * @return \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule|null
     */
    public function getAddtionalRules()
    {
        return $this->AddtionalRules;
    }
    /**
     * Set AddtionalRules value
     * @param \dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule $addtionalRules
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setAddtionalRules(\dgsoft\ArrayType\DgArrayOfBookingRulesTypeBookingRuleAdditionalRule $addtionalRules = null)
    {
        $this->AddtionalRules = $addtionalRules;
        return $this;
    }
    /**
     * Get Description value
     * @return \dgsoft\StructType\DgParagraphType[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType[] $description
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setDescription(array $description = array())
    {
        foreach ($description as $bookingRuleDescriptionItem) {
            // validation for constraint: itemType
            if (!$bookingRuleDescriptionItem instanceof \dgsoft\StructType\DgParagraphType) {
                throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($bookingRuleDescriptionItem) ? get_class($bookingRuleDescriptionItem) : gettype($bookingRuleDescriptionItem)), __LINE__);
            }
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgParagraphType $item
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function addToDescription(\dgsoft\StructType\DgParagraphType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgParagraphType) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of \dgsoft\StructType\DgParagraphType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return \dgsoft\StructType\DgUniqueID_Type|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param \dgsoft\StructType\DgUniqueID_Type $uniqueID
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setUniqueID(\dgsoft\StructType\DgUniqueID_Type $uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CheckoutCharge value
     * @return \dgsoft\StructType\DgCheckoutCharge[]|null
     */
    public function getCheckoutCharge()
    {
        return $this->CheckoutCharge;
    }
    /**
     * Set CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCheckoutCharge[] $checkoutCharge
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setCheckoutCharge(array $checkoutCharge = array())
    {
        foreach ($checkoutCharge as $bookingRuleCheckoutChargeItem) {
            // validation for constraint: itemType
            if (!$bookingRuleCheckoutChargeItem instanceof \dgsoft\StructType\DgCheckoutCharge) {
                throw new \InvalidArgumentException(sprintf('The CheckoutCharge property can only contain items of \dgsoft\StructType\DgCheckoutCharge, "%s" given', is_object($bookingRuleCheckoutChargeItem) ? get_class($bookingRuleCheckoutChargeItem) : gettype($bookingRuleCheckoutChargeItem)), __LINE__);
            }
        }
        $this->CheckoutCharge = $checkoutCharge;
        return $this;
    }
    /**
     * Add item to CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgCheckoutCharge $item
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function addToCheckoutCharge(\dgsoft\StructType\DgCheckoutCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgCheckoutCharge) {
            throw new \InvalidArgumentException(sprintf('The CheckoutCharge property can only contain items of \dgsoft\StructType\DgCheckoutCharge, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CheckoutCharge[] = $item;
        return $this;
    }
    /**
     * Get URI value
     * @return string|null
     */
    public function getURI()
    {
        return $this->URI;
    }
    /**
     * Set URI value
     * @param string $uRI
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setURI($uRI = null)
    {
        // validation for constraint: string
        if (!is_null($uRI) && !is_string($uRI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uRI)), __LINE__);
        }
        $this->URI = $uRI;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get MaxAdvancedBookingOffset value
     * @return string|null
     */
    public function getMaxAdvancedBookingOffset()
    {
        return $this->MaxAdvancedBookingOffset;
    }
    /**
     * Set MaxAdvancedBookingOffset value
     * @param string $maxAdvancedBookingOffset
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setMaxAdvancedBookingOffset($maxAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvancedBookingOffset) && !is_string($maxAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maxAdvancedBookingOffset)), __LINE__);
        }
        $this->MaxAdvancedBookingOffset = $maxAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get MinAdvancedBookingOffset value
     * @return string|null
     */
    public function getMinAdvancedBookingOffset()
    {
        return $this->MinAdvancedBookingOffset;
    }
    /**
     * Set MinAdvancedBookingOffset value
     * @param string $minAdvancedBookingOffset
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setMinAdvancedBookingOffset($minAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvancedBookingOffset) && !is_string($minAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minAdvancedBookingOffset)), __LINE__);
        }
        $this->MinAdvancedBookingOffset = $minAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get ForceGuaranteeOffset value
     * @return string|null
     */
    public function getForceGuaranteeOffset()
    {
        return $this->ForceGuaranteeOffset;
    }
    /**
     * Set ForceGuaranteeOffset value
     * @param string $forceGuaranteeOffset
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setForceGuaranteeOffset($forceGuaranteeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($forceGuaranteeOffset) && !is_string($forceGuaranteeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($forceGuaranteeOffset)), __LINE__);
        }
        $this->ForceGuaranteeOffset = $forceGuaranteeOffset;
        return $this;
    }
    /**
     * Get DepositWaiverOffset value
     * @return string|null
     */
    public function getDepositWaiverOffset()
    {
        return $this->DepositWaiverOffset;
    }
    /**
     * Set DepositWaiverOffset value
     * @param string $depositWaiverOffset
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setDepositWaiverOffset($depositWaiverOffset = null)
    {
        // validation for constraint: string
        if (!is_null($depositWaiverOffset) && !is_string($depositWaiverOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositWaiverOffset)), __LINE__);
        }
        $this->DepositWaiverOffset = $depositWaiverOffset;
        return $this;
    }
    /**
     * Get MinTotalOccupancy value
     * @return int|null
     */
    public function getMinTotalOccupancy()
    {
        return $this->MinTotalOccupancy;
    }
    /**
     * Set MinTotalOccupancy value
     * @param int $minTotalOccupancy
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setMinTotalOccupancy($minTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minTotalOccupancy) && !is_numeric($minTotalOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minTotalOccupancy)), __LINE__);
        }
        $this->MinTotalOccupancy = $minTotalOccupancy;
        return $this;
    }
    /**
     * Get MaxTotalOccupancy value
     * @return int|null
     */
    public function getMaxTotalOccupancy()
    {
        return $this->MaxTotalOccupancy;
    }
    /**
     * Set MaxTotalOccupancy value
     * @param int $maxTotalOccupancy
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setMaxTotalOccupancy($maxTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxTotalOccupancy) && !is_numeric($maxTotalOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxTotalOccupancy)), __LINE__);
        }
        $this->MaxTotalOccupancy = $maxTotalOccupancy;
        return $this;
    }
    /**
     * Get AbsoluteDropTime value
     * @return string|null
     */
    public function getAbsoluteDropTime()
    {
        return $this->AbsoluteDropTime;
    }
    /**
     * Set AbsoluteDropTime value
     * @param string $absoluteDropTime
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setAbsoluteDropTime($absoluteDropTime = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDropTime) && !is_string($absoluteDropTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($absoluteDropTime)), __LINE__);
        }
        $this->AbsoluteDropTime = $absoluteDropTime;
        return $this;
    }
    /**
     * Get GenerallyBookable value
     * @return bool|null
     */
    public function getGenerallyBookable()
    {
        return $this->GenerallyBookable;
    }
    /**
     * Set GenerallyBookable value
     * @param bool $generallyBookable
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setGenerallyBookable($generallyBookable = null)
    {
        // validation for constraint: boolean
        if (!is_null($generallyBookable) && !is_bool($generallyBookable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($generallyBookable)), __LINE__);
        }
        $this->GenerallyBookable = $generallyBookable;
        return $this;
    }
    /**
     * Get PriceViewable value
     * @return bool|null
     */
    public function getPriceViewable()
    {
        return $this->PriceViewable;
    }
    /**
     * Set PriceViewable value
     * @param bool $priceViewable
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setPriceViewable($priceViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceViewable) && !is_bool($priceViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($priceViewable)), __LINE__);
        }
        $this->PriceViewable = $priceViewable;
        return $this;
    }
    /**
     * Get QualifiedRateYN value
     * @return bool|null
     */
    public function getQualifiedRateYN()
    {
        return $this->QualifiedRateYN;
    }
    /**
     * Set QualifiedRateYN value
     * @param bool $qualifiedRateYN
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setQualifiedRateYN($qualifiedRateYN = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifiedRateYN) && !is_bool($qualifiedRateYN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($qualifiedRateYN)), __LINE__);
        }
        $this->QualifiedRateYN = $qualifiedRateYN;
        return $this;
    }
    /**
     * Get AddressRequired value
     * @return bool|null
     */
    public function getAddressRequired()
    {
        return $this->AddressRequired;
    }
    /**
     * Set AddressRequired value
     * @param bool $addressRequired
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setAddressRequired($addressRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressRequired) && !is_bool($addressRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($addressRequired)), __LINE__);
        }
        $this->AddressRequired = $addressRequired;
        return $this;
    }
    /**
     * Get AbsoluteCutoff value
     * @return string|null
     */
    public function getAbsoluteCutoff()
    {
        return $this->AbsoluteCutoff;
    }
    /**
     * Set AbsoluteCutoff value
     * @param string $absoluteCutoff
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setAbsoluteCutoff($absoluteCutoff = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteCutoff) && !is_string($absoluteCutoff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($absoluteCutoff)), __LINE__);
        }
        $this->AbsoluteCutoff = $absoluteCutoff;
        return $this;
    }
    /**
     * Get OffsetDuration value
     * @return string|null
     */
    public function getOffsetDuration()
    {
        return $this->OffsetDuration;
    }
    /**
     * Set OffsetDuration value
     * @param string $offsetDuration
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setOffsetDuration($offsetDuration = null)
    {
        // validation for constraint: string
        if (!is_null($offsetDuration) && !is_string($offsetDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offsetDuration)), __LINE__);
        }
        $this->OffsetDuration = $offsetDuration;
        return $this;
    }
    /**
     * Get OffsetCalculationMode value
     * @return string|null
     */
    public function getOffsetCalculationMode()
    {
        return $this->OffsetCalculationMode;
    }
    /**
     * Set OffsetCalculationMode value
     * @param string $offsetCalculationMode
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setOffsetCalculationMode($offsetCalculationMode = null)
    {
        // validation for constraint: string
        if (!is_null($offsetCalculationMode) && !is_string($offsetCalculationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($offsetCalculationMode)), __LINE__);
        }
        $this->OffsetCalculationMode = $offsetCalculationMode;
        return $this;
    }
    /**
     * Get MaxContiguousBookings value
     * @return int|null
     */
    public function getMaxContiguousBookings()
    {
        return $this->MaxContiguousBookings;
    }
    /**
     * Set MaxContiguousBookings value
     * @param int $maxContiguousBookings
     * @return \dgsoft\StructType\DgBookingRule
     */
    public function setMaxContiguousBookings($maxContiguousBookings = null)
    {
        // validation for constraint: int
        if (!is_null($maxContiguousBookings) && !is_numeric($maxContiguousBookings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxContiguousBookings)), __LINE__);
        }
        $this->MaxContiguousBookings = $maxContiguousBookings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookingRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
