<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingChannelCodes StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookingChannelCodes extends AbstractStructBase
{
    /**
     * The BookingChannelCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgBookingChannelCode[]
     */
    public $BookingChannelCode;
    /**
     * The ChannelCodesInclusive
     * @var bool
     */
    public $ChannelCodesInclusive;
    /**
     * Constructor method for BookingChannelCodes
     * @uses DgBookingChannelCodes::setBookingChannelCode()
     * @uses DgBookingChannelCodes::setChannelCodesInclusive()
     * @param \dgsoft\StructType\DgBookingChannelCode[] $bookingChannelCode
     * @param bool $channelCodesInclusive
     */
    public function __construct(array $bookingChannelCode = array(), $channelCodesInclusive = null)
    {
        $this
            ->setBookingChannelCode($bookingChannelCode)
            ->setChannelCodesInclusive($channelCodesInclusive);
    }
    /**
     * Get BookingChannelCode value
     * @return \dgsoft\StructType\DgBookingChannelCode[]|null
     */
    public function getBookingChannelCode()
    {
        return $this->BookingChannelCode;
    }
    /**
     * Set BookingChannelCode value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBookingChannelCode[] $bookingChannelCode
     * @return \dgsoft\StructType\DgBookingChannelCodes
     */
    public function setBookingChannelCode(array $bookingChannelCode = array())
    {
        foreach ($bookingChannelCode as $bookingChannelCodesBookingChannelCodeItem) {
            // validation for constraint: itemType
            if (!$bookingChannelCodesBookingChannelCodeItem instanceof \dgsoft\StructType\DgBookingChannelCode) {
                throw new \InvalidArgumentException(sprintf('The BookingChannelCode property can only contain items of \dgsoft\StructType\DgBookingChannelCode, "%s" given', is_object($bookingChannelCodesBookingChannelCodeItem) ? get_class($bookingChannelCodesBookingChannelCodeItem) : gettype($bookingChannelCodesBookingChannelCodeItem)), __LINE__);
            }
        }
        $this->BookingChannelCode = $bookingChannelCode;
        return $this;
    }
    /**
     * Add item to BookingChannelCode value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgBookingChannelCode $item
     * @return \dgsoft\StructType\DgBookingChannelCodes
     */
    public function addToBookingChannelCode(\dgsoft\StructType\DgBookingChannelCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgBookingChannelCode) {
            throw new \InvalidArgumentException(sprintf('The BookingChannelCode property can only contain items of \dgsoft\StructType\DgBookingChannelCode, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingChannelCode[] = $item;
        return $this;
    }
    /**
     * Get ChannelCodesInclusive value
     * @return bool|null
     */
    public function getChannelCodesInclusive()
    {
        return $this->ChannelCodesInclusive;
    }
    /**
     * Set ChannelCodesInclusive value
     * @param bool $channelCodesInclusive
     * @return \dgsoft\StructType\DgBookingChannelCodes
     */
    public function setChannelCodesInclusive($channelCodesInclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($channelCodesInclusive) && !is_bool($channelCodesInclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($channelCodesInclusive)), __LINE__);
        }
        $this->ChannelCodesInclusive = $channelCodesInclusive;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookingChannelCodes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
