<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookBasketRS StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookBasketRS extends AbstractStructBase
{
    /**
     * The AirReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirReservation
     */
    public $AirReservation;
    /**
     * The InsuranceReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS
     */
    public $InsuranceReservation;
    /**
     * The HotelReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_HotelResRS
     */
    public $HotelReservation;
    /**
     * The CarReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgOTA_VehResRS
     */
    public $CarReservation;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The FullFilment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFullFilment
     */
    public $FullFilment;
    /**
     * The Warnings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgWarningsType
     */
    public $Warnings;
    /**
     * The Errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgErrorsType
     */
    public $Errors;
    /**
     * The Success
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgSuccessType
     */
    public $Success;
    /**
     * The BookingReferenceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgUniqueID_Type[]
     */
    public $BookingReferenceID;
    /**
     * The NewPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgAirItineraryPricingInfoType
     */
    public $NewPrice;
    /**
     * The Failback
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFailbackRS
     */
    public $Failback;
    /**
     * The Cancel
     * Meta informations extracted from the WSDL
     * - default: false
     * @var bool
     */
    public $Cancel;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * Constructor method for BookBasketRS
     * @uses DgBookBasketRS::setAirReservation()
     * @uses DgBookBasketRS::setInsuranceReservation()
     * @uses DgBookBasketRS::setHotelReservation()
     * @uses DgBookBasketRS::setCarReservation()
     * @uses DgBookBasketRS::setTravelerInfo()
     * @uses DgBookBasketRS::setFullFilment()
     * @uses DgBookBasketRS::setWarnings()
     * @uses DgBookBasketRS::setErrors()
     * @uses DgBookBasketRS::setSuccess()
     * @uses DgBookBasketRS::setBookingReferenceID()
     * @uses DgBookBasketRS::setNewPrice()
     * @uses DgBookBasketRS::setFailback()
     * @uses DgBookBasketRS::setCancel()
     * @uses DgBookBasketRS::setReferenceNumber()
     * @param \dgsoft\StructType\DgAirReservation $airReservation
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation
     * @param \dgsoft\StructType\DgOTA_HotelResRS $hotelReservation
     * @param \dgsoft\StructType\DgOTA_VehResRS $carReservation
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @param \dgsoft\StructType\DgFullFilment $fullFilment
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @param \dgsoft\StructType\DgSuccessType $success
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice
     * @param \dgsoft\StructType\DgFailbackRS $failback
     * @param bool $cancel
     * @param string $referenceNumber
     */
    public function __construct(\dgsoft\StructType\DgAirReservation $airReservation = null, \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation = null, \dgsoft\StructType\DgOTA_HotelResRS $hotelReservation = null, \dgsoft\StructType\DgOTA_VehResRS $carReservation = null, \dgsoft\StructType\DgTravelerInfoType $travelerInfo = null, \dgsoft\StructType\DgFullFilment $fullFilment = null, \dgsoft\StructType\DgWarningsType $warnings = null, \dgsoft\StructType\DgErrorsType $errors = null, \dgsoft\StructType\DgSuccessType $success = null, array $bookingReferenceID = array(), \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice = null, \dgsoft\StructType\DgFailbackRS $failback = null, $cancel = false, $referenceNumber = null)
    {
        $this
            ->setAirReservation($airReservation)
            ->setInsuranceReservation($insuranceReservation)
            ->setHotelReservation($hotelReservation)
            ->setCarReservation($carReservation)
            ->setTravelerInfo($travelerInfo)
            ->setFullFilment($fullFilment)
            ->setWarnings($warnings)
            ->setErrors($errors)
            ->setSuccess($success)
            ->setBookingReferenceID($bookingReferenceID)
            ->setNewPrice($newPrice)
            ->setFailback($failback)
            ->setCancel($cancel)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get AirReservation value
     * @return \dgsoft\StructType\DgAirReservation|null
     */
    public function getAirReservation()
    {
        return $this->AirReservation;
    }
    /**
     * Set AirReservation value
     * @param \dgsoft\StructType\DgAirReservation $airReservation
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setAirReservation(\dgsoft\StructType\DgAirReservation $airReservation = null)
    {
        $this->AirReservation = $airReservation;
        return $this;
    }
    /**
     * Get InsuranceReservation value
     * @return \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS|null
     */
    public function getInsuranceReservation()
    {
        return $this->InsuranceReservation;
    }
    /**
     * Set InsuranceReservation value
     * @param \dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setInsuranceReservation(\dgsoft\StructType\DgOTA_InsuranceBookRSPlanForBookRS $insuranceReservation = null)
    {
        $this->InsuranceReservation = $insuranceReservation;
        return $this;
    }
    /**
     * Get HotelReservation value
     * @return \dgsoft\StructType\DgOTA_HotelResRS|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * Set HotelReservation value
     * @param \dgsoft\StructType\DgOTA_HotelResRS $hotelReservation
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setHotelReservation(\dgsoft\StructType\DgOTA_HotelResRS $hotelReservation = null)
    {
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Get CarReservation value
     * @return \dgsoft\StructType\DgOTA_VehResRS|null
     */
    public function getCarReservation()
    {
        return $this->CarReservation;
    }
    /**
     * Set CarReservation value
     * @param \dgsoft\StructType\DgOTA_VehResRS $carReservation
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setCarReservation(\dgsoft\StructType\DgOTA_VehResRS $carReservation = null)
    {
        $this->CarReservation = $carReservation;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \dgsoft\StructType\DgTravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setTravelerInfo(\dgsoft\StructType\DgTravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get FullFilment value
     * @return \dgsoft\StructType\DgFullFilment|null
     */
    public function getFullFilment()
    {
        return $this->FullFilment;
    }
    /**
     * Set FullFilment value
     * @param \dgsoft\StructType\DgFullFilment $fullFilment
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setFullFilment(\dgsoft\StructType\DgFullFilment $fullFilment = null)
    {
        $this->FullFilment = $fullFilment;
        return $this;
    }
    /**
     * Get Warnings value
     * @return \dgsoft\StructType\DgWarningsType|null
     */
    public function getWarnings()
    {
        return $this->Warnings;
    }
    /**
     * Set Warnings value
     * @param \dgsoft\StructType\DgWarningsType $warnings
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setWarnings(\dgsoft\StructType\DgWarningsType $warnings = null)
    {
        $this->Warnings = $warnings;
        return $this;
    }
    /**
     * Get Errors value
     * @return \dgsoft\StructType\DgErrorsType|null
     */
    public function getErrors()
    {
        return $this->Errors;
    }
    /**
     * Set Errors value
     * @param \dgsoft\StructType\DgErrorsType $errors
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setErrors(\dgsoft\StructType\DgErrorsType $errors = null)
    {
        $this->Errors = $errors;
        return $this;
    }
    /**
     * Get Success value
     * @return \dgsoft\StructType\DgSuccessType|null
     */
    public function getSuccess()
    {
        return $this->Success;
    }
    /**
     * Set Success value
     * @param \dgsoft\StructType\DgSuccessType $success
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setSuccess(\dgsoft\StructType\DgSuccessType $success = null)
    {
        $this->Success = $success;
        return $this;
    }
    /**
     * Get BookingReferenceID value
     * @return \dgsoft\StructType\DgUniqueID_Type[]|null
     */
    public function getBookingReferenceID()
    {
        return $this->BookingReferenceID;
    }
    /**
     * Set BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type[] $bookingReferenceID
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setBookingReferenceID(array $bookingReferenceID = array())
    {
        foreach ($bookingReferenceID as $bookBasketRSBookingReferenceIDItem) {
            // validation for constraint: itemType
            if (!$bookBasketRSBookingReferenceIDItem instanceof \dgsoft\StructType\DgUniqueID_Type) {
                throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($bookBasketRSBookingReferenceIDItem) ? get_class($bookBasketRSBookingReferenceIDItem) : gettype($bookBasketRSBookingReferenceIDItem)), __LINE__);
            }
        }
        $this->BookingReferenceID = $bookingReferenceID;
        return $this;
    }
    /**
     * Add item to BookingReferenceID value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgUniqueID_Type $item
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function addToBookingReferenceID(\dgsoft\StructType\DgUniqueID_Type $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgUniqueID_Type) {
            throw new \InvalidArgumentException(sprintf('The BookingReferenceID property can only contain items of \dgsoft\StructType\DgUniqueID_Type, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BookingReferenceID[] = $item;
        return $this;
    }
    /**
     * Get NewPrice value
     * @return \dgsoft\StructType\DgAirItineraryPricingInfoType|null
     */
    public function getNewPrice()
    {
        return $this->NewPrice;
    }
    /**
     * Set NewPrice value
     * @param \dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setNewPrice(\dgsoft\StructType\DgAirItineraryPricingInfoType $newPrice = null)
    {
        $this->NewPrice = $newPrice;
        return $this;
    }
    /**
     * Get Failback value
     * @return \dgsoft\StructType\DgFailbackRS|null
     */
    public function getFailback()
    {
        return $this->Failback;
    }
    /**
     * Set Failback value
     * @param \dgsoft\StructType\DgFailbackRS $failback
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setFailback(\dgsoft\StructType\DgFailbackRS $failback = null)
    {
        $this->Failback = $failback;
        return $this;
    }
    /**
     * Get Cancel value
     * @return bool|null
     */
    public function getCancel()
    {
        return $this->Cancel;
    }
    /**
     * Set Cancel value
     * @param bool $cancel
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setCancel($cancel = false)
    {
        // validation for constraint: boolean
        if (!is_null($cancel) && !is_bool($cancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cancel)), __LINE__);
        }
        $this->Cancel = $cancel;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookBasketRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
