<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookBasketRQ StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBookBasketRQ extends AbstractStructBase
{
    /**
     * The FlightReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFlightReservation
     */
    public $FlightReservation;
    /**
     * The HotelReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgHotelReservation
     */
    public $HotelReservation;
    /**
     * The CarReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgCarReservation
     */
    public $CarReservation;
    /**
     * The InsuranceReservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgInsuranceReservation
     */
    public $InsuranceReservation;
    /**
     * The TravelerInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTravelerInfoType
     */
    public $TravelerInfo;
    /**
     * The Fulfillment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgFulfillment
     */
    public $Fulfillment;
    /**
     * The Ticketing
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \dgsoft\StructType\DgTicketingInfoType[]
     */
    public $Ticketing;
    /**
     * The PNRRemarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo
     */
    public $PNRRemarks;
    /**
     * The ReferenceNumber
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The ControlNumber
     * @var string
     */
    public $ControlNumber;
    /**
     * The CorporatePinNumber
     * @var string
     */
    public $CorporatePinNumber;
    /**
     * Constructor method for BookBasketRQ
     * @uses DgBookBasketRQ::setFlightReservation()
     * @uses DgBookBasketRQ::setHotelReservation()
     * @uses DgBookBasketRQ::setCarReservation()
     * @uses DgBookBasketRQ::setInsuranceReservation()
     * @uses DgBookBasketRQ::setTravelerInfo()
     * @uses DgBookBasketRQ::setFulfillment()
     * @uses DgBookBasketRQ::setTicketing()
     * @uses DgBookBasketRQ::setPNRRemarks()
     * @uses DgBookBasketRQ::setReferenceNumber()
     * @uses DgBookBasketRQ::setControlNumber()
     * @uses DgBookBasketRQ::setCorporatePinNumber()
     * @param \dgsoft\StructType\DgFlightReservation $flightReservation
     * @param \dgsoft\StructType\DgHotelReservation $hotelReservation
     * @param \dgsoft\StructType\DgCarReservation $carReservation
     * @param \dgsoft\StructType\DgInsuranceReservation $insuranceReservation
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @param \dgsoft\StructType\DgFulfillment $fulfillment
     * @param \dgsoft\StructType\DgTicketingInfoType[] $ticketing
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks
     * @param string $referenceNumber
     * @param string $controlNumber
     * @param string $corporatePinNumber
     */
    public function __construct(\dgsoft\StructType\DgFlightReservation $flightReservation = null, \dgsoft\StructType\DgHotelReservation $hotelReservation = null, \dgsoft\StructType\DgCarReservation $carReservation = null, \dgsoft\StructType\DgInsuranceReservation $insuranceReservation = null, \dgsoft\StructType\DgTravelerInfoType $travelerInfo = null, \dgsoft\StructType\DgFulfillment $fulfillment = null, array $ticketing = array(), \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks = null, $referenceNumber = null, $controlNumber = null, $corporatePinNumber = null)
    {
        $this
            ->setFlightReservation($flightReservation)
            ->setHotelReservation($hotelReservation)
            ->setCarReservation($carReservation)
            ->setInsuranceReservation($insuranceReservation)
            ->setTravelerInfo($travelerInfo)
            ->setFulfillment($fulfillment)
            ->setTicketing($ticketing)
            ->setPNRRemarks($pNRRemarks)
            ->setReferenceNumber($referenceNumber)
            ->setControlNumber($controlNumber)
            ->setCorporatePinNumber($corporatePinNumber);
    }
    /**
     * Get FlightReservation value
     * @return \dgsoft\StructType\DgFlightReservation|null
     */
    public function getFlightReservation()
    {
        return $this->FlightReservation;
    }
    /**
     * Set FlightReservation value
     * @param \dgsoft\StructType\DgFlightReservation $flightReservation
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setFlightReservation(\dgsoft\StructType\DgFlightReservation $flightReservation = null)
    {
        $this->FlightReservation = $flightReservation;
        return $this;
    }
    /**
     * Get HotelReservation value
     * @return \dgsoft\StructType\DgHotelReservation|null
     */
    public function getHotelReservation()
    {
        return $this->HotelReservation;
    }
    /**
     * Set HotelReservation value
     * @param \dgsoft\StructType\DgHotelReservation $hotelReservation
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setHotelReservation(\dgsoft\StructType\DgHotelReservation $hotelReservation = null)
    {
        $this->HotelReservation = $hotelReservation;
        return $this;
    }
    /**
     * Get CarReservation value
     * @return \dgsoft\StructType\DgCarReservation|null
     */
    public function getCarReservation()
    {
        return $this->CarReservation;
    }
    /**
     * Set CarReservation value
     * @param \dgsoft\StructType\DgCarReservation $carReservation
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setCarReservation(\dgsoft\StructType\DgCarReservation $carReservation = null)
    {
        $this->CarReservation = $carReservation;
        return $this;
    }
    /**
     * Get InsuranceReservation value
     * @return \dgsoft\StructType\DgInsuranceReservation|null
     */
    public function getInsuranceReservation()
    {
        return $this->InsuranceReservation;
    }
    /**
     * Set InsuranceReservation value
     * @param \dgsoft\StructType\DgInsuranceReservation $insuranceReservation
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setInsuranceReservation(\dgsoft\StructType\DgInsuranceReservation $insuranceReservation = null)
    {
        $this->InsuranceReservation = $insuranceReservation;
        return $this;
    }
    /**
     * Get TravelerInfo value
     * @return \dgsoft\StructType\DgTravelerInfoType|null
     */
    public function getTravelerInfo()
    {
        return $this->TravelerInfo;
    }
    /**
     * Set TravelerInfo value
     * @param \dgsoft\StructType\DgTravelerInfoType $travelerInfo
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setTravelerInfo(\dgsoft\StructType\DgTravelerInfoType $travelerInfo = null)
    {
        $this->TravelerInfo = $travelerInfo;
        return $this;
    }
    /**
     * Get Fulfillment value
     * @return \dgsoft\StructType\DgFulfillment|null
     */
    public function getFulfillment()
    {
        return $this->Fulfillment;
    }
    /**
     * Set Fulfillment value
     * @param \dgsoft\StructType\DgFulfillment $fulfillment
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setFulfillment(\dgsoft\StructType\DgFulfillment $fulfillment = null)
    {
        $this->Fulfillment = $fulfillment;
        return $this;
    }
    /**
     * Get Ticketing value
     * @return \dgsoft\StructType\DgTicketingInfoType[]|null
     */
    public function getTicketing()
    {
        return $this->Ticketing;
    }
    /**
     * Set Ticketing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketingInfoType[] $ticketing
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setTicketing(array $ticketing = array())
    {
        foreach ($ticketing as $bookBasketRQTicketingItem) {
            // validation for constraint: itemType
            if (!$bookBasketRQTicketingItem instanceof \dgsoft\StructType\DgTicketingInfoType) {
                throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of \dgsoft\StructType\DgTicketingInfoType, "%s" given', is_object($bookBasketRQTicketingItem) ? get_class($bookBasketRQTicketingItem) : gettype($bookBasketRQTicketingItem)), __LINE__);
            }
        }
        $this->Ticketing = $ticketing;
        return $this;
    }
    /**
     * Add item to Ticketing value
     * @throws \InvalidArgumentException
     * @param \dgsoft\StructType\DgTicketingInfoType $item
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function addToTicketing(\dgsoft\StructType\DgTicketingInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \dgsoft\StructType\DgTicketingInfoType) {
            throw new \InvalidArgumentException(sprintf('The Ticketing property can only contain items of \dgsoft\StructType\DgTicketingInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Ticketing[] = $item;
        return $this;
    }
    /**
     * Get PNRRemarks value
     * @return \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo|null
     */
    public function getPNRRemarks()
    {
        return $this->PNRRemarks;
    }
    /**
     * Set PNRRemarks value
     * @param \dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setPNRRemarks(\dgsoft\ArrayType\DgArrayOfPNRRemarkInfo $pNRRemarks = null)
    {
        $this->PNRRemarks = $pNRRemarks;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ControlNumber value
     * @return string|null
     */
    public function getControlNumber()
    {
        return $this->ControlNumber;
    }
    /**
     * Set ControlNumber value
     * @param string $controlNumber
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setControlNumber($controlNumber = null)
    {
        // validation for constraint: string
        if (!is_null($controlNumber) && !is_string($controlNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($controlNumber)), __LINE__);
        }
        $this->ControlNumber = $controlNumber;
        return $this;
    }
    /**
     * Get CorporatePinNumber value
     * @return string|null
     */
    public function getCorporatePinNumber()
    {
        return $this->CorporatePinNumber;
    }
    /**
     * Set CorporatePinNumber value
     * @param string $corporatePinNumber
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public function setCorporatePinNumber($corporatePinNumber = null)
    {
        // validation for constraint: string
        if (!is_null($corporatePinNumber) && !is_string($corporatePinNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($corporatePinNumber)), __LINE__);
        }
        $this->CorporatePinNumber = $corporatePinNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBookBasketRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
