<?php

namespace dgsoft\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BedTypePrefType StructType
 * @package Dg
 * @subpackage Structs
 */
class DgBedTypePrefType extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The PreferLevel
     * Meta informations extracted from the WSDL
     * - default: Preferred
     * @var string
     */
    public $PreferLevel;
    /**
     * The BedType
     * @var string
     */
    public $BedType;
    /**
     * Constructor method for BedTypePrefType
     * @uses DgBedTypePrefType::set_()
     * @uses DgBedTypePrefType::setPreferLevel()
     * @uses DgBedTypePrefType::setBedType()
     * @param string $_
     * @param string $preferLevel
     * @param string $bedType
     */
    public function __construct($_ = null, $preferLevel = 'Preferred', $bedType = null)
    {
        $this
            ->set_($_)
            ->setPreferLevel($preferLevel)
            ->setBedType($bedType);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \dgsoft\StructType\DgBedTypePrefType
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \dgsoft\EnumType\DgPreferLevelType::valueIsValid()
     * @uses \dgsoft\EnumType\DgPreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \dgsoft\StructType\DgBedTypePrefType
     */
    public function setPreferLevel($preferLevel = 'Preferred')
    {
        // validation for constraint: enumeration
        if (!\dgsoft\EnumType\DgPreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preferLevel, implode(', ', \dgsoft\EnumType\DgPreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get BedType value
     * @return string|null
     */
    public function getBedType()
    {
        return $this->BedType;
    }
    /**
     * Set BedType value
     * @param string $bedType
     * @return \dgsoft\StructType\DgBedTypePrefType
     */
    public function setBedType($bedType = null)
    {
        // validation for constraint: string
        if (!is_null($bedType) && !is_string($bedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bedType)), __LINE__);
        }
        $this->BedType = $bedType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \dgsoft\StructType\DgBedTypePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
